% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SaveDataFile.R
\name{SaveDataFile}
\alias{SaveDataFile}
\title{Save ROC data file in a different format}
\usage{
SaveDataFile(dataset, fileName, format = "JAFROC",
  dataDscrpt = paste0(deparse(substitute(dataset)), " Data File"))
}
\arguments{
\item{dataset}{The dataset object to be saved in the specified format, see \link{RJafroc-package}.}

\item{fileName}{The file name of the output data file. The extension of the data file must match the corresponding format, see \link{RJafroc-package}.}

\item{format}{The format of the data file, which can be \code{JAFROC}, \code{MRMC} or \code{iMRMC}, see \link{RJafroc-package}.}

\item{dataDscrpt}{An optional string variable describing the data file, the default value is the variable name of \code{dataset}.
The decription appears on the first line of *.lrc or *imrmc data file. This parameter is not used when saving dataset in other formats.}
}
\description{
Save ROC data file in a different format so it can be analyzed with alternate software.
}
\examples{
SaveDataFile(dataset = rocData, fileName = "rocData2.xlsx", format = "JAFROC")
SaveDataFile(dataset = rocData, fileName = "rocData2.csv", format = "MRMC")
SaveDataFile(dataset = rocData, fileName = "rocData2.lrc", format = "MRMC",
             dataDscrpt = "ExampleROCdata")
SaveDataFile(dataset = rocData, fileName = "rocData2.txt", format = "MRMC",
             dataDscrpt = "ExampleROCdata2")
SaveDataFile(dataset = rocData, fileName = "rocData.imrmc", format = "iMRMC",
             dataDscrpt = "ExampleROCdata3")
}

