% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SsPowerGivenJK.R
\name{SsPowerGivenJK}
\alias{SsPowerGivenJK}
\title{Statistical power for specified numbers of readers and cases in an ROC study}
\usage{
SsPowerGivenJK(dataset, J, K, method = "DBMH", option = "ALL",
  alpha = 0.05, ...)
}
\arguments{
\item{dataset}{The \bold{pilot} ROC dataset to be used to extrapolate to the \bold{pivotal} study. If 
missing, then variance components and effectSize must be passed as additional parameters.}

\item{J}{The number of readers in the pivotal study.}

\item{K}{The number of cases in the pivotal study.}

\item{method}{"DBMH" or "ORH".}

\item{option}{Desired generalization, "RRRC", "FRRC", "RRFC" or "ALL" (the default).}

\item{alpha}{The significance level, default is 0.05.}

\item{...}{Other parameters, OR or DBM variance components, passed internally, see details}
}
\value{
The expected statistical power.
}
\description{
Calculate the statistical power for specified numbers of readers J, 
   cases K, analysis method and DBM or OR variances components
}
\details{
Other parameters \code{...} are reserved for internal use.
}
\examples{
## An example of sample size calculation with DBM variance componements
SsPowerGivenJK(dataset02, 6, 251, method = "DBMH")
                     
## An example of sample size calculation with OR variance componements.
SsPowerGivenJK(dataset02, 6, 251, method = "ORH")

}
\references{
Hillis SL, Obuchowski NA, Berbaum KS (2011). Power Estimation for Multireader ROC Methods: 
An Updated and Unified Approach. Acad Radiol, 18, 129--142.

Hillis SL, Obuchowski NA, Schartz KM, Berbaum KS (2005). A comparison of the Dorfman-Berbaum-Metz 
and Obuchowski-Rockette methods for receiver operating characteristic (ROC) data. 
Statistics in Medicine, 24(10), 1579--607.

Chakraborty DP (2017) \emph{Observer Performance Methods for Diagnostic Imaging - Foundations, 
Modeling, and Applications with R-Based Examples}, CRC Press, Boca Raton, FL. 
\url{https://www.crcpress.com/Observer-Performance-Methods-for-Diagnostic-Imaging-Foundations-Modeling/Chakraborty/p/book/9781482214840}
}
