% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SsPowerGivenJK.R
\name{SsPowerGivenJKOrVarComp}
\alias{SsPowerGivenJKOrVarComp}
\title{Power given J, K and Obuchowski-Rockette variance components}
\usage{
SsPowerGivenJKOrVarComp(
  J,
  K,
  KStar,
  effectSize,
  varTR,
  cov1,
  cov2,
  cov3,
  varEps,
  alpha = 0.05,
  option
)
}
\arguments{
\item{J}{The number of readers in the \strong{pivotal} study}

\item{K}{The number of cases in the \strong{pivotal} study}

\item{KStar}{The number of cases in the \strong{pilot} study}

\item{effectSize}{The effect size}

\item{varTR}{The treatment-reader OR variance component}

\item{cov1}{The OR cov1 covariance}

\item{cov2}{The OR cov2 covariance}

\item{cov3}{The OR cov3 covariance}

\item{varEps}{The OR pure variance term}

\item{alpha}{The size of the test (default = 0.05)}

\item{option}{The desired generalization ("RRRC", "FRRC", "RRFC", "ALL")}
}
\value{
A list object containing the estimated power and associated statistics
   for each desired generalization.
}
\description{
Power given J, K and Obuchowski-Rockette variance components
}
\details{
The variance components are obtained using \link{StSignificanceTesting} 
    with \code{method = "ORH"}.
}
\examples{
dataset <- dataset02 ## the pilot study
KStar <- length(dataset$NL[1,1,,1])
VarComp <- StSignificanceTesting(dataset, FOM = "Wilcoxon", method = "ORH", option = "RRRC")$varComp
varTR <- VarComp$varTR
cov1 <- VarComp$cov1
cov2 <- VarComp$cov2
cov3 <- VarComp$cov3
varEps <- VarComp$var
ret <- SsPowerGivenJKOrVarComp (J = 5, K = 100, KStar = KStar,  
   effectSize = 0.05, varTR, cov1, cov2, cov3, varEps, option = "RRRC")
    
cat("RRRC power = ", ret$powerRRRC)

  
}
