% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitCbmRoc.R
\name{FitCbmRoc}
\alias{FitCbmRoc}
\title{Fit the contaminated binormal model (CBM) to selected treatment and 
   reader in an ROC dataset}
\usage{
FitCbmRoc(dataset, trt = 1, rdr = 1)
}
\arguments{
\item{dataset}{The dataset containing the data}

\item{trt}{The desired treatment, default is 1}

\item{rdr}{The desired reader, default is 1}
}
\value{
The return value is a list with the following elements:

\item{mu}{The mean of the visible diseased distribution (the non-diseased)
   has zero mean}

\item{alpha}{The proportion of diseased cases where the disease is visible}

\item{zetas}{The cutoffs, zetas or thresholds}

\item{AUC}{The AUC of the fitted ROC curve}

\item{StdAUC}{The standard deviation of AUC}

\item{NLLIni}{The initial value of negative LL}

\item{NLLFin}{The final value of negative LL}

\item{ChisqrFitStats}{The chisquare goodness of fit results}

\item{covMat}{The covariance matrix of the parameters}

\item{fittedPlot}{A \pkg{ggplot2} object containing the fitted 
   operating characteristic along with the empirical operating points. 
   Use \code{print()} to display the object}
}
\description{
Fit the CBM-predicted ROC curve for specified treatment and reader
}
\details{
In  CBM ratings from diseased cases are sampled from a mixture distribution 
   with two components: (1) distributed normal with mean \eqn{mu} and unit 
   variance with integrated area \eqn{alpha}, and (2) from a unit-normal 
   distribution with integrated area \eqn{1-alpha}. Ratings for non-diseased 
   cases are sampled from a unit-normal distribution. The 
   \code{ChisqrFitStats} consists of a list containing the chi-square value, 
   the p-value and the degrees of freedom.
}
\note{
This algorithm is very robust, much more so than the binormal model.
}
\examples{

\donttest{
## CPU time 8.7 sec on Ubuntu (#13)
## Test with included ROC data
retFit <- FitCbmRoc(dataset02);## print(retFit$fittedPlot)

## Test with included degenerate ROC data (yes! CBM can fit such data)
retFit <- FitCbmRoc(datasetDegenerate);## print(retFit$fittedPlot)

## Test with single interior point data
fp <- c(rep(1,7), rep(2, 3))
tp <- c(rep(1,5), rep(2, 5))
dataset <- Df2RJafrocDataset(fp, tp)
retFit <- FitCbmRoc(dataset);## print(retFit$fittedPlot)

## Test with two interior data points
fp <- c(rep(1,7), rep(2, 5), rep(3, 3))
tp <- c(rep(1,3), rep(2, 5), rep(3, 7))
dataset <- Df2RJafrocDataset(fp, tp)
retFit <- FitCbmRoc(dataset);
## print(retFit$fittedPlot)

## Test with included ROC data (some bins have zero counts)
retFit <- FitCbmRoc(dataset02, 2, 1);## print(retFit$fittedPlot)

## Test with TONY data for which chisqr can be calculated
ds <- DfFroc2Roc(dataset01)
retFit <- FitCbmRoc(ds, 2, 3);## print(retFit$fittedPlot)
retFit$ChisqrFitStats
}

}
\references{
Dorfman DD, Berbaum KS (2000) A contaminated binormal model for ROC data: Part II. A formal model,
Acad Radiol, 7:6, 427--437.
}
