% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset14}
\alias{dataset14}
\title{Federica Zanca real (as opposed to inferred) ROC dataset}
\format{
A list with 3 elements: \code{$ratings}, \code{$lesions} and \code{$descriptions}; \code{$ratings}
   contain 3 elements, \code{$NL}, \code{$LL} and \code{$LL_IL} as sub-lists; \code{$lesions}
   contain 3 elements, \code{$perCase}, \code{$IDs} and \code{$weights} as sub-lists; \code{$descriptions}
   contain 7 elements, \code{$fileName}, \code{$type}, \code{$name},
   \code{$truthTableStr}, \code{$design}, \code{$modalityID} and \code{$readerID} as sub-lists;
\itemize{
\item{\code{rating$NL}}{, num [1:2, 1:4, 1:200, 1], ratings of non-lesion localizations, NLs}
\item{\code{rating$LL}}{, num [1:2, 1:4, 1:100, 1], ratings of lesion localizations, LLs}
\item{\code{rating$LL_IL}}{NA, this placeholder is used only for LROC data}
\item{\code{lesions$perCase}}{, int [1:100], number of lesions per diseased case}
\item{\code{lesions$IDs}}{, num [1:100, 1] , numeric labels of lesions on diseased cases}
\item{\code{lesions$weights}}{, num [1:100, 1], weights (or clinical importances) of lesions}
\item{\code{descriptions$fileName}}{, chr, "dataset14", base name of dataset in `data` folder}
\item{\code{descriptions$type}}{, chr "ROC", the data type}
\item{\code{descriptions$name}}{, chr "FEDERICA-REAL-ROC", the name of the dataset}
\item{\code{descriptions$truthTableStr}}{, num [1:2, 1:4, 1:200, 1:2], truth table structure}
\item{\code{descriptions$design}}{, chr "FCTRL", study design, factorial dataset}
\item{\code{descriptions$modalityID}}{, chr [1:2] "4" "5", treatment label(s)}
\item{\code{descriptions$readerID}}{, chr [1:4] "1" "2" "3" "4", reader labels}
}
}
\usage{
dataset14
}
\description{
This is referred to in the book as the "FZR" dataset. It is a real ROC study, 
conducted on the same images and using the same radiologists, on treatments
"4" and "5" of dataset04. This was compared to highest rating inferred ROC
data from dataset04 to conclude, erroneously, that the highest rating assumption
is invalid. See book Section 13.6.2.
}
\examples{
str(dataset14)


}
\references{
Zanca F, Hillis SL, Claus F, et al (2012) Correlation of free-response and 
receiver-operating-characteristic area-under-the-curve estimates: Results from 
independently conducted FROC/ROC studies in mammography. 
Med Phys. 39(10):5917-5929.
}
\keyword{datasets}
