% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{datasetDegenerate}
\alias{datasetDegenerate}
\title{Simulated degenerate ROC dataset (for testing purposes)}
\format{
A list with 3 elements: \code{$ratings}, \code{$lesions} and \code{$descriptions}; \code{$ratings}
   contain 3 elements, \code{$NL}, \code{$LL} and \code{$LL_IL} as sub-lists; \code{$lesions}
   contain 3 elements, \code{$perCase}, \code{$IDs} and \code{$weights} as sub-lists; \code{$descriptions}
   contain 7 elements, \code{$fileName}, \code{$type}, \code{$name},
   \code{$truthTableStr}, \code{$design}, \code{$modalityID} and \code{$readerID} as sub-lists;
\itemize{
\item{\code{rating$NL}}{, num [1, 1, 1:15, 1], ratings of non-lesion localizations, NLs}
\item{\code{rating$LL}}{, num [1, 1, 1:10, 1], ratings of lesion localizations, LLs}
\item{\code{rating$LL_IL}}{NA, this placeholder is used only for LROC data}
\item{\code{lesions$perCase}}{, int [1:10], number of lesions per diseased case}
\item{\code{lesions$IDs}}{, num [1:10, 1] , numeric labels of lesions on diseased cases}
\item{\code{lesions$weights}}{, num [1:10, 1], weights (or clinical importances) of lesions}
\item{\code{descriptions$fileName}}{, chr, "datasetDegenerate", base name of dataset in `data` folder}
\item{\code{descriptions$type}}{, chr "ROC", the data type}
\item{\code{descriptions$name}}{, chr "SIM-DEGENERATE", the name of the dataset}
\item{\code{descriptions$truthTableStr}}{, NA, truth table structure}
\item{\code{descriptions$design}}{, chr "FCTRL-X-MOD", study design, factorial dataset}
\item{\code{descriptions$modalityID}}{, chr "1", treatment label(s)}
\item{\code{descriptions$readerID}}{, chr "1", reader labels}
}
}
\usage{
datasetDegenerate
}
\description{
A simulated degenerated dataset. A degenerate dataset is defined as one with
no interior operating points on the ROC plot. Such data tend to be observed with expert level 
radiologists. This dataset is used to illustrate the robustness of two fitting models, namely
CBM and RSM. The widely used binormal model and PROPROC fail on such datasets.
}
\examples{
str(datasetDegenerate)


}
\keyword{datasets}
