% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FUNC_AMI_calculations.R
\name{Mutual_Information}
\alias{Mutual_Information}
\title{Mutual_Information}
\usage{
Mutual_Information(v1, v2)
}
\arguments{
\item{v1}{vector containing first classification labels}

\item{v2}{vector containing second classification labels}
}
\value{
Returns mutual information:\tabular{ll}{
   \code{nmi} \tab NMI value \cr
   \tab \cr
   \code{ami} \tab AMI value \cr
}
}
\description{
Calculates normalized mutual information and adjusted mutual information. The value for both will be 
a value bewteen 0 and 1 that measures how close the classification between the two clusters is. 
A value closer to 1 means the labels are more similar across v1 and v2, and a value closer to 0 means
the labels are not as similar.
}
\details{
See these links for a more formal definition of \href{https://en.wikipedia.org/wiki/Adjusted_mutual_information}{AMI}
and \href{https://en.wikipedia.org/wiki/Mutual_information}{NMI}.
}
\examples{
cluster1 <- sample(1:5, size = 10, replace = TRUE)
cluster2 <- sample(1:2, size = 10, replace = TRUE)
Mutual_Information(cluster1, cluster2)
}
