/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri.impl;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIComponents;
import com.hp.hpl.jena.iri.ViolationCodes;
import com.hp.hpl.jena.iri.impl.AbsIRIFactoryImpl;
import com.hp.hpl.jena.iri.impl.AbsIRIImpl;
import com.hp.hpl.jena.iri.impl.Force;
import com.hp.hpl.jena.iri.impl.Parser;
import com.hp.hpl.jena.iri.impl.SchemeSpecificPart;
import com.hp.hpl.jena.iri.impl.SchemeSpecification;
import com.hp.hpl.jena.iri.impl.Specification;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IRIFactoryImpl
extends AbsIRIFactoryImpl
implements ViolationCodes,
Force,
IRIComponents {
    public static final int UNKNOWN_SYNTAX = -4;
    protected long errors;
    protected long warnings;
    private String encoding = "utf-8";
    boolean[] asErrors;
    boolean[] asWarnings;
    private boolean initializing;
    private boolean backwardCompatibleRelativeRefs;
    private final NoScheme noScheme;
    private int required;
    private int prohibited;
    private final Map schemes;

    public IRIFactoryImpl() {
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        blArray[1] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        this.asErrors = blArray;
        boolean[] blArray2 = new boolean[6];
        blArray2[2] = true;
        this.asWarnings = blArray2;
        this.initializing = true;
        this.backwardCompatibleRelativeRefs = false;
        this.noScheme = new NoScheme();
        this.required = 0;
        this.prohibited = 0;
        this.schemes = new HashMap();
    }

    public IRIFactoryImpl(IRIFactoryImpl template) {
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        blArray[1] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        this.asErrors = blArray;
        boolean[] blArray2 = new boolean[6];
        blArray2[2] = true;
        this.asWarnings = blArray2;
        this.initializing = true;
        this.backwardCompatibleRelativeRefs = false;
        this.noScheme = new NoScheme();
        this.required = 0;
        this.prohibited = 0;
        this.schemes = new HashMap();
        this.backwardCompatibleRelativeRefs = template.backwardCompatibleRelativeRefs;
        this.encoding = template.encoding;
        this.errors = template.errors;
        this.prohibited = template.prohibited;
        this.required = template.required;
        this.warnings = template.warnings;
        System.arraycopy(template.asErrors, 0, this.asErrors, 0, this.asErrors.length);
        System.arraycopy(template.asWarnings, 0, this.asWarnings, 0, this.asWarnings.length);
        Iterator it = template.schemes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            SchemeSpecificPart p = (SchemeSpecificPart)entry.getValue();
            if (p.withScheme()) {
                this.schemes.put(entry.getKey(), new WithScheme((WithScheme)p));
                continue;
            }
            if (p.port() == -1) continue;
            this.schemes.put(entry.getKey(), new NoScheme(p.port()));
        }
    }

    private final long getMask(boolean includeWarnings) {
        return includeWarnings ? this.errors | this.warnings : this.errors;
    }

    protected IRIFactoryImpl getFactory() {
        return this;
    }

    public IRI create(IRI i) {
        if (i instanceof AbsIRIImpl && ((AbsIRIImpl)i).getFactory() == this) {
            return i;
        }
        return this.create(i.toString());
    }

    boolean getSameSchemaRelativeReferences() {
        return this.backwardCompatibleRelativeRefs;
    }

    String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String enc) throws UnsupportedEncodingException {
        "".getBytes(enc);
        this.encoding = enc;
    }

    protected void setViolation(int ix, boolean e, boolean w) {
        if (e && w) {
            throw new IllegalArgumentException("xxxViolation(true,true) is not permitted.");
        }
        this.initializing();
        this.asErrors[ix] = e;
        this.asWarnings[ix] = w;
    }

    protected boolean getAsWarnings(int ix) {
        return this.asWarnings[ix];
    }

    protected boolean getAsErrors(int ix) {
        return this.asErrors[ix];
    }

    protected void initializing() {
        if (!this.initializing) {
            throw new IllegalStateException("Cannot reinitialize IRIFactory after first use.");
        }
    }

    public IRI create(String s) {
        this.initializing = false;
        return super.create(s);
    }

    public void setSameSchemeRelativeReferences() {
        this.backwardCompatibleRelativeRefs = true;
    }

    protected void useSpec(String name, boolean asErr) {
        this.initializing();
        Specification spec = Specification.get(name);
        int i = 0;
        while (i < 5) {
            if (this.asErrors[i] || this.asWarnings[i] && asErr) {
                this.errors |= spec.getErrors(i);
            }
            if (this.asWarnings[i]) {
                this.warnings |= spec.getErrors(i);
            }
            ++i;
        }
        this.prohibited |= spec.getProhibited();
        this.required |= spec.getRequired();
        this.warnings &= this.errors ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public SchemeSpecificPart getScheme(String scheme, Parser parser) {
        SchemeSpecificPart p = (SchemeSpecificPart)this.schemes.get(scheme = scheme.toLowerCase());
        if (p != null) {
            p.usedBy(parser);
            return p;
        }
        int dash = scheme.indexOf(45);
        if (dash != -1) {
            p = scheme.startsWith("x-") ? this.noScheme() : new NoScheme(){

                void usedBy(Parser pp) {
                    pp.recordError(2, 46);
                }
            };
        } else if (Specification.schemes.containsKey(scheme)) {
            SchemeSpecification spec = (SchemeSpecification)Specification.schemes.get(scheme);
            p = new NoScheme(spec.port);
        } else {
            p = new NoScheme(){

                void usedBy(Parser pp) {
                    pp.recordError(2, 45);
                }
            };
        }
        p.usedBy(parser);
        this.schemes.put(scheme, p);
        return p;
    }

    public SchemeSpecificPart noScheme() {
        return this.noScheme;
    }

    public int getRequired() {
        return this.required;
    }

    public int getProhibited() {
        return this.prohibited;
    }

    public void useSchemeSpecificRules(String scheme, boolean asErr) {
        if (scheme.equals("*")) {
            Iterator it = Specification.schemes.keySet().iterator();
            while (it.hasNext()) {
                scheme = (String)it.next();
                if (this.schemes.containsKey(scheme)) continue;
                this.useSchemeSpecificRules(scheme, asErr);
            }
            return;
        }
        SchemeSpecification spec = (SchemeSpecification)Specification.schemes.get(scheme = scheme.toLowerCase());
        if (spec == null) {
            this.schemes.put(scheme, this.noScheme);
        } else {
            this.schemes.put(scheme, new WithScheme(spec, asErr));
        }
    }

    private class WithScheme
    extends SchemeSpecificPart {
        long zerrors;
        long zwarnings;
        int zrequired;
        int zprohibited;
        boolean inited = false;
        final SchemeSpecification scheme;

        WithScheme(WithScheme ws) {
            this.zerrors = ws.zerrors;
            this.zwarnings = ws.zwarnings;
            this.zprohibited = ws.zprohibited;
            this.zrequired = ws.zrequired;
            this.scheme = ws.scheme;
        }

        WithScheme(SchemeSpecification spec, boolean asErr) {
            this.scheme = spec;
            int i = 0;
            while (i < 5) {
                if (IRIFactoryImpl.this.asErrors[i] || IRIFactoryImpl.this.asWarnings[i] && asErr) {
                    this.zerrors |= spec.getErrors(i);
                }
                if (IRIFactoryImpl.this.asWarnings[i]) {
                    this.zwarnings |= spec.getErrors(i);
                }
                ++i;
            }
        }

        void usedBy(Parser parser) {
            if (!this.inited) {
                this.inited = true;
                this.zerrors |= IRIFactoryImpl.this.errors;
                this.zwarnings |= IRIFactoryImpl.this.warnings;
                this.zwarnings &= this.zerrors ^ 0xFFFFFFFFFFFFFFFFL;
                this.zrequired = this.scheme.getRequired() | IRIFactoryImpl.this.required;
                this.zprohibited = this.scheme.getProhibited() | IRIFactoryImpl.this.prohibited;
            }
        }

        public long getMask(boolean includeWarnings) {
            return includeWarnings ? this.zerrors | this.zwarnings : this.zerrors;
        }

        public int getRequired() {
            return this.zrequired;
        }

        public int getProhibited() {
            return this.zprohibited;
        }

        public void analyse(Parser parser, int range) {
            this.scheme.analyse(parser, range);
        }

        public int port() {
            return this.scheme.port;
        }

        public boolean withScheme() {
            return false;
        }
    }

    private class NoScheme
    extends SchemeSpecificPart {
        private final int port;

        NoScheme() {
            this(-1);
        }

        NoScheme(int i) {
            this.port = i;
        }

        public long getMask(boolean includeWarnings) {
            return IRIFactoryImpl.this.getMask(includeWarnings);
        }

        public int getRequired() {
            return IRIFactoryImpl.this.getRequired();
        }

        public int getProhibited() {
            return IRIFactoryImpl.this.getProhibited();
        }

        void usedBy(Parser parser) {
        }

        public void analyse(Parser parser, int range) {
        }

        public int port() {
            return this.port;
        }

        public boolean withScheme() {
            return false;
        }
    }
}

