/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import weka.core.Range;
import weka.core.SystemInfo;
import weka.core.Tag;
import weka.core.Utils;

public class Debug
implements Serializable {
    private static final long serialVersionUID = 66171861743328020L;
    public static final Level ALL = Level.ALL;
    public static final Level CONFIG = Level.CONFIG;
    public static final Level FINE = Level.FINE;
    public static final Level FINER = Level.FINER;
    public static final Level FINEST = Level.FINEST;
    public static final Level INFO = Level.INFO;
    public static final Level OFF = Level.OFF;
    public static final Level SEVERE = Level.SEVERE;
    public static final Level WARNING = Level.WARNING;
    protected boolean m_Enabled = true;
    protected Log m_Log;
    protected Clock m_Clock = new Clock();

    public Debug() {
        this(null);
    }

    public Debug(String string) {
        this(string, 1000000, 1);
    }

    public Debug(String string, int n, int n2) {
        this.m_Log = Debug.newLog(string, n, n2);
    }

    public static Level stringToLevel(String string) {
        return Log.stringToLevel(string);
    }

    public static Log newLog(String string, int n, int n2) {
        return new Log(string, n, n2);
    }

    public void log(String string) {
        this.log(INFO, string);
    }

    public void log(Level level, String string) {
        this.log(level, "", string);
    }

    public void log(Level level, String string, String string2) {
        this.log(level, string, "", string2);
    }

    public void log(Level level, String string, String string2, String string3) {
        if (this.getEnabled()) {
            this.m_Log.log(level, string, string2, string3);
        }
    }

    public void setEnabled(boolean bl) {
        this.m_Enabled = bl;
    }

    public boolean getEnabled() {
        return this.m_Enabled;
    }

    public static Clock newClock() {
        return new Clock();
    }

    public Clock getClock() {
        return this.m_Clock;
    }

    public void startClock() {
        this.m_Clock.start();
    }

    public void stopClock(String string) {
        this.log(string + ": " + this.m_Clock);
    }

    public static java.util.Random newRandom() {
        return new Random(true);
    }

    public static java.util.Random newRandom(int n) {
        return new Random(n, true);
    }

    public static Timestamp newTimestamp() {
        return new Timestamp();
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getHomeDir() {
        return System.getProperty("user.home");
    }

    public static String getCurrentDir() {
        return System.getProperty("user.dir");
    }

    public static boolean writeToFile(String string, Object object) {
        return Debug.writeToFile(string, object, true);
    }

    public static boolean writeToFile(String string, String string2) {
        return Debug.writeToFile(string, string2, true);
    }

    public static boolean writeToFile(String string, Object object, boolean bl) {
        return Debug.writeToFile(string, object.toString(), bl);
    }

    public static boolean writeToFile(String string, String string2, boolean bl) {
        boolean bl2;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string, bl));
            bufferedWriter.write(string2);
            bufferedWriter.newLine();
            bufferedWriter.flush();
            bufferedWriter.close();
            bl2 = true;
        }
        catch (Exception exception) {
            bl2 = false;
        }
        return bl2;
    }

    public static boolean saveToFile(String string, Object object) {
        boolean bl;
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static Object loadFromFile(String string) {
        Object object;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string));
            object = objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            object = null;
        }
        return object;
    }

    public static class DBO
    implements Serializable {
        static final long serialVersionUID = -5245628124742606784L;
        public boolean m_verboseOn = false;
        public Range m_outputTypes = new Range();

        public void setVerboseOn() {
            this.m_verboseOn = true;
        }

        public void initializeRanges(int n) {
            this.m_outputTypes.setUpper(n);
        }

        public boolean outputTypeSet(int n) {
            return this.m_outputTypes.isInRange(n);
        }

        public boolean dl(int n) {
            return this.outputTypeSet(n);
        }

        public void setOutputTypes(String string) {
            if (string.length() > 0) {
                this.m_verboseOn = true;
                this.m_outputTypes.setRanges(string);
                this.m_outputTypes.setUpper(30);
            }
        }

        public String getOutputTypes() {
            return this.m_outputTypes.getRanges();
        }

        public void dpln(String string) {
            if (this.m_verboseOn) {
                System.out.println(string);
            }
        }

        public void dpln(int n, String string) {
            if (this.outputTypeSet(n)) {
                System.out.println(string);
            }
        }

        public void dp(String string) {
            if (this.m_verboseOn) {
                System.out.print(string);
            }
        }

        public void dp(int n, String string) {
            if (this.outputTypeSet(n)) {
                System.out.print(string);
            }
        }

        public static void pln(String string) {
            System.out.println(string);
        }

        public static void p(String string) {
            System.out.print(string);
        }
    }

    public static class Random
    extends java.util.Random
    implements Serializable {
        private static final long serialVersionUID = 1256846887618333956L;
        protected boolean m_Debug = false;
        protected long m_ID;
        protected static long m_CurrentID;
        protected Log m_Log = null;

        public Random() {
            this(false);
        }

        public Random(long l) {
            this(l, false);
        }

        public Random(boolean bl) {
            this.setDebug(bl);
            this.m_ID = Random.nextID();
            if (this.getDebug()) {
                this.printStackTrace();
            }
        }

        public Random(long l, boolean bl) {
            super(l);
            this.setDebug(bl);
            this.m_ID = Random.nextID();
            if (this.getDebug()) {
                this.printStackTrace();
            }
        }

        public void setDebug(boolean bl) {
            this.m_Debug = bl;
        }

        public boolean getDebug() {
            return this.m_Debug;
        }

        public void setLog(Log log) {
            this.m_Log = log;
        }

        public Log getLog() {
            return this.m_Log;
        }

        protected static long nextID() {
            return ++m_CurrentID;
        }

        public long getID() {
            return this.m_ID;
        }

        protected void println(String string) {
            if (this.getDebug()) {
                if (this.getLog() != null) {
                    this.getLog().log(Level.INFO, this.m_ID + ": " + string);
                } else {
                    System.out.println(this.m_ID + ": " + string);
                }
            }
        }

        public void printStackTrace() {
            StringWriter stringWriter = new StringWriter();
            Throwable throwable = new Throwable();
            throwable.fillInStackTrace();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            this.println(stringWriter.toString());
        }

        public boolean nextBoolean() {
            boolean bl = super.nextBoolean();
            this.println("nextBoolean=" + bl);
            return bl;
        }

        public void nextBytes(byte[] byArray) {
            super.nextBytes(byArray);
            this.println("nextBytes=" + Utils.arrayToString(byArray));
        }

        public double nextDouble() {
            double d = super.nextDouble();
            this.println("nextDouble=" + d);
            return d;
        }

        public float nextFloat() {
            float f = super.nextFloat();
            this.println("nextFloat=" + f);
            return f;
        }

        public double nextGaussian() {
            double d = super.nextGaussian();
            this.println("nextGaussian=" + d);
            return d;
        }

        public int nextInt() {
            int n = super.nextInt();
            this.println("nextInt=" + n);
            return n;
        }

        public int nextInt(int n) {
            int n2 = super.nextInt(n);
            this.println("nextInt(" + n + ")=" + n2);
            return n2;
        }

        public long nextLong() {
            long l = super.nextLong();
            this.println("nextLong=" + l);
            return l;
        }

        public void setSeed(long l) {
            super.setSeed(l);
            this.println("setSeed(" + l + ")");
        }

        public String toString() {
            return this.getClass().getName() + ": " + this.getID();
        }
    }

    public static class Log
    implements Serializable {
        private static final long serialVersionUID = 1458435732111675823L;
        protected transient Logger m_Logger = null;
        protected String m_Filename = null;
        protected int m_Size;
        protected int m_NumFiles;
        protected boolean m_LoggerInitFailed = false;

        public Log() {
            this(null);
        }

        public Log(String string) {
            this(string, 1000000, 1);
        }

        public Log(String string, int n, int n2) {
            this.m_Filename = string;
            this.m_Size = n;
            this.m_NumFiles = n2;
        }

        protected Logger getLogger() {
            if (this.m_Logger == null && !this.m_LoggerInitFailed && this.m_Filename != null) {
                this.m_Logger = Logger.getLogger(this.m_Filename);
                FileHandler fileHandler = null;
                try {
                    fileHandler = new FileHandler(this.m_Filename, this.m_Size, this.m_NumFiles);
                    fileHandler.setFormatter(new SimpleFormatter());
                    this.m_Logger.addHandler(fileHandler);
                    this.m_LoggerInitFailed = false;
                }
                catch (Exception exception) {
                    System.out.println("Cannot init fileHandler for logger:" + exception.toString());
                    this.m_Logger = null;
                    this.m_LoggerInitFailed = true;
                }
            }
            return this.m_Logger;
        }

        public static Level stringToLevel(String string) {
            Level level = string.equalsIgnoreCase("ALL") ? ALL : (string.equalsIgnoreCase("CONFIG") ? CONFIG : (string.equalsIgnoreCase("FINE") ? FINE : (string.equalsIgnoreCase("FINER") ? FINER : (string.equalsIgnoreCase("FINEST") ? FINEST : (string.equalsIgnoreCase("INFO") ? INFO : (string.equalsIgnoreCase("OFF") ? OFF : (string.equalsIgnoreCase("SEVERE") ? SEVERE : (string.equalsIgnoreCase("WARNING") ? WARNING : ALL))))))));
            return level;
        }

        public String getFilename() {
            return this.m_Filename;
        }

        public int getSize() {
            return this.m_Size;
        }

        public int getNumFiles() {
            return this.m_NumFiles;
        }

        public void log(Level level, String string) {
            this.log(level, "", string);
        }

        public void log(Level level, String string, String string2) {
            this.log(level, string, "", string2);
        }

        public void log(Level level, String string, String string2, String string3) {
            Logger logger = this.getLogger();
            if (logger != null) {
                logger.logp(level, string, string2, string3);
            } else {
                System.out.println(string3);
            }
        }

        public void logSystemInfo() {
            this.log(INFO, "SystemInfo:\n" + new SystemInfo().toString());
        }

        public String toString() {
            String string = "Filename: " + this.getFilename() + ", " + "Size: " + this.getSize() + ", " + "# Files: " + this.getNumFiles();
            return string;
        }
    }

    public static class SimpleLog
    implements Serializable {
        private static final long serialVersionUID = -2671928223819510830L;
        protected String m_Filename = null;

        public SimpleLog() {
            this(null);
        }

        public SimpleLog(String string) {
            this(string, true);
        }

        public SimpleLog(String string, boolean bl) {
            this.m_Filename = string;
            Debug.writeToFile(this.m_Filename, "--> Log started", bl);
        }

        public String getFilename() {
            return this.m_Filename;
        }

        public void log(String string) {
            String string2 = new Timestamp() + " " + string;
            if (this.getFilename() != null) {
                Debug.writeToFile(this.getFilename(), string2);
            }
            System.out.println(string2);
        }

        public void logSystemInfo() {
            this.log("SystemInfo:\n" + new SystemInfo().toString());
        }

        public String toString() {
            String string = "Filename: " + this.getFilename();
            return string;
        }
    }

    public static class Timestamp
    implements Serializable {
        private static final long serialVersionUID = -6099868388466922753L;
        public static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";
        protected Date m_Stamp;
        protected String m_Format;
        protected SimpleDateFormat m_Formatter;

        public Timestamp() {
            this(DEFAULT_FORMAT);
        }

        public Timestamp(String string) {
            this(new Date(), string);
        }

        public Timestamp(Date date) {
            this(date, DEFAULT_FORMAT);
        }

        public Timestamp(Date date, String string) {
            this.m_Stamp = date;
            this.setFormat(string);
        }

        public void setFormat(String string) {
            try {
                this.m_Formatter = new SimpleDateFormat(string);
                this.m_Format = string;
            }
            catch (Exception exception) {
                this.m_Formatter = new SimpleDateFormat(DEFAULT_FORMAT);
                this.m_Format = DEFAULT_FORMAT;
            }
        }

        public String getFormat() {
            return this.m_Format;
        }

        public Date getStamp() {
            return this.m_Stamp;
        }

        public String toString() {
            return this.m_Formatter.format(this.getStamp());
        }
    }

    public static class Clock
    implements Serializable {
        private static final long serialVersionUID = 4622161807307942201L;
        public static final int FORMAT_MILLISECONDS = 0;
        public static final int FORMAT_SECONDS = 1;
        public static final int FORMAT_HHMMSS = 2;
        public static final Tag[] TAGS_FORMAT = new Tag[]{new Tag(0, "milli-seconds"), new Tag(1, "seconds"), new Tag(2, "hh:mm:ss")};
        public int m_OutputFormat = 1;
        protected long m_Start = 0L;
        protected long m_Stop = 0L;
        protected boolean m_Running = false;
        protected long m_ThreadID;
        protected boolean m_CanMeasureCpuTime;
        protected transient ThreadMXBean m_ThreadMonitor;

        public Clock() {
            this(true);
        }

        public Clock(int n) {
            this(true, n);
        }

        public Clock(boolean bl) {
            this(bl, 1);
        }

        public Clock(boolean bl, int n) {
            this.setOutputFormat(n);
            if (bl) {
                this.start();
            }
        }

        protected void init() {
            this.m_ThreadMonitor = null;
            this.m_ThreadMonitor = this.getThreadMonitor();
            this.m_CanMeasureCpuTime = this.m_ThreadMonitor.isThreadCpuTimeSupported();
        }

        public boolean isCpuTime() {
            return this.m_CanMeasureCpuTime;
        }

        protected ThreadMXBean getThreadMonitor() {
            if (this.m_ThreadMonitor == null) {
                this.m_ThreadMonitor = ManagementFactory.getThreadMXBean();
                if (!this.m_ThreadMonitor.isThreadCpuTimeEnabled()) {
                    this.m_ThreadMonitor.setThreadCpuTimeEnabled(true);
                }
                this.m_ThreadID = Thread.currentThread().getId();
            }
            return this.m_ThreadMonitor;
        }

        protected long getCurrentTime() {
            long l = this.isCpuTime() ? this.getThreadMonitor().getThreadUserTime(this.m_ThreadID) / 1000000L : System.currentTimeMillis();
            return l;
        }

        public void start() {
            this.init();
            this.m_Stop = this.m_Start = this.getCurrentTime();
            this.m_Running = true;
        }

        public void stop() {
            this.m_Stop = this.getCurrentTime();
            this.m_Running = false;
        }

        public long getStart() {
            return this.m_Start;
        }

        public long getStop() {
            long l = this.isRunning() ? this.getCurrentTime() : this.m_Stop;
            return l;
        }

        public boolean isRunning() {
            return this.m_Running;
        }

        public void setOutputFormat(int n) {
            if (n == 0) {
                this.m_OutputFormat = n;
            } else if (n == 1) {
                this.m_OutputFormat = n;
            } else if (n == 2) {
                this.m_OutputFormat = n;
            } else {
                System.out.println("Format '" + n + "' is not recognized!");
            }
        }

        public int getOutputFormat() {
            return this.m_OutputFormat;
        }

        public String toString() {
            String string = "";
            long l = this.getStop() - this.getStart();
            switch (this.getOutputFormat()) {
                case 2: {
                    long l2 = l / 3600000L;
                    long l3 = (l %= 3600000L) / 60000L;
                    long l4 = (l %= 60000L) / 1000L;
                    long l5 = l % 1000L;
                    if (l2 > 0L) {
                        string = string + "" + l2 + ":";
                    }
                    string = l3 < 10L ? string + "0" + l3 + ":" : string + "" + l3 + ":";
                    string = l4 < 10L ? string + "0" + l4 + "." : string + "" + l4 + ".";
                    string = string + Utils.doubleToString((double)l5 / 1000.0, 3).replaceAll(".*\\.", "");
                    break;
                }
                case 1: {
                    string = Utils.doubleToString((double)l / 1000.0, 3) + "s";
                    break;
                }
                case 0: {
                    string = "" + l + "ms";
                    break;
                }
                default: {
                    string = "<unknown time format>";
                }
            }
            return string;
        }
    }
}

