/*
 * Decompiled with CFR 0.152.
 */
package kea.stemmers;

import kea.stemmers.Stemmer;

public class SremovalStemmer
extends Stemmer {
    private static final long serialVersionUID = 1L;

    public String stem(String str) {
        if (str.length() > 3) {
            char[] c = str.toCharArray();
            int i = 0;
            while (i < c.length) {
                if (!Character.isLetter(c[i])) {
                    return str.toLowerCase();
                }
                ++i;
            }
        } else {
            return str.toLowerCase();
        }
        str = this.step1a(str);
        return str.toLowerCase();
    }

    protected String step1a(String str) {
        if (str.endsWith("sses")) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ies")) {
            return str.substring(0, str.length() - 2);
        }
        if (str.endsWith("ss")) {
            return str;
        }
        if (str.endsWith("s")) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    protected boolean endsWithS(String str) {
        return str.endsWith("s");
    }

    protected boolean containsVowel(String str) {
        char[] strchars = str.toCharArray();
        int i = 0;
        while (i < strchars.length) {
            if (this.isVowel(strchars[i])) {
                return true;
            }
            ++i;
        }
        return str.indexOf(121) > -1;
    }

    public boolean isVowel(char c) {
        return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u';
    }

    protected boolean endsWithDoubleConsonent(String str) {
        char c = str.charAt(str.length() - 1);
        return c == str.charAt(str.length() - 2) && !this.containsVowel(str.substring(str.length() - 2));
    }

    protected int stringMeasure(String str) {
        int count = 0;
        boolean vowelSeen = false;
        char[] strchars = str.toCharArray();
        int i = 0;
        while (i < strchars.length) {
            if (this.isVowel(strchars[i])) {
                vowelSeen = true;
            } else if (vowelSeen) {
                ++count;
                vowelSeen = false;
            }
            ++i;
        }
        return count;
    }

    protected boolean endsWithCVC(String str) {
        char c2 = ' ';
        if (str.length() < 3) {
            return false;
        }
        char c = str.charAt(str.length() - 1);
        char v = str.charAt(str.length() - 2);
        c2 = str.charAt(str.length() - 3);
        if (c == 'w' || c == 'x' || c == 'y') {
            return false;
        }
        if (this.isVowel(c)) {
            return false;
        }
        if (!this.isVowel(v)) {
            return false;
        }
        return !this.isVowel(c2);
    }
}

