% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KorAPConnection.R
\name{persistAccessToken,KorAPConnection-method}
\alias{persistAccessToken,KorAPConnection-method}
\alias{persistAccessToken}
\title{Persist current access token in keyring}
\usage{
\S4method{persistAccessToken}{KorAPConnection}(kco, accessToken = kco@accessToken)
}
\arguments{
\item{kco}{KorAPConnection object}

\item{accessToken}{access token to be persisted. If not supplied, the current access token of the KorAPConnection object will be used.}
}
\value{
KorAPConnection object.
}
\description{
Persist current access token in keyring
}
\examples{
\dontrun{
kco <- new("KorAPConnection", accessToken="e739u6eOzkwADQPdVChxFg")
persistAccessToken(kco)

kco <- new("KorAPConnection") \%>\% auth(app_id="<my application id>") \%>\% persistAccessToken()
}

}
\seealso{
\code{\link[=clearAccessToken]{clearAccessToken()}}, \code{\link[=auth]{auth()}}
}
