% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inv_GPCA_iteration.R
\name{inv_GPCA_iteration}
\alias{inv_GPCA_iteration}
\title{This function makes an inverse iteration of PCA-Gaussianization process}
\usage{
inv_GPCA_iteration(x = GPCA_iter_param$x_next, GPCA_iter_param, type = 3,
  extremes = TRUE)
}
\arguments{
\item{x}{matrix of gaussian random variale to transform}

\item{GPCA_iter_param}{\code{\link{GPCAiteration}} S3 object returned by the function \code{\link{GPCA_iteration}} corresponding the related direct iteration}

\item{type}{see \code{\link{normalizeGaussian_severalstations}}}

\item{extremes}{see \code{\link{normalizeGaussian_severalstations}}}
}
\value{
the non-Gaussian random variable
}
\description{
This function makes an inverse iteration of PCA-Gaussianization process
}
\note{
This function is based on the inverse of the equation (1) of "PCA Gaussianization for One-Class Remote Sensing Image" by V. Laparra et al.,  \url{http://ieeexplore.ieee.org/document/5413808/}
}
\examples{
library(RMAWGEN)
set.seed(1222)
N <- 20
x <- rexp(N)
y <- x+rnorm(N)
df <- data.frame(x=x,y=y)

GPCA <- GPCA_iteration(df,extremes=TRUE)

x <- rnorm(N)
y <- x+rnorm(N)
dfn <- data.frame(x=x,y=y)

GPCAn <- GPCA_iteration(dfn,extremes=TRUE)

df_out <- inv_GPCA_iteration(GPCA_iter_param=GPCA,extremes=TRUE)
dfn_out <- inv_GPCA_iteration(GPCA_iter_param=GPCAn,extremes=TRUE)


}
\seealso{
\code{\link{GPCA}},\code{\link{GPCA_iteration}},\code{\link{inv_GPCA_iteration}},\code{\link{inv_GPCA}},\code{\link{GPCA-class}} for 'GPCA' S3 class
}

