% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DALMKL.R
\name{predict_Spicy}
\alias{predict_Spicy}
\title{Predict SpicyMKL}
\usage{
predict_Spicy(alpha, b, k0)
}
\arguments{
\item{alpha}{coefficient}

\item{b}{intercept}

\item{k0}{the kernel cube needs prediction}
}
\value{
The predicted score
}
\description{
This function is used to predict SpicyMKL models
}
\examples{
data(benchmark.data)
data.mkl=benchmark.data[[1]]
kernels=rep('radial',2)
sigma=c(2,1/20)
train.samples=sample(1:nrow(data.mkl),floor(0.7*nrow(data.mkl)),replace=FALSE)
degree=sapply(1:length(kernels), function(a) ifelse(kernels[a]=='p',2,0))
#Kernels.gen splts the data into a training and test set, and generates the desired kernel matrices.
#Here we generate two gaussisan kernel matrices with sigma hyperparameter 2 and 0.05
K=kernels.gen(data=data.mkl[,1:2],train.samples=train.samples,
                kernels=kernels,sigma=sigma,degree=degree,scale=rep(0,length(kernels)))
C=0.05 #Cost parameter for DALMKL
K.train=K$K.train
K.test=K$K.test
 ytr=data.mkl[train.samples,3]
 #Converts list of kernel matrices in to an array with is appropriate for C++ code
 k.train=simplify2array(K.train) 
 k.test=simplify2array(K.test)

 #Implement DALMKL with the hinge loss function
 spicy_svmb1n=SpicyMKL(K=k.train,y=ytr, loss='hinge',C=C)
 prediction_logistic=predict_Spicy(spicy_svmb1n$alpha,spicy_svmb1n$b,k.test)
 #Implement DALMKL with the hinge loss function
 spicy_logistic=SpicyMKL(K=k.train,y=ytr, loss='logistic',C=C)
 prediction_logistic=predict_Spicy(spicy_logistic$alpha,spicy_logistic$b,k.test)
}
