% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbBegin_MariaDBConnection.R,
%   R/dbCommit_MariaDBConnection.R, R/dbRollback_MariaDBConnection.R,
%   R/transaction.R
\name{transactions}
\alias{transactions}
\alias{dbBegin_MariaDBConnection}
\alias{dbBegin,MariaDBConnection-method}
\alias{dbCommit_MariaDBConnection}
\alias{dbCommit,MariaDBConnection-method}
\alias{dbRollback_MariaDBConnection}
\alias{dbRollback,MariaDBConnection-method}
\title{DBMS Transaction Management}
\usage{
\S4method{dbBegin}{MariaDBConnection}(conn, ...)

\S4method{dbCommit}{MariaDBConnection}(conn, ...)

\S4method{dbRollback}{MariaDBConnection}(conn, ...)
}
\arguments{
\item{conn}{a \linkS4class{MariaDBConnection} object, as produced by
\code{\link[DBI:dbConnect]{DBI::dbConnect()}}.}

\item{...}{Unused.}
}
\description{
Commits or roll backs the current transaction in an MariaDB connection.
Note that in MariaDB DDL statements (e.g. \verb{CREATE TABLE}) cannot
be rolled back.
}
\examples{
if (mariadbHasDefault()) {
  con <- dbConnect(RMariaDB::MariaDB(), dbname = "test")
  df <- data.frame(id = 1:5)

  dbWriteTable(con, "df", df, temporary = TRUE)
  dbBegin(con)
  dbExecute(con, "UPDATE df SET id = id * 10")
  dbGetQuery(con, "SELECT id FROM df")
  dbRollback(con)

  dbGetQuery(con, "SELECT id FROM df")

  dbDisconnect(con)
}
}
