% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLOT_plotConvergence.R
\name{plotConvergence}
\alias{plotConvergence}
\title{Convergence of algorithm}
\usage{
plotConvergence(output, ...)
}
\arguments{
\item{output}{object returned by \emph{mixtCompLearn} function from \emph{RMixtComp} or \emph{rmcMultiRun} function
from \emph{RMixtCompIO}}

\item{...}{graphical parameters}
}
\description{
Plot the evolution of the completed loglikelihood during the SEM algorithm. The vertical line denotes the end of the
burn-in phase.
}
\details{
This function can be used to check the convergence and choose the parameters nbBurnInIter and nbIter from mcStrategy.
}
\examples{
require(RMixtCompIO) # for learning a mixture model
dataLearn <- list(
  var1 = as.character(c(rnorm(50, -2, 0.8), rnorm(50, 2, 0.8))),
  var2 = as.character(c(rnorm(50, 2), rpois(50, 8)))
)

model <- list(
  var1 = list(type = "Gaussian", paramStr = ""),
  var2 = list(type = "Poisson", paramStr = "")
)

algo <- list(
  nClass = 2,
  nInd = 100,
  nbBurnInIter = 100,
  nbIter = 100,
  nbGibbsBurnInIter = 100,
  nbGibbsIter = 100,
  nInitPerClass = 3,
  nSemTry = 20,
  confidenceLevel = 0.95,
  ratioStableCriterion = 0.95,
  nStableCriterion = 10,
  mode = "learn"
)

resLearn <- rmcMultiRun(algo, dataLearn, model, nRun = 3)

# plot
plotConvergence(resLearn)

}
\seealso{
Other plot: 
\code{\link{heatmapClass}()},
\code{\link{heatmapTikSorted}()},
\code{\link{heatmapVar}()},
\code{\link{histMisclassif}()},
\code{\link{plot.MixtComp}()},
\code{\link{plotDataBoxplot}()},
\code{\link{plotDataCI}()},
\code{\link{plotDiscrimClass}()},
\code{\link{plotDiscrimVar}()},
\code{\link{plotParamConvergence}()},
\code{\link{plotProportion}()}
}
\author{
Quentin Grimonprez
}
\concept{plot}
