/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.bson.BSONCallback;
import org.bson.BSONException;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.io.Bits;
import org.bson.io.PoolOutputBuffer;
import org.bson.types.ObjectId;

public class BSONDecoder {
    private Input _in;
    private BSONCallback _callback;
    private byte[] _random = new byte[1024];
    private byte[] _inputBuffer = new byte[1024];
    private PoolOutputBuffer _stringBuffer = new PoolOutputBuffer();
    static final String[] ONE_BYTE_STRINGS = new String[128];

    public BSONObject readObject(byte[] b) {
        try {
            return this.readObject(new ByteArrayInputStream(b));
        }
        catch (IOException ioe) {
            throw new BSONException("should be impossible", ioe);
        }
    }

    public BSONObject readObject(InputStream in) throws IOException {
        BasicBSONCallback c = new BasicBSONCallback();
        this.decode(in, (BSONCallback)c);
        return (BSONObject)c.get();
    }

    public int decode(byte[] b, BSONCallback callback) {
        try {
            return this._decode(new Input(new ByteArrayInputStream(b)), callback);
        }
        catch (IOException ioe) {
            throw new BSONException("should be impossible", ioe);
        }
    }

    public int decode(InputStream in, BSONCallback callback) throws IOException {
        return this._decode(new Input(in), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _decode(Input in, BSONCallback callback) throws IOException {
        if (this._in != null || this._callback != null) {
            throw new IllegalStateException("not ready");
        }
        this._in = in;
        this._callback = callback;
        if (in._read != 0) {
            throw new IllegalArgumentException("i'm confused");
        }
        try {
            int len;
            this._in._max = len = this._in.readInt();
            this._callback.objectStart();
            while (this.decodeElement()) {
            }
            this._callback.objectDone();
            if (this._in._read != len) {
                throw new IllegalArgumentException("bad data.  lengths don't match read:" + this._in._read + " != len:" + len);
            }
            int n = len;
            return n;
        }
        finally {
            this._in = null;
            this._callback = null;
        }
    }

    int decode(boolean first) throws IOException {
        int start = this._in._read;
        int len = this._in.readInt();
        if (first) {
            this._in._max = len;
        }
        this._callback.objectStart();
        while (this.decodeElement()) {
        }
        this._callback.objectDone();
        int read = this._in._read - start;
        if (read != len) {
            // empty if block
        }
        return len;
    }

    boolean decodeElement() throws IOException {
        byte type = this._in.read();
        if (type == 0) {
            return false;
        }
        String name = this._in.readCStr();
        switch (type) {
            case 10: {
                this._callback.gotNull(name);
                break;
            }
            case 6: {
                this._callback.gotUndefined(name);
                break;
            }
            case 8: {
                this._callback.gotBoolean(name, this._in.read() > 0);
                break;
            }
            case 1: {
                this._callback.gotDouble(name, this._in.readDouble());
                break;
            }
            case 16: {
                this._callback.gotInt(name, this._in.readInt());
                break;
            }
            case 18: {
                this._callback.gotLong(name, this._in.readLong());
                break;
            }
            case 14: {
                this._callback.gotSymbol(name, this._in.readUTF8String());
                break;
            }
            case 2: {
                this._callback.gotString(name, this._in.readUTF8String());
                break;
            }
            case 7: {
                this._callback.gotObjectId(name, new ObjectId(this._in.readIntBE(), this._in.readIntBE(), this._in.readIntBE()));
                break;
            }
            case 12: {
                this._in.readInt();
                String ns = this._in.readCStr();
                ObjectId theOID = new ObjectId(this._in.readInt(), this._in.readInt(), this._in.readInt());
                this._callback.gotDBRef(name, ns, theOID);
                break;
            }
            case 9: {
                this._callback.gotDate(name, this._in.readLong());
                break;
            }
            case 11: {
                this._callback.gotRegex(name, this._in.readCStr(), this._in.readCStr());
                break;
            }
            case 5: {
                this._binary(name);
                break;
            }
            case 13: {
                this._callback.gotCode(name, this._in.readUTF8String());
                break;
            }
            case 15: {
                this._in.readInt();
                this._callback.gotCodeWScope(name, this._in.readUTF8String(), this._readBasicObject());
                break;
            }
            case 4: {
                this._in.readInt();
                this._callback.arrayStart(name);
                while (this.decodeElement()) {
                }
                this._callback.arrayDone();
                break;
            }
            case 3: {
                this._in.readInt();
                this._callback.objectStart(name);
                while (this.decodeElement()) {
                }
                this._callback.objectDone();
                break;
            }
            case 17: {
                int i = this._in.readInt();
                int time = this._in.readInt();
                this._callback.gotTimestamp(name, time, i);
                break;
            }
            case -1: {
                this._callback.gotMinKey(name);
                break;
            }
            case 127: {
                this._callback.gotMaxKey(name);
                break;
            }
            default: {
                throw new UnsupportedOperationException("BSONDecoder doesn't understand type : " + type + " name: " + name);
            }
        }
        return true;
    }

    void _binary(String name) throws IOException {
        int totalLen = this._in.readInt();
        byte bType = this._in.read();
        switch (bType) {
            case 0: {
                byte[] data = new byte[totalLen];
                this._in.fill(data);
                this._callback.gotBinaryArray(name, data);
                return;
            }
            case 2: {
                int len = this._in.readInt();
                if (len + 4 != totalLen) {
                    throw new IllegalArgumentException("bad data size subtype 2 len: " + len + " totalLen: " + totalLen);
                }
                byte[] data = new byte[len];
                this._in.fill(data);
                this._callback.gotBinaryArray(name, data);
                return;
            }
            case 3: {
                if (totalLen != 16) {
                    throw new IllegalArgumentException("bad data size subtype 3 len: " + totalLen + " != 16");
                }
                long part1 = this._in.readLong();
                long part2 = this._in.readLong();
                this._callback.gotUUID(name, part1, part2);
                return;
            }
        }
        byte[] data = new byte[totalLen];
        this._in.fill(data);
        this._callback.gotBinary(name, bType, data);
    }

    Object _readBasicObject() throws IOException {
        BSONCallback _basic;
        this._in.readInt();
        BSONCallback save2 = this._callback;
        this._callback = _basic = this._callback.createBSONCallback();
        _basic.reset();
        _basic.objectStart(false);
        while (this.decodeElement()) {
        }
        this._callback = save2;
        return _basic.get();
    }

    static void _fillRange(byte min2, byte max2) {
        while (min2 < max2) {
            String s = "";
            BSONDecoder.ONE_BYTE_STRINGS[min2] = s = s + (char)min2;
            min2 = (byte)(min2 + 1);
        }
    }

    static {
        BSONDecoder._fillRange((byte)48, (byte)57);
        BSONDecoder._fillRange((byte)97, (byte)122);
        BSONDecoder._fillRange((byte)65, (byte)90);
    }

    final class Input {
        int _read;
        final InputStream _raw;
        int _pos;
        int _len;
        int _max = 4;

        Input(InputStream in) {
            this._raw = in;
            this._read = 0;
            this._pos = 0;
            this._len = 0;
        }

        int _need(int num) throws IOException {
            if (this._len - this._pos >= num) {
                int ret = this._pos;
                this._pos += num;
                this._read += num;
                return ret;
            }
            if (num >= BSONDecoder.this._inputBuffer.length) {
                throw new IllegalArgumentException("you can't need that much");
            }
            int remaining = this._len - this._pos;
            if (this._pos > 0) {
                System.arraycopy(BSONDecoder.this._inputBuffer, this._pos, BSONDecoder.this._inputBuffer, 0, remaining);
                this._pos = 0;
                this._len = remaining;
            }
            int maxToRead = Math.min(this._max - this._read - remaining, BSONDecoder.this._inputBuffer.length - this._len);
            while (maxToRead > 0) {
                int x = this._raw.read(BSONDecoder.this._inputBuffer, this._len, maxToRead);
                if (x <= 0) {
                    throw new IOException("unexpected EOF");
                }
                maxToRead -= x;
                this._len += x;
            }
            int ret = this._pos;
            this._pos += num;
            this._read += num;
            return ret;
        }

        int readInt() throws IOException {
            return Bits.readInt(BSONDecoder.this._inputBuffer, this._need(4));
        }

        int readIntBE() throws IOException {
            return Bits.readIntBE(BSONDecoder.this._inputBuffer, this._need(4));
        }

        long readLong() throws IOException {
            return Bits.readLong(BSONDecoder.this._inputBuffer, this._need(8));
        }

        double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readLong());
        }

        byte read() throws IOException {
            if (this._pos < this._len) {
                ++this._read;
                return BSONDecoder.this._inputBuffer[this._pos++];
            }
            return BSONDecoder.this._inputBuffer[this._need(1)];
        }

        void fill(byte[] b) throws IOException {
            this.fill(b, b.length);
        }

        void fill(byte[] b, int len) throws IOException {
            int have = this._len - this._pos;
            int tocopy = Math.min(len, have);
            System.arraycopy(BSONDecoder.this._inputBuffer, this._pos, b, 0, tocopy);
            this._pos += tocopy;
            this._read += tocopy;
            len -= tocopy;
            int off = tocopy;
            while (len > 0) {
                int x = this._raw.read(b, off, len);
                if (x <= 0) {
                    throw new IOException("unexpected EOF");
                }
                this._read += x;
                off += x;
                len -= x;
            }
        }

        boolean _isAscii(byte b) {
            return b >= 0 && b <= 127;
        }

        String readCStr() throws IOException {
            byte b;
            boolean isAscii = true;
            ((BSONDecoder)BSONDecoder.this)._random[0] = this.read();
            if (BSONDecoder.this._random[0] == 0) {
                return "";
            }
            ((BSONDecoder)BSONDecoder.this)._random[1] = this.read();
            if (BSONDecoder.this._random[1] == 0) {
                String out = ONE_BYTE_STRINGS[BSONDecoder.this._random[0]];
                if (out != null) {
                    return out;
                }
                return new String(BSONDecoder.this._random, 0, 1, "UTF-8");
            }
            BSONDecoder.this._stringBuffer.reset();
            BSONDecoder.this._stringBuffer.write(BSONDecoder.this._random[0]);
            BSONDecoder.this._stringBuffer.write(BSONDecoder.this._random[1]);
            boolean bl = isAscii = this._isAscii(BSONDecoder.this._random[0]) && this._isAscii(BSONDecoder.this._random[1]);
            while ((b = this.read()) != 0) {
                BSONDecoder.this._stringBuffer.write(b);
                isAscii = isAscii && this._isAscii(b);
            }
            String out = null;
            if (isAscii) {
                out = BSONDecoder.this._stringBuffer.asAscii();
            } else {
                try {
                    out = BSONDecoder.this._stringBuffer.asString("UTF-8");
                }
                catch (UnsupportedOperationException e) {
                    throw new BSONException("impossible", e);
                }
            }
            BSONDecoder.this._stringBuffer.reset();
            return out;
        }

        String readUTF8String() throws IOException {
            int size2 = this.readInt();
            if (size2 <= 0 || size2 > 0x2000000) {
                throw new BSONException("bad string size: " + size2);
            }
            if (size2 < BSONDecoder.this._inputBuffer.length / 2) {
                if (size2 == 1) {
                    this.read();
                    return "";
                }
                return new String(BSONDecoder.this._inputBuffer, this._need(size2), size2 - 1, "UTF-8");
            }
            byte[] b = size2 < BSONDecoder.this._random.length ? BSONDecoder.this._random : new byte[size2];
            this.fill(b, size2);
            try {
                return new String(b, 0, size2 - 1, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new BSONException("impossible", uee);
            }
        }
    }
}

