% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{plot_pca_scatters}
\alias{plot_pca_scatters}
\title{Plot matrix of PCA scatter plots}
\usage{
plot_pca_scatters(
  obj,
  n_PCs = min(10, nrow(obj), ncol(obj)),
  show_var_exp = T,
  n_feats = 500,
  scale_feats = FALSE,
  na_frac = 0.3,
  metadata = NULL,
  color_by = NULL,
  shape_by = NULL,
  point_alpha = 0.7,
  point_rel_size = 2
)
}
\arguments{
\item{obj}{A (features x samples) matrix or SummarizedExperiment object}

\item{n_PCs}{Number of principal components to plot}

\item{show_var_exp}{Whether to show a plot of the percentage of variance explained by each PC in the bottom left corner.}

\item{n_feats}{Number of top-variable features to include.}

\item{scale_feats}{Whether to scale the features.}

\item{na_frac}{Only consider features with the stated maximum fraction of NAs or NaNs. NA/NaNs will be mean-imputed for PCA.}

\item{metadata}{A data.frame used for annotating samples. \code{rownames(metadata)} must match \code{colnames(obj)}.}

\item{color_by}{Variable by which to color points. Must be a column in metadata or in \code{colData(obj)}.}

\item{shape_by}{Variable by which to color points. Must be a column in metadata or in \code{colData(obj)}.}

\item{point_alpha}{alpha value of \code{geom_point()}}

\item{point_rel_size}{relative size of \code{geom_point()}}
}
\value{
The function displays the scatter plots of the PCs
}
\description{
Plot matrix of PCA scatter plots
}
\examples{
set.seed(1)
data <- matrix(rnorm(100*6), ncol=6)
data <- t(t(data)+c(-1, -1.1, -1.2, 1, 1.1, 1.2))
plot_pca_scatters(data)

}
