% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_expression.R
\name{plot_within_level_sample_MAs}
\alias{plot_within_level_sample_MAs}
\title{Plot correlations of samples within a level of a group}
\usage{
plot_within_level_sample_MAs(vsd, group, level, y_lim = 4)
}
\arguments{
\item{vsd}{An object generated by \code{DESeq2::vst()}}

\item{group}{A grouping variable, must be a column of \code{colData(vsd)}}

\item{level}{A level of the grouping variable}

\item{y_lim}{Y-axis limits, the axis will run from \code{-y_lim} to \code{y_lim}}
}
\value{
A list of ggplot objects of the ggplot2 package that contains for
each sample of the specified level the the sample vs reference MA-plot.
}
\description{
For the given level, the gene-wise median over all samples is computed
to obtain a reference sample. Then, each sample is plotted against the
reference as MA-plot.
}
\examples{
library("DESeq2")
set.seed(1)
dds <- makeExampleDESeqDataSet(n=1000, m=4, interceptMean=10)
colData(dds)$type <- c("A","A","B","B")
vsd <- vst(dds)
plot_within_level_sample_MAs(vsd, group="type", level="A")

}
