% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankNormal.R
\name{DINT}
\alias{DINT}
\title{Direct-INT}
\usage{
DINT(y, G, X, S, calcP = T, k = 3/8, parallel = F, check = T)
}
\arguments{
\item{y}{Numeric phenotype vector.}

\item{G}{Numeric Snp by obs genotype matrix.}

\item{X}{Numeric Obs by feature covariate matrix.}

\item{S}{Numeric Obs by feature structure matrix.}

\item{calcP}{Logical indicating that p values should be calculated.}

\item{k}{Offset applied during rank-normalization. See 
\code{\link{rankNormal}}.}

\item{parallel}{Logical indicating whether to run in parallel. Must register
parallel backend first.}

\item{check}{Logical indicating whether to check the input.}
}
\value{
A numeric matrix of score statistics, one for each locus (row) in \code{G},
  assessing the null hypothesis that genotype is unrelated to the outcome. If
  \code{p=T}, a p-value is additionally calculated for each locus.
}
\description{
Tests for association between genotype and the rank normalized phenotype, 
adjusting for covariates and population structure.
}
\examples{
# Direct INT on the normal phenotype 
p = RNOmni::DINT(y=RNOmni::Y[,1],G=RNOmni::G[1:10,],X=RNOmni::X,S=RNOmni::S);
}
