% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_level.R
\name{get_level}
\alias{get_level}
\title{get_level}
\usage{
get_level(nex, level)
}
\arguments{
\item{nex}{a nexml object}

\item{level}{a character vector indicating the class of node, see details}
}
\value{
Returns the attributes of specified class of nodes as a data.frame
}
\description{
get a data.frame of attribute values of a given node
}
\details{
level should be a character vector giving the path to the specified node
group.  For instance, `otus`, `characters`, and `trees` are top-level blocks (e.g.
child nodes of the root nexml block), and can be specified directly.  To get metadata
for all "char" elements from all characters blocks, you must specify that `char` nodes
are child nodes to `character` nodes: e.g. `get_level(nex, "characters/char")`,
or similarly for states: `get_level(nex, characters/states)`.  

The return object is a data frame whose columns are the attribute names of the elements
specified. The column names match the attribute names except for "id" attribute, for which the column
is renamed using the node itself. (Thus <otus id="os2"> would be rendered in a data.frame with column
called "otus" instead of "id"). Additional columns are
added for each parent element in the path; e.g. get_level(nex, "otus/otu") would include a column
named "otus" with the id of each otus block.  Even though the method always returns the data frame 
for all matching nodes in all blocks, these ids let you see which otu values came from which 
otus block.  This is identical to the function call `get_taxa()`.  
Similarly, `get_level(nex, "otus/otu/meta")` would return additional columns 'otus' and 
also a column, 'otu', with the otu parent ids of each metadata block.  (This is identical to a 
function call to `get_metadata`).  This makes it easier to join data.frames as well, see examples
}
