% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.r
\name{show.window}
\alias{show.window}
\title{Show time window of document pairs}
\usage{
show.window(g, to.attribute = NULL, from.attribute = NULL)
}
\arguments{
\item{g}{A document similarity network, as created with \link[RNewsflow]{newsflow.compare} or \link[RNewsflow]{document.network}}

\item{to.attribute}{The vertex attribute to aggregate the `to` group of the edges}

\item{from.attribute}{The vertex attribute to aggregate the `from` group of the edges}
}
\value{
A data.frame showing the left and right edges of the window for each unique group.
}
\description{
This function aggregates the edges for all combinations of attributes specified in `from.attribute` and `to.attribute`, and shows the minimum and maximum hour difference for each combination.
}
\details{
The \link[RNewsflow]{filter.window} function can be used to filter edges that fall outside of the intended time window.
}
\examples{
data(docnet)
show.window(docnet, to.attribute = 'source')
show.window(docnet, to.attribute = 'sourcetype')
show.window(docnet, to.attribute = 'sourcetype', from.attribute = 'sourcetype')
}
