% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logitInvLogit.R
\name{invlogit}
\alias{invlogit}
\title{Logistic Transformation}
\usage{
invlogit(x)
}
\arguments{
\item{x}{A number or numeric vector from \eqn{(-Inf Inf)}.}
}
\value{
Logistic transformed value of \code{x}, \eqn{1/(1+exp(-x))}
}
\description{
\code{invlogit} returns the logistic transformed value.
}
\examples{
invlogit(0.5)

invlogit(c(-Inf, Inf))

set.seed(10)
invlogit(runif(10, -3, 3))

}
