% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gettersSetters.R
\name{setParameter,RPhosFate-method}
\alias{setParameter,RPhosFate-method}
\alias{setParameter}
\title{Set parameter(s)}
\usage{
\S4method{setParameter}{RPhosFate}(x, ...)
}
\arguments{
\item{x}{An S4 \code{\linkS4class{RPhosFate}} river catchment object.}

\item{\dots}{Names and values of the parameters to set. See model parameter
arguments section for further information.}
}
\value{
An S4 \code{\linkS4class{RPhosFate}} river catchment object.
}
\description{
Sets one or more model parameters or substance parameter values.
}
\section{Model parameter arguments}{

\itemize{
\item \code{ns_slp_min}: A numeric scalar specifying the minimum bounding slope in \%
(defaults to \code{0.001}).
\item \code{ns_slp_max}: A numeric scalar specifying the maximum bounding slope in \%
(defaults to \code{999.0}).
\item \code{ns_rhy_a}: A numeric scalar specifying a network constant depending on the
discharge frequency needed for the calculation of the hydraulic radius, which
in turn is a prerequisite for substance transport (defaults to \code{0.09}
representing a discharge frequency of approximately six years).
\item \code{ns_rhy_b}: A numeric scalar specifying a geometry scaling exponent
depending on the discharge frequency needed for the calculation of the
hydraulic radius, which in turn is a prerequisite for substance transport
(defaults to \code{0.50} representing a discharge frequency of approximately six
years).
\item \code{ns_cha_rto}: A numeric scalar specifying the ratio of the channel to the
cell width determining the widths of the riparian zones required for
substance \code{\link{transport}} (defaults to \code{0.5}).
\item \code{ns_man_rip}: A numeric scalar specifying Manning's roughness coefficient
of the riparian zones within channel cells required for substance
\code{\link{transport}} (defaults to \code{0.32}).
\item \code{ns_man_cha}: A numeric scalar specifying Manning's roughness coefficient
of the channel within channel cells required for substance \code{\link{transport}}
(defaults to \code{0.04}).
\item \code{ns_dep_ovl}: A numeric scalar specifying the overland deposition rate per
second required for substance \code{\link{transport}} (calibration parameter; no
default).
\item \code{ns_dep_cha}: A numeric scalar specifying the channel deposition rate per
second required for substance \code{\link{transport}} (calibration parameter; no
default).
\item \code{nv_tfc_inl}: A named numeric vector specifying the inlet transfer
coefficients required for substance \code{\link{transport}}, for example, \code{c(SS = 0.6, PP = 0.6)} (no default).
\item \code{nv_enr_rto} A named numeric vector specifying the substance enrichment
ratios required for substance except SS \code{\link{transport}}, for example, \code{c(PP = 2.0)} (calibration parameter; no default).
\item \code{iv_fDo}: An integer vector specifying the outflow direction vector
required for substance \code{\link{transport}} (defaults to \emph{ArcGIS} codes).
\item \code{nm_olc}: A two column numeric \code{\link{matrix}} specifying one or more catchment
outlet coordinates required for the in-channel retention ratio of
\code{\link{calibrationQuality}} (no default).
\item \code{df_cdt}: A \code{\link{data.frame}} with calibration data, which must have at least
the following three columns and one or more columns with substance river
loads in t/yr (no default):
\itemize{
\item \emph{ID:} ID(s) of the gauge(s)
\item \emph{x:} x-coordinate(s) of the gauge(s)
\item \emph{y:} y-coordinate(s) of the gauge(s)
}
}
}

\examples{

# temporary demonstration project copy
cv_dir <- demoProject()
# load temporary demonstration project
x <- RPhosFate(
  cv_dir = cv_dir,
  ls_ini = TRUE
)

x <- setParameter(x, ns_dep_ovl = 15e-4)
x <- setParameter(
  x,
  nv_tfc_inl = c(SS = 0.6, PP = 0.6),
  nv_enr_rto = c(PP = 1.4)
)

}
\seealso{
\code{\link{getParameter}}
}
