% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{find_algorithms}
\alias{find_algorithms}
\title{Find and list available QGIS algorithms}
\usage{
find_algorithms(search_term = "", qgis_env = set_env(), name_only = FALSE,
  intern = ifelse(Sys.info()["sysname"] == "Windows", TRUE, FALSE))
}
\arguments{
\item{search_term}{A character to query QGIS functions, i.e. to list only 
functions which contain the indicated string. If empty (\code{""}), the
default, all available functions will be returned.}

\item{qgis_env}{Environment containing all the paths to run the QGIS API. For
more information, refer to \code{\link{set_env}}.}

\item{name_only}{If \code{TRUE}, the function returns only the name(s) of the
found algorithms. Otherwise, a short function description will be returned
as well (default).}

\item{intern}{Logical, if \code{TRUE} the function captures the command line
output as an \code{R} character vector (see also 
\code{\link[base]{system}}).}
}
\value{
The function returns QGIS function names and short descriptions as an
  R character vector.
}
\description{
\code{find_algorithms} lists or queries all QGIS algorithms
  which can be used accessed through the command line.
}
\details{
Function \code{find_algorithms} simply calls 
  \code{processing.alglist} using Python.
}
\examples{
\dontrun{
# list all available QGIS algorithms on your system
algs <- find_algorithms()
algs[1:15]
# just find all native, i.e. QGIS-algorithms
grep("qgis:", algs, value = TRUE)
# find a function which adds coordinates
find_algorithms(search_term = "add")
}
}
\author{
Jannes Muenchow, Victor Olaya, QGIS core team
}

