% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{ROCh}
\alias{ROCh}
\title{ROCh}
\usage{
ROCh(
  data,
  sel.Gene = "all",
  groups,
  panels.row,
  panels.col,
  text.size = 1.1,
  print.auc = TRUE,
  print.auc.size = 0.8,
  save.to.tiff = FALSE,
  dpi = 600,
  width = 15,
  height = 15,
  name.tiff = "ROC_plot",
  save.to.txt = FALSE,
  name.txt = "ROC_results"
)
}
\arguments{
\item{data}{Object returned from make_Ct_ready() or delta_Ct() functions.}

\item{sel.Gene}{Character vector with names of genes to include, or "all" (default) to use all genes.}

\item{groups}{Character vector length of two with names of two compared groups.}

\item{panels.row, panels.col}{Integer: number of rows and columns to arrange panels with plots.}

\item{text.size}{Numeric: size of text on the plot. Default to 1.1.}

\item{print.auc}{Logical: if TRUE, AUC values with confidence interval will be added to the plot. Default to TRUE.}

\item{print.auc.size}{Numeric: size of AUC text on the plot. Default to 0.8.}

\item{save.to.tiff}{Logical: if TRUE, plot will be saved as .tiff file. Default to FALSE.}

\item{dpi}{Integer: resolution of saved .tiff file. Default to 600.}

\item{width}{Numeric: width (in cm) of saved .tiff file. Default to 15.}

\item{height}{Numeric: height (in cm) of saved .tiff file. Default to 15.}

\item{name.tiff}{Character: name of saved .tiff file, without ".tiff" name of extension. Default to "ROC_plot".}

\item{save.to.txt}{Logical: if TRUE, returned table with results will be saved to .txt file. Default to FALSE.}

\item{name.txt}{Character: name of saved .txt file, without ".txt" name of extension. Default to "ROC_results".}
}
\value{
Data frame with ROC parameters including AUC, threshold, specificity, sensitivity, accuracy,
positive predictive value, negative predictive value, and Youden's J statistic.
Plot with ROC curves can be saved to .tiff file and opened from the working directory (will not be displayed on the graphic device).
}
\description{
This function is designed to perform Receiver Operating Characteristic (ROC) analysis based on the gene expression data.
This kind of analysis is useful to further examine performance of samples classification into two groups.
}
\examples{
library(tidyverse)
library(pROC)
data(data.Ct)
data.CtF <- filter_Ct(data.Ct,
                      remove.Gene = c("FGF23","ANGPT2","IL1A","CSF2","IL6"),
                      remove.Sample = c("Control08","Control16","Control22"))
data.CtF.ready <- make_Ct_ready(data.CtF, imput.by.mean.within.groups = TRUE)
data.dCt <- delta_Ct(data.CtF.ready, ref = "GAPDH")
data.dCtF <- filter_transformed_data(data.dCt, remove.Sample = c("Control11"))
roc_parameters <- ROCh(data.dCtF, sel.Gene = c("ANGPT1","IL8", "VEGFB"),
                        groups = c("AAA","Control"),
                        panels.row = 2,
                        panels.col = 2)

}
