// This file was generated by Rcpp::compileAttributes
// Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#include "../inst/include/RQuantLib.h"
#include <Rcpp.h>
#include <string>
#include <set>

using namespace Rcpp;

// asianOptionEngine
Rcpp::List asianOptionEngine(std::string averageType, std::string type, double underlying, double strike, double dividendYield, double riskFreeRate, double maturity, double volatility, double first, double length, size_t fixings);
RcppExport SEXP RQuantLib_asianOptionEngine(SEXP averageTypeSEXP, SEXP typeSEXP, SEXP underlyingSEXP, SEXP strikeSEXP, SEXP dividendYieldSEXP, SEXP riskFreeRateSEXP, SEXP maturitySEXP, SEXP volatilitySEXP, SEXP firstSEXP, SEXP lengthSEXP, SEXP fixingsSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< std::string >::type averageType(averageTypeSEXP);
    Rcpp::traits::input_parameter< std::string >::type type(typeSEXP);
    Rcpp::traits::input_parameter< double >::type underlying(underlyingSEXP);
    Rcpp::traits::input_parameter< double >::type strike(strikeSEXP);
    Rcpp::traits::input_parameter< double >::type dividendYield(dividendYieldSEXP);
    Rcpp::traits::input_parameter< double >::type riskFreeRate(riskFreeRateSEXP);
    Rcpp::traits::input_parameter< double >::type maturity(maturitySEXP);
    Rcpp::traits::input_parameter< double >::type volatility(volatilitySEXP);
    Rcpp::traits::input_parameter< double >::type first(firstSEXP);
    Rcpp::traits::input_parameter< double >::type length(lengthSEXP);
    Rcpp::traits::input_parameter< size_t >::type fixings(fixingsSEXP);
    __result = Rcpp::wrap(asianOptionEngine(averageType, type, underlying, strike, dividendYield, riskFreeRate, maturity, volatility, first, length, fixings));
    return __result;
END_RCPP
}
// binaryOptionEngine
Rcpp::List binaryOptionEngine(std::string binType, std::string type, std::string excType, double underlying, double strike, double dividendYield, double riskFreeRate, double maturity, double volatility, double cashPayoff);
RcppExport SEXP RQuantLib_binaryOptionEngine(SEXP binTypeSEXP, SEXP typeSEXP, SEXP excTypeSEXP, SEXP underlyingSEXP, SEXP strikeSEXP, SEXP dividendYieldSEXP, SEXP riskFreeRateSEXP, SEXP maturitySEXP, SEXP volatilitySEXP, SEXP cashPayoffSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< std::string >::type binType(binTypeSEXP);
    Rcpp::traits::input_parameter< std::string >::type type(typeSEXP);
    Rcpp::traits::input_parameter< std::string >::type excType(excTypeSEXP);
    Rcpp::traits::input_parameter< double >::type underlying(underlyingSEXP);
    Rcpp::traits::input_parameter< double >::type strike(strikeSEXP);
    Rcpp::traits::input_parameter< double >::type dividendYield(dividendYieldSEXP);
    Rcpp::traits::input_parameter< double >::type riskFreeRate(riskFreeRateSEXP);
    Rcpp::traits::input_parameter< double >::type maturity(maturitySEXP);
    Rcpp::traits::input_parameter< double >::type volatility(volatilitySEXP);
    Rcpp::traits::input_parameter< double >::type cashPayoff(cashPayoffSEXP);
    __result = Rcpp::wrap(binaryOptionEngine(binType, type, excType, underlying, strike, dividendYield, riskFreeRate, maturity, volatility, cashPayoff));
    return __result;
END_RCPP
}
// binaryOptionImpliedVolatilityEngine
double binaryOptionImpliedVolatilityEngine(std::string type, double value, double underlying, double strike, double dividendYield, double riskFreeRate, double maturity, double volatility, double cashPayoff);
RcppExport SEXP RQuantLib_binaryOptionImpliedVolatilityEngine(SEXP typeSEXP, SEXP valueSEXP, SEXP underlyingSEXP, SEXP strikeSEXP, SEXP dividendYieldSEXP, SEXP riskFreeRateSEXP, SEXP maturitySEXP, SEXP volatilitySEXP, SEXP cashPayoffSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< std::string >::type type(typeSEXP);
    Rcpp::traits::input_parameter< double >::type value(valueSEXP);
    Rcpp::traits::input_parameter< double >::type underlying(underlyingSEXP);
    Rcpp::traits::input_parameter< double >::type strike(strikeSEXP);
    Rcpp::traits::input_parameter< double >::type dividendYield(dividendYieldSEXP);
    Rcpp::traits::input_parameter< double >::type riskFreeRate(riskFreeRateSEXP);
    Rcpp::traits::input_parameter< double >::type maturity(maturitySEXP);
    Rcpp::traits::input_parameter< double >::type volatility(volatilitySEXP);
    Rcpp::traits::input_parameter< double >::type cashPayoff(cashPayoffSEXP);
    __result = Rcpp::wrap(binaryOptionImpliedVolatilityEngine(type, value, underlying, strike, dividendYield, riskFreeRate, maturity, volatility, cashPayoff));
    return __result;
END_RCPP
}
// barrierOptionEngine
Rcpp::List barrierOptionEngine(std::string barrType, std::string type, double underlying, double strike, double dividendYield, double riskFreeRate, double maturity, double volatility, double barrier, double rebate);
RcppExport SEXP RQuantLib_barrierOptionEngine(SEXP barrTypeSEXP, SEXP typeSEXP, SEXP underlyingSEXP, SEXP strikeSEXP, SEXP dividendYieldSEXP, SEXP riskFreeRateSEXP, SEXP maturitySEXP, SEXP volatilitySEXP, SEXP barrierSEXP, SEXP rebateSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< std::string >::type barrType(barrTypeSEXP);
    Rcpp::traits::input_parameter< std::string >::type type(typeSEXP);
    Rcpp::traits::input_parameter< double >::type underlying(underlyingSEXP);
    Rcpp::traits::input_parameter< double >::type strike(strikeSEXP);
    Rcpp::traits::input_parameter< double >::type dividendYield(dividendYieldSEXP);
    Rcpp::traits::input_parameter< double >::type riskFreeRate(riskFreeRateSEXP);
    Rcpp::traits::input_parameter< double >::type maturity(maturitySEXP);
    Rcpp::traits::input_parameter< double >::type volatility(volatilitySEXP);
    Rcpp::traits::input_parameter< double >::type barrier(barrierSEXP);
    Rcpp::traits::input_parameter< double >::type rebate(rebateSEXP);
    __result = Rcpp::wrap(barrierOptionEngine(barrType, type, underlying, strike, dividendYield, riskFreeRate, maturity, volatility, barrier, rebate));
    return __result;
END_RCPP
}
// bermudanSwaptionEngine
Rcpp::List bermudanSwaptionEngine(Rcpp::List rparam, Rcpp::List tslist, Rcpp::NumericVector swaptionMat, Rcpp::NumericVector swapLengths, Rcpp::NumericMatrix swaptionVols);
RcppExport SEXP RQuantLib_bermudanSwaptionEngine(SEXP rparamSEXP, SEXP tslistSEXP, SEXP swaptionMatSEXP, SEXP swapLengthsSEXP, SEXP swaptionVolsSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< Rcpp::List >::type rparam(rparamSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type tslist(tslistSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type swaptionMat(swaptionMatSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type swapLengths(swapLengthsSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type swaptionVols(swaptionVolsSEXP);
    __result = Rcpp::wrap(bermudanSwaptionEngine(rparam, tslist, swaptionMat, swapLengths, swaptionVols));
    return __result;
END_RCPP
}
// zeroPriceByYieldEngine
double zeroPriceByYieldEngine(double yield, double faceAmount, double dayCounter, double frequency, double businessDayConvention, double compound, QuantLib::Date maturityDate, QuantLib::Date issueDate);
static SEXP RQuantLib_zeroPriceByYieldEngine_try(SEXP yieldSEXP, SEXP faceAmountSEXP, SEXP dayCounterSEXP, SEXP frequencySEXP, SEXP businessDayConventionSEXP, SEXP compoundSEXP, SEXP maturityDateSEXP, SEXP issueDateSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< double >::type yield(yieldSEXP);
    Rcpp::traits::input_parameter< double >::type faceAmount(faceAmountSEXP);
    Rcpp::traits::input_parameter< double >::type dayCounter(dayCounterSEXP);
    Rcpp::traits::input_parameter< double >::type frequency(frequencySEXP);
    Rcpp::traits::input_parameter< double >::type businessDayConvention(businessDayConventionSEXP);
    Rcpp::traits::input_parameter< double >::type compound(compoundSEXP);
    Rcpp::traits::input_parameter< QuantLib::Date >::type maturityDate(maturityDateSEXP);
    Rcpp::traits::input_parameter< QuantLib::Date >::type issueDate(issueDateSEXP);
    __result = Rcpp::wrap(zeroPriceByYieldEngine(yield, faceAmount, dayCounter, frequency, businessDayConvention, compound, maturityDate, issueDate));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_zeroPriceByYieldEngine(SEXP yieldSEXP, SEXP faceAmountSEXP, SEXP dayCounterSEXP, SEXP frequencySEXP, SEXP businessDayConventionSEXP, SEXP compoundSEXP, SEXP maturityDateSEXP, SEXP issueDateSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_zeroPriceByYieldEngine_try(yieldSEXP, faceAmountSEXP, dayCounterSEXP, frequencySEXP, businessDayConventionSEXP, compoundSEXP, maturityDateSEXP, issueDateSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// zeroYieldByPriceEngine
double zeroYieldByPriceEngine(double price, double faceAmount, double dayCounter, double frequency, double businessDayConvention, double compound, QuantLib::Date maturityDate, QuantLib::Date issueDate);
static SEXP RQuantLib_zeroYieldByPriceEngine_try(SEXP priceSEXP, SEXP faceAmountSEXP, SEXP dayCounterSEXP, SEXP frequencySEXP, SEXP businessDayConventionSEXP, SEXP compoundSEXP, SEXP maturityDateSEXP, SEXP issueDateSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< double >::type price(priceSEXP);
    Rcpp::traits::input_parameter< double >::type faceAmount(faceAmountSEXP);
    Rcpp::traits::input_parameter< double >::type dayCounter(dayCounterSEXP);
    Rcpp::traits::input_parameter< double >::type frequency(frequencySEXP);
    Rcpp::traits::input_parameter< double >::type businessDayConvention(businessDayConventionSEXP);
    Rcpp::traits::input_parameter< double >::type compound(compoundSEXP);
    Rcpp::traits::input_parameter< QuantLib::Date >::type maturityDate(maturityDateSEXP);
    Rcpp::traits::input_parameter< QuantLib::Date >::type issueDate(issueDateSEXP);
    __result = Rcpp::wrap(zeroYieldByPriceEngine(price, faceAmount, dayCounter, frequency, businessDayConvention, compound, maturityDate, issueDate));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_zeroYieldByPriceEngine(SEXP priceSEXP, SEXP faceAmountSEXP, SEXP dayCounterSEXP, SEXP frequencySEXP, SEXP businessDayConventionSEXP, SEXP compoundSEXP, SEXP maturityDateSEXP, SEXP issueDateSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_zeroYieldByPriceEngine_try(priceSEXP, faceAmountSEXP, dayCounterSEXP, frequencySEXP, businessDayConventionSEXP, compoundSEXP, maturityDateSEXP, issueDateSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// fixedRateBondYieldByPriceEngine
double fixedRateBondYieldByPriceEngine(double settlementDays, double price, std::string cal, double faceAmount, double businessDayConvention, double compound, double redemption, double dayCounter, double frequency, QuantLib::Date maturityDate, QuantLib::Date issueDate, QuantLib::Date effectiveDate, std::vector<double> rates);
static SEXP RQuantLib_fixedRateBondYieldByPriceEngine_try(SEXP settlementDaysSEXP, SEXP priceSEXP, SEXP calSEXP, SEXP faceAmountSEXP, SEXP businessDayConventionSEXP, SEXP compoundSEXP, SEXP redemptionSEXP, SEXP dayCounterSEXP, SEXP frequencySEXP, SEXP maturityDateSEXP, SEXP issueDateSEXP, SEXP effectiveDateSEXP, SEXP ratesSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< double >::type settlementDays(settlementDaysSEXP);
    Rcpp::traits::input_parameter< double >::type price(priceSEXP);
    Rcpp::traits::input_parameter< std::string >::type cal(calSEXP);
    Rcpp::traits::input_parameter< double >::type faceAmount(faceAmountSEXP);
    Rcpp::traits::input_parameter< double >::type businessDayConvention(businessDayConventionSEXP);
    Rcpp::traits::input_parameter< double >::type compound(compoundSEXP);
    Rcpp::traits::input_parameter< double >::type redemption(redemptionSEXP);
    Rcpp::traits::input_parameter< double >::type dayCounter(dayCounterSEXP);
    Rcpp::traits::input_parameter< double >::type frequency(frequencySEXP);
    Rcpp::traits::input_parameter< QuantLib::Date >::type maturityDate(maturityDateSEXP);
    Rcpp::traits::input_parameter< QuantLib::Date >::type issueDate(issueDateSEXP);
    Rcpp::traits::input_parameter< QuantLib::Date >::type effectiveDate(effectiveDateSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type rates(ratesSEXP);
    __result = Rcpp::wrap(fixedRateBondYieldByPriceEngine(settlementDays, price, cal, faceAmount, businessDayConvention, compound, redemption, dayCounter, frequency, maturityDate, issueDate, effectiveDate, rates));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_fixedRateBondYieldByPriceEngine(SEXP settlementDaysSEXP, SEXP priceSEXP, SEXP calSEXP, SEXP faceAmountSEXP, SEXP businessDayConventionSEXP, SEXP compoundSEXP, SEXP redemptionSEXP, SEXP dayCounterSEXP, SEXP frequencySEXP, SEXP maturityDateSEXP, SEXP issueDateSEXP, SEXP effectiveDateSEXP, SEXP ratesSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_fixedRateBondYieldByPriceEngine_try(settlementDaysSEXP, priceSEXP, calSEXP, faceAmountSEXP, businessDayConventionSEXP, compoundSEXP, redemptionSEXP, dayCounterSEXP, frequencySEXP, maturityDateSEXP, issueDateSEXP, effectiveDateSEXP, ratesSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// fixedRateBondPriceByYieldEngine
double fixedRateBondPriceByYieldEngine(double settlementDays, double yield, std::string cal, double faceAmount, double businessDayConvention, double compound, double redemption, double dayCounter, double frequency, QuantLib::Date maturityDate, QuantLib::Date issueDate, QuantLib::Date effectiveDate, std::vector<double> rates);
static SEXP RQuantLib_fixedRateBondPriceByYieldEngine_try(SEXP settlementDaysSEXP, SEXP yieldSEXP, SEXP calSEXP, SEXP faceAmountSEXP, SEXP businessDayConventionSEXP, SEXP compoundSEXP, SEXP redemptionSEXP, SEXP dayCounterSEXP, SEXP frequencySEXP, SEXP maturityDateSEXP, SEXP issueDateSEXP, SEXP effectiveDateSEXP, SEXP ratesSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< double >::type settlementDays(settlementDaysSEXP);
    Rcpp::traits::input_parameter< double >::type yield(yieldSEXP);
    Rcpp::traits::input_parameter< std::string >::type cal(calSEXP);
    Rcpp::traits::input_parameter< double >::type faceAmount(faceAmountSEXP);
    Rcpp::traits::input_parameter< double >::type businessDayConvention(businessDayConventionSEXP);
    Rcpp::traits::input_parameter< double >::type compound(compoundSEXP);
    Rcpp::traits::input_parameter< double >::type redemption(redemptionSEXP);
    Rcpp::traits::input_parameter< double >::type dayCounter(dayCounterSEXP);
    Rcpp::traits::input_parameter< double >::type frequency(frequencySEXP);
    Rcpp::traits::input_parameter< QuantLib::Date >::type maturityDate(maturityDateSEXP);
    Rcpp::traits::input_parameter< QuantLib::Date >::type issueDate(issueDateSEXP);
    Rcpp::traits::input_parameter< QuantLib::Date >::type effectiveDate(effectiveDateSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type rates(ratesSEXP);
    __result = Rcpp::wrap(fixedRateBondPriceByYieldEngine(settlementDays, yield, cal, faceAmount, businessDayConvention, compound, redemption, dayCounter, frequency, maturityDate, issueDate, effectiveDate, rates));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_fixedRateBondPriceByYieldEngine(SEXP settlementDaysSEXP, SEXP yieldSEXP, SEXP calSEXP, SEXP faceAmountSEXP, SEXP businessDayConventionSEXP, SEXP compoundSEXP, SEXP redemptionSEXP, SEXP dayCounterSEXP, SEXP frequencySEXP, SEXP maturityDateSEXP, SEXP issueDateSEXP, SEXP effectiveDateSEXP, SEXP ratesSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_fixedRateBondPriceByYieldEngine_try(settlementDaysSEXP, yieldSEXP, calSEXP, faceAmountSEXP, businessDayConventionSEXP, compoundSEXP, redemptionSEXP, dayCounterSEXP, frequencySEXP, maturityDateSEXP, issueDateSEXP, effectiveDateSEXP, ratesSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// FloatBond1
Rcpp::List FloatBond1(Rcpp::List bond, std::vector<double> gearings, std::vector<double> caps, std::vector<double> spreads, std::vector<double> floors, Rcpp::List indexparams, Rcpp::List index, Rcpp::List discountCurve, Rcpp::List dateparams);
static SEXP RQuantLib_FloatBond1_try(SEXP bondSEXP, SEXP gearingsSEXP, SEXP capsSEXP, SEXP spreadsSEXP, SEXP floorsSEXP, SEXP indexparamsSEXP, SEXP indexSEXP, SEXP discountCurveSEXP, SEXP dateparamsSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< Rcpp::List >::type bond(bondSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type gearings(gearingsSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type caps(capsSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type spreads(spreadsSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type floors(floorsSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type indexparams(indexparamsSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type index(indexSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type discountCurve(discountCurveSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type dateparams(dateparamsSEXP);
    __result = Rcpp::wrap(FloatBond1(bond, gearings, caps, spreads, floors, indexparams, index, discountCurve, dateparams));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_FloatBond1(SEXP bondSEXP, SEXP gearingsSEXP, SEXP capsSEXP, SEXP spreadsSEXP, SEXP floorsSEXP, SEXP indexparamsSEXP, SEXP indexSEXP, SEXP discountCurveSEXP, SEXP dateparamsSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_FloatBond1_try(bondSEXP, gearingsSEXP, capsSEXP, spreadsSEXP, floorsSEXP, indexparamsSEXP, indexSEXP, discountCurveSEXP, dateparamsSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// FloatBond2
Rcpp::List FloatBond2(Rcpp::List bond, std::vector<double> gearings, std::vector<double> caps, std::vector<double> spreads, std::vector<double> floors, Rcpp::List indexparams, Rcpp::List index_params, Rcpp::List index_tsQuotes, Rcpp::List index_times, Rcpp::List discountCurve, Rcpp::List dateparams);
static SEXP RQuantLib_FloatBond2_try(SEXP bondSEXP, SEXP gearingsSEXP, SEXP capsSEXP, SEXP spreadsSEXP, SEXP floorsSEXP, SEXP indexparamsSEXP, SEXP index_paramsSEXP, SEXP index_tsQuotesSEXP, SEXP index_timesSEXP, SEXP discountCurveSEXP, SEXP dateparamsSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< Rcpp::List >::type bond(bondSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type gearings(gearingsSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type caps(capsSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type spreads(spreadsSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type floors(floorsSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type indexparams(indexparamsSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type index_params(index_paramsSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type index_tsQuotes(index_tsQuotesSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type index_times(index_timesSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type discountCurve(discountCurveSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type dateparams(dateparamsSEXP);
    __result = Rcpp::wrap(FloatBond2(bond, gearings, caps, spreads, floors, indexparams, index_params, index_tsQuotes, index_times, discountCurve, dateparams));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_FloatBond2(SEXP bondSEXP, SEXP gearingsSEXP, SEXP capsSEXP, SEXP spreadsSEXP, SEXP floorsSEXP, SEXP indexparamsSEXP, SEXP index_paramsSEXP, SEXP index_tsQuotesSEXP, SEXP index_timesSEXP, SEXP discountCurveSEXP, SEXP dateparamsSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_FloatBond2_try(bondSEXP, gearingsSEXP, capsSEXP, spreadsSEXP, floorsSEXP, indexparamsSEXP, index_paramsSEXP, index_tsQuotesSEXP, index_timesSEXP, discountCurveSEXP, dateparamsSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// FloatBond3
Rcpp::List FloatBond3(Rcpp::List bond, std::vector<double> gearings, std::vector<double> caps, std::vector<double> spreads, std::vector<double> floors, Rcpp::List indexparams, Rcpp::List index, Rcpp::List disc_params, Rcpp::List disc_tsQuotes, Rcpp::List disc_times, Rcpp::List dateparams);
static SEXP RQuantLib_FloatBond3_try(SEXP bondSEXP, SEXP gearingsSEXP, SEXP capsSEXP, SEXP spreadsSEXP, SEXP floorsSEXP, SEXP indexparamsSEXP, SEXP indexSEXP, SEXP disc_paramsSEXP, SEXP disc_tsQuotesSEXP, SEXP disc_timesSEXP, SEXP dateparamsSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< Rcpp::List >::type bond(bondSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type gearings(gearingsSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type caps(capsSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type spreads(spreadsSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type floors(floorsSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type indexparams(indexparamsSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type index(indexSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type disc_params(disc_paramsSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type disc_tsQuotes(disc_tsQuotesSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type disc_times(disc_timesSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type dateparams(dateparamsSEXP);
    __result = Rcpp::wrap(FloatBond3(bond, gearings, caps, spreads, floors, indexparams, index, disc_params, disc_tsQuotes, disc_times, dateparams));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_FloatBond3(SEXP bondSEXP, SEXP gearingsSEXP, SEXP capsSEXP, SEXP spreadsSEXP, SEXP floorsSEXP, SEXP indexparamsSEXP, SEXP indexSEXP, SEXP disc_paramsSEXP, SEXP disc_tsQuotesSEXP, SEXP disc_timesSEXP, SEXP dateparamsSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_FloatBond3_try(bondSEXP, gearingsSEXP, capsSEXP, spreadsSEXP, floorsSEXP, indexparamsSEXP, indexSEXP, disc_paramsSEXP, disc_tsQuotesSEXP, disc_timesSEXP, dateparamsSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// FloatBond4
Rcpp::List FloatBond4(Rcpp::List bond, std::vector<double> gearings, std::vector<double> caps, std::vector<double> spreads, std::vector<double> floors, Rcpp::List indexparams, Rcpp::List index_params, Rcpp::List index_tsQuotes, Rcpp::List index_times, Rcpp::List disc_params, Rcpp::List disc_tsQuotes, Rcpp::List disc_times, Rcpp::List dateparams);
static SEXP RQuantLib_FloatBond4_try(SEXP bondSEXP, SEXP gearingsSEXP, SEXP capsSEXP, SEXP spreadsSEXP, SEXP floorsSEXP, SEXP indexparamsSEXP, SEXP index_paramsSEXP, SEXP index_tsQuotesSEXP, SEXP index_timesSEXP, SEXP disc_paramsSEXP, SEXP disc_tsQuotesSEXP, SEXP disc_timesSEXP, SEXP dateparamsSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< Rcpp::List >::type bond(bondSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type gearings(gearingsSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type caps(capsSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type spreads(spreadsSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type floors(floorsSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type indexparams(indexparamsSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type index_params(index_paramsSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type index_tsQuotes(index_tsQuotesSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type index_times(index_timesSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type disc_params(disc_paramsSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type disc_tsQuotes(disc_tsQuotesSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type disc_times(disc_timesSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type dateparams(dateparamsSEXP);
    __result = Rcpp::wrap(FloatBond4(bond, gearings, caps, spreads, floors, indexparams, index_params, index_tsQuotes, index_times, disc_params, disc_tsQuotes, disc_times, dateparams));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_FloatBond4(SEXP bondSEXP, SEXP gearingsSEXP, SEXP capsSEXP, SEXP spreadsSEXP, SEXP floorsSEXP, SEXP indexparamsSEXP, SEXP index_paramsSEXP, SEXP index_tsQuotesSEXP, SEXP index_timesSEXP, SEXP disc_paramsSEXP, SEXP disc_tsQuotesSEXP, SEXP disc_timesSEXP, SEXP dateparamsSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_FloatBond4_try(bondSEXP, gearingsSEXP, capsSEXP, spreadsSEXP, floorsSEXP, indexparamsSEXP, index_paramsSEXP, index_tsQuotesSEXP, index_timesSEXP, disc_paramsSEXP, disc_tsQuotesSEXP, disc_timesSEXP, dateparamsSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// floatingWithRebuiltCurveEngine
Rcpp::List floatingWithRebuiltCurveEngine(Rcpp::List bondparams, std::vector<double> gearings, std::vector<double> spreads, std::vector<double> caps, std::vector<double> floors, Rcpp::List indexparams, std::vector<QuantLib::Date> iborDateVec, std::vector<double> iborzeroVec, std::vector<QuantLib::Date> dateVec, std::vector<double> zeroVec, Rcpp::List dateparams);
static SEXP RQuantLib_floatingWithRebuiltCurveEngine_try(SEXP bondparamsSEXP, SEXP gearingsSEXP, SEXP spreadsSEXP, SEXP capsSEXP, SEXP floorsSEXP, SEXP indexparamsSEXP, SEXP iborDateVecSEXP, SEXP iborzeroVecSEXP, SEXP dateVecSEXP, SEXP zeroVecSEXP, SEXP dateparamsSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< Rcpp::List >::type bondparams(bondparamsSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type gearings(gearingsSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type spreads(spreadsSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type caps(capsSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type floors(floorsSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type indexparams(indexparamsSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type iborDateVec(iborDateVecSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type iborzeroVec(iborzeroVecSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type dateVec(dateVecSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type zeroVec(zeroVecSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type dateparams(dateparamsSEXP);
    __result = Rcpp::wrap(floatingWithRebuiltCurveEngine(bondparams, gearings, spreads, caps, floors, indexparams, iborDateVec, iborzeroVec, dateVec, zeroVec, dateparams));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_floatingWithRebuiltCurveEngine(SEXP bondparamsSEXP, SEXP gearingsSEXP, SEXP spreadsSEXP, SEXP capsSEXP, SEXP floorsSEXP, SEXP indexparamsSEXP, SEXP iborDateVecSEXP, SEXP iborzeroVecSEXP, SEXP dateVecSEXP, SEXP zeroVecSEXP, SEXP dateparamsSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_floatingWithRebuiltCurveEngine_try(bondparamsSEXP, gearingsSEXP, spreadsSEXP, capsSEXP, floorsSEXP, indexparamsSEXP, iborDateVecSEXP, iborzeroVecSEXP, dateVecSEXP, zeroVecSEXP, dateparamsSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// FixedRateWithYield
Rcpp::List FixedRateWithYield(Rcpp::List bondparam, std::vector<double> ratesVec, Rcpp::List scheduleparam, Rcpp::List calcparam, double yield);
static SEXP RQuantLib_FixedRateWithYield_try(SEXP bondparamSEXP, SEXP ratesVecSEXP, SEXP scheduleparamSEXP, SEXP calcparamSEXP, SEXP yieldSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< Rcpp::List >::type bondparam(bondparamSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type ratesVec(ratesVecSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type scheduleparam(scheduleparamSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type calcparam(calcparamSEXP);
    Rcpp::traits::input_parameter< double >::type yield(yieldSEXP);
    __result = Rcpp::wrap(FixedRateWithYield(bondparam, ratesVec, scheduleparam, calcparam, yield));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_FixedRateWithYield(SEXP bondparamSEXP, SEXP ratesVecSEXP, SEXP scheduleparamSEXP, SEXP calcparamSEXP, SEXP yieldSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_FixedRateWithYield_try(bondparamSEXP, ratesVecSEXP, scheduleparamSEXP, calcparamSEXP, yieldSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// FixedRateWithPrice
Rcpp::List FixedRateWithPrice(Rcpp::List bondparam, std::vector<double> ratesVec, Rcpp::List scheduleparam, Rcpp::List calcparam, double price);
static SEXP RQuantLib_FixedRateWithPrice_try(SEXP bondparamSEXP, SEXP ratesVecSEXP, SEXP scheduleparamSEXP, SEXP calcparamSEXP, SEXP priceSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< Rcpp::List >::type bondparam(bondparamSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type ratesVec(ratesVecSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type scheduleparam(scheduleparamSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type calcparam(calcparamSEXP);
    Rcpp::traits::input_parameter< double >::type price(priceSEXP);
    __result = Rcpp::wrap(FixedRateWithPrice(bondparam, ratesVec, scheduleparam, calcparam, price));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_FixedRateWithPrice(SEXP bondparamSEXP, SEXP ratesVecSEXP, SEXP scheduleparamSEXP, SEXP calcparamSEXP, SEXP priceSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_FixedRateWithPrice_try(bondparamSEXP, ratesVecSEXP, scheduleparamSEXP, calcparamSEXP, priceSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// FixedRateWithRebuiltCurve
Rcpp::List FixedRateWithRebuiltCurve(Rcpp::List bondparam, std::vector<double> ratesVec, Rcpp::List scheduleparam, Rcpp::List calcparam, std::vector<QuantLib::Date> dateVec, std::vector<double> zeroVec);
static SEXP RQuantLib_FixedRateWithRebuiltCurve_try(SEXP bondparamSEXP, SEXP ratesVecSEXP, SEXP scheduleparamSEXP, SEXP calcparamSEXP, SEXP dateVecSEXP, SEXP zeroVecSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< Rcpp::List >::type bondparam(bondparamSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type ratesVec(ratesVecSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type scheduleparam(scheduleparamSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type calcparam(calcparamSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type dateVec(dateVecSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type zeroVec(zeroVecSEXP);
    __result = Rcpp::wrap(FixedRateWithRebuiltCurve(bondparam, ratesVec, scheduleparam, calcparam, dateVec, zeroVec));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_FixedRateWithRebuiltCurve(SEXP bondparamSEXP, SEXP ratesVecSEXP, SEXP scheduleparamSEXP, SEXP calcparamSEXP, SEXP dateVecSEXP, SEXP zeroVecSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_FixedRateWithRebuiltCurve_try(bondparamSEXP, ratesVecSEXP, scheduleparamSEXP, calcparamSEXP, dateVecSEXP, zeroVecSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// ZeroBondWithRebuiltCurve
Rcpp::List ZeroBondWithRebuiltCurve(Rcpp::List bond, std::vector<QuantLib::Date> dateVec, std::vector<double> zeroVec, Rcpp::List dateparams);
static SEXP RQuantLib_ZeroBondWithRebuiltCurve_try(SEXP bondSEXP, SEXP dateVecSEXP, SEXP zeroVecSEXP, SEXP dateparamsSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< Rcpp::List >::type bond(bondSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type dateVec(dateVecSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type zeroVec(zeroVecSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type dateparams(dateparamsSEXP);
    __result = Rcpp::wrap(ZeroBondWithRebuiltCurve(bond, dateVec, zeroVec, dateparams));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_ZeroBondWithRebuiltCurve(SEXP bondSEXP, SEXP dateVecSEXP, SEXP zeroVecSEXP, SEXP dateparamsSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_ZeroBondWithRebuiltCurve_try(bondSEXP, dateVecSEXP, zeroVecSEXP, dateparamsSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// convertibleZeroBondEngine
Rcpp::List convertibleZeroBondEngine(Rcpp::List rparam, Rcpp::List processParam, std::vector<QuantLib::Date> dividendYieldDateVec, std::vector<double> dividendYieldZeroVec, std::vector<QuantLib::Date> rffDateVec, std::vector<double> rffZeroVec, Rcpp::DataFrame dividendScheduleFrame, Rcpp::DataFrame callabilityScheduleFrame, Rcpp::List datemisc);
static SEXP RQuantLib_convertibleZeroBondEngine_try(SEXP rparamSEXP, SEXP processParamSEXP, SEXP dividendYieldDateVecSEXP, SEXP dividendYieldZeroVecSEXP, SEXP rffDateVecSEXP, SEXP rffZeroVecSEXP, SEXP dividendScheduleFrameSEXP, SEXP callabilityScheduleFrameSEXP, SEXP datemiscSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< Rcpp::List >::type rparam(rparamSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type processParam(processParamSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type dividendYieldDateVec(dividendYieldDateVecSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type dividendYieldZeroVec(dividendYieldZeroVecSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type rffDateVec(rffDateVecSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type rffZeroVec(rffZeroVecSEXP);
    Rcpp::traits::input_parameter< Rcpp::DataFrame >::type dividendScheduleFrame(dividendScheduleFrameSEXP);
    Rcpp::traits::input_parameter< Rcpp::DataFrame >::type callabilityScheduleFrame(callabilityScheduleFrameSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type datemisc(datemiscSEXP);
    __result = Rcpp::wrap(convertibleZeroBondEngine(rparam, processParam, dividendYieldDateVec, dividendYieldZeroVec, rffDateVec, rffZeroVec, dividendScheduleFrame, callabilityScheduleFrame, datemisc));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_convertibleZeroBondEngine(SEXP rparamSEXP, SEXP processParamSEXP, SEXP dividendYieldDateVecSEXP, SEXP dividendYieldZeroVecSEXP, SEXP rffDateVecSEXP, SEXP rffZeroVecSEXP, SEXP dividendScheduleFrameSEXP, SEXP callabilityScheduleFrameSEXP, SEXP datemiscSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_convertibleZeroBondEngine_try(rparamSEXP, processParamSEXP, dividendYieldDateVecSEXP, dividendYieldZeroVecSEXP, rffDateVecSEXP, rffZeroVecSEXP, dividendScheduleFrameSEXP, callabilityScheduleFrameSEXP, datemiscSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// convertibleFixedBondEngine
Rcpp::List convertibleFixedBondEngine(Rcpp::List rparam, Rcpp::NumericVector rates, Rcpp::List processParam, std::vector<QuantLib::Date> dividendYieldDateVec, std::vector<double> dividendYieldZeroVec, std::vector<QuantLib::Date> rffDateVec, std::vector<double> rffZeroVec, Rcpp::DataFrame dividendScheduleFrame, Rcpp::DataFrame callabilityScheduleFrame, Rcpp::List datemisc);
static SEXP RQuantLib_convertibleFixedBondEngine_try(SEXP rparamSEXP, SEXP ratesSEXP, SEXP processParamSEXP, SEXP dividendYieldDateVecSEXP, SEXP dividendYieldZeroVecSEXP, SEXP rffDateVecSEXP, SEXP rffZeroVecSEXP, SEXP dividendScheduleFrameSEXP, SEXP callabilityScheduleFrameSEXP, SEXP datemiscSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< Rcpp::List >::type rparam(rparamSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type rates(ratesSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type processParam(processParamSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type dividendYieldDateVec(dividendYieldDateVecSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type dividendYieldZeroVec(dividendYieldZeroVecSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type rffDateVec(rffDateVecSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type rffZeroVec(rffZeroVecSEXP);
    Rcpp::traits::input_parameter< Rcpp::DataFrame >::type dividendScheduleFrame(dividendScheduleFrameSEXP);
    Rcpp::traits::input_parameter< Rcpp::DataFrame >::type callabilityScheduleFrame(callabilityScheduleFrameSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type datemisc(datemiscSEXP);
    __result = Rcpp::wrap(convertibleFixedBondEngine(rparam, rates, processParam, dividendYieldDateVec, dividendYieldZeroVec, rffDateVec, rffZeroVec, dividendScheduleFrame, callabilityScheduleFrame, datemisc));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_convertibleFixedBondEngine(SEXP rparamSEXP, SEXP ratesSEXP, SEXP processParamSEXP, SEXP dividendYieldDateVecSEXP, SEXP dividendYieldZeroVecSEXP, SEXP rffDateVecSEXP, SEXP rffZeroVecSEXP, SEXP dividendScheduleFrameSEXP, SEXP callabilityScheduleFrameSEXP, SEXP datemiscSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_convertibleFixedBondEngine_try(rparamSEXP, ratesSEXP, processParamSEXP, dividendYieldDateVecSEXP, dividendYieldZeroVecSEXP, rffDateVecSEXP, rffZeroVecSEXP, dividendScheduleFrameSEXP, callabilityScheduleFrameSEXP, datemiscSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// convertibleFloatingBondEngine
Rcpp::List convertibleFloatingBondEngine(Rcpp::List rparam, Rcpp::List processParam, std::vector<QuantLib::Date> dividendYieldDateVec, std::vector<double> dividendYieldZeroVec, std::vector<QuantLib::Date> rffDateVec, std::vector<double> rffZeroVec, std::vector<QuantLib::Date> iborIndexDateVec, std::vector<double> iborIndexZeroVec, Rcpp::List iborparams, std::vector<double> spreads, Rcpp::DataFrame dividendScheduleFrame, Rcpp::DataFrame callabilityScheduleFrame, Rcpp::List datemisc);
static SEXP RQuantLib_convertibleFloatingBondEngine_try(SEXP rparamSEXP, SEXP processParamSEXP, SEXP dividendYieldDateVecSEXP, SEXP dividendYieldZeroVecSEXP, SEXP rffDateVecSEXP, SEXP rffZeroVecSEXP, SEXP iborIndexDateVecSEXP, SEXP iborIndexZeroVecSEXP, SEXP iborparamsSEXP, SEXP spreadsSEXP, SEXP dividendScheduleFrameSEXP, SEXP callabilityScheduleFrameSEXP, SEXP datemiscSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< Rcpp::List >::type rparam(rparamSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type processParam(processParamSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type dividendYieldDateVec(dividendYieldDateVecSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type dividendYieldZeroVec(dividendYieldZeroVecSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type rffDateVec(rffDateVecSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type rffZeroVec(rffZeroVecSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type iborIndexDateVec(iborIndexDateVecSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type iborIndexZeroVec(iborIndexZeroVecSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type iborparams(iborparamsSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type spreads(spreadsSEXP);
    Rcpp::traits::input_parameter< Rcpp::DataFrame >::type dividendScheduleFrame(dividendScheduleFrameSEXP);
    Rcpp::traits::input_parameter< Rcpp::DataFrame >::type callabilityScheduleFrame(callabilityScheduleFrameSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type datemisc(datemiscSEXP);
    __result = Rcpp::wrap(convertibleFloatingBondEngine(rparam, processParam, dividendYieldDateVec, dividendYieldZeroVec, rffDateVec, rffZeroVec, iborIndexDateVec, iborIndexZeroVec, iborparams, spreads, dividendScheduleFrame, callabilityScheduleFrame, datemisc));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_convertibleFloatingBondEngine(SEXP rparamSEXP, SEXP processParamSEXP, SEXP dividendYieldDateVecSEXP, SEXP dividendYieldZeroVecSEXP, SEXP rffDateVecSEXP, SEXP rffZeroVecSEXP, SEXP iborIndexDateVecSEXP, SEXP iborIndexZeroVecSEXP, SEXP iborparamsSEXP, SEXP spreadsSEXP, SEXP dividendScheduleFrameSEXP, SEXP callabilityScheduleFrameSEXP, SEXP datemiscSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_convertibleFloatingBondEngine_try(rparamSEXP, processParamSEXP, dividendYieldDateVecSEXP, dividendYieldZeroVecSEXP, rffDateVecSEXP, rffZeroVecSEXP, iborIndexDateVecSEXP, iborIndexZeroVecSEXP, iborparamsSEXP, spreadsSEXP, dividendScheduleFrameSEXP, callabilityScheduleFrameSEXP, datemiscSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// callableBondEngine
Rcpp::List callableBondEngine(Rcpp::List rparam, Rcpp::List hwparam, Rcpp::NumericVector coupon, Rcpp::DataFrame callabilityScheduleFrame, Rcpp::List datemisc);
static SEXP RQuantLib_callableBondEngine_try(SEXP rparamSEXP, SEXP hwparamSEXP, SEXP couponSEXP, SEXP callabilityScheduleFrameSEXP, SEXP datemiscSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< Rcpp::List >::type rparam(rparamSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type hwparam(hwparamSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type coupon(couponSEXP);
    Rcpp::traits::input_parameter< Rcpp::DataFrame >::type callabilityScheduleFrame(callabilityScheduleFrameSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type datemisc(datemiscSEXP);
    __result = Rcpp::wrap(callableBondEngine(rparam, hwparam, coupon, callabilityScheduleFrame, datemisc));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_callableBondEngine(SEXP rparamSEXP, SEXP hwparamSEXP, SEXP couponSEXP, SEXP callabilityScheduleFrameSEXP, SEXP datemiscSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_callableBondEngine_try(rparamSEXP, hwparamSEXP, couponSEXP, callabilityScheduleFrameSEXP, datemiscSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// fittedBondCurveEngine
Rcpp::List fittedBondCurveEngine(Rcpp::List curveparam, Rcpp::NumericVector length, Rcpp::NumericVector coupons, Rcpp::NumericVector marketQuotes, Rcpp::List datemisc);
static SEXP RQuantLib_fittedBondCurveEngine_try(SEXP curveparamSEXP, SEXP lengthSEXP, SEXP couponsSEXP, SEXP marketQuotesSEXP, SEXP datemiscSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< Rcpp::List >::type curveparam(curveparamSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type length(lengthSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type coupons(couponsSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type marketQuotes(marketQuotesSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type datemisc(datemiscSEXP);
    __result = Rcpp::wrap(fittedBondCurveEngine(curveparam, length, coupons, marketQuotes, datemisc));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_fittedBondCurveEngine(SEXP curveparamSEXP, SEXP lengthSEXP, SEXP couponsSEXP, SEXP marketQuotesSEXP, SEXP datemiscSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_fittedBondCurveEngine_try(curveparamSEXP, lengthSEXP, couponsSEXP, marketQuotesSEXP, datemiscSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// setCalendarContext
bool setCalendarContext(std::string calendar, int fixingDays, QuantLib::Date settleDate);
RcppExport SEXP RQuantLib_setCalendarContext(SEXP calendarSEXP, SEXP fixingDaysSEXP, SEXP settleDateSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< std::string >::type calendar(calendarSEXP);
    Rcpp::traits::input_parameter< int >::type fixingDays(fixingDaysSEXP);
    Rcpp::traits::input_parameter< QuantLib::Date >::type settleDate(settleDateSEXP);
    __result = Rcpp::wrap(setCalendarContext(calendar, fixingDays, settleDate));
    return __result;
END_RCPP
}
// isBusinessDay
std::vector<bool> isBusinessDay(std::string calendar, std::vector<QuantLib::Date> dates);
RcppExport SEXP RQuantLib_isBusinessDay(SEXP calendarSEXP, SEXP datesSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< std::string >::type calendar(calendarSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type dates(datesSEXP);
    __result = Rcpp::wrap(isBusinessDay(calendar, dates));
    return __result;
END_RCPP
}
// isHoliday
std::vector<bool> isHoliday(std::string calendar, std::vector<QuantLib::Date> dates);
RcppExport SEXP RQuantLib_isHoliday(SEXP calendarSEXP, SEXP datesSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< std::string >::type calendar(calendarSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type dates(datesSEXP);
    __result = Rcpp::wrap(isHoliday(calendar, dates));
    return __result;
END_RCPP
}
// isWeekend
std::vector<bool> isWeekend(std::string calendar, std::vector<QuantLib::Date> dates);
RcppExport SEXP RQuantLib_isWeekend(SEXP calendarSEXP, SEXP datesSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< std::string >::type calendar(calendarSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type dates(datesSEXP);
    __result = Rcpp::wrap(isWeekend(calendar, dates));
    return __result;
END_RCPP
}
// isEndOfMonth
std::vector<bool> isEndOfMonth(std::string calendar, std::vector<QuantLib::Date> dates);
RcppExport SEXP RQuantLib_isEndOfMonth(SEXP calendarSEXP, SEXP datesSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< std::string >::type calendar(calendarSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type dates(datesSEXP);
    __result = Rcpp::wrap(isEndOfMonth(calendar, dates));
    return __result;
END_RCPP
}
// getEndOfMonth
std::vector<QuantLib::Date> getEndOfMonth(std::string calendar, std::vector<QuantLib::Date> dates);
RcppExport SEXP RQuantLib_getEndOfMonth(SEXP calendarSEXP, SEXP datesSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< std::string >::type calendar(calendarSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type dates(datesSEXP);
    __result = Rcpp::wrap(getEndOfMonth(calendar, dates));
    return __result;
END_RCPP
}
// adjust
std::vector<QuantLib::Date> adjust(std::string calendar, std::vector<QuantLib::Date> dates, int bdc);
RcppExport SEXP RQuantLib_adjust(SEXP calendarSEXP, SEXP datesSEXP, SEXP bdcSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< std::string >::type calendar(calendarSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type dates(datesSEXP);
    Rcpp::traits::input_parameter< int >::type bdc(bdcSEXP);
    __result = Rcpp::wrap(adjust(calendar, dates, bdc));
    return __result;
END_RCPP
}
// advance1
std::vector<QuantLib::Date> advance1(std::string calendar, double amount, double unit, int bdcVal, double emr, std::vector<QuantLib::Date> dates);
RcppExport SEXP RQuantLib_advance1(SEXP calendarSEXP, SEXP amountSEXP, SEXP unitSEXP, SEXP bdcValSEXP, SEXP emrSEXP, SEXP datesSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< std::string >::type calendar(calendarSEXP);
    Rcpp::traits::input_parameter< double >::type amount(amountSEXP);
    Rcpp::traits::input_parameter< double >::type unit(unitSEXP);
    Rcpp::traits::input_parameter< int >::type bdcVal(bdcValSEXP);
    Rcpp::traits::input_parameter< double >::type emr(emrSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type dates(datesSEXP);
    __result = Rcpp::wrap(advance1(calendar, amount, unit, bdcVal, emr, dates));
    return __result;
END_RCPP
}
// advance2
std::vector<QuantLib::Date> advance2(std::string calendar, double period, int bdcVal, double emr, std::vector<QuantLib::Date> dates);
RcppExport SEXP RQuantLib_advance2(SEXP calendarSEXP, SEXP periodSEXP, SEXP bdcValSEXP, SEXP emrSEXP, SEXP datesSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< std::string >::type calendar(calendarSEXP);
    Rcpp::traits::input_parameter< double >::type period(periodSEXP);
    Rcpp::traits::input_parameter< int >::type bdcVal(bdcValSEXP);
    Rcpp::traits::input_parameter< double >::type emr(emrSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type dates(datesSEXP);
    __result = Rcpp::wrap(advance2(calendar, period, bdcVal, emr, dates));
    return __result;
END_RCPP
}
// businessDaysBetween
std::vector<double> businessDaysBetween(std::string calendar, std::vector<QuantLib::Date> from, std::vector<QuantLib::Date> to, bool includeFirst, bool includeLast);
RcppExport SEXP RQuantLib_businessDaysBetween(SEXP calendarSEXP, SEXP fromSEXP, SEXP toSEXP, SEXP includeFirstSEXP, SEXP includeLastSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< std::string >::type calendar(calendarSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type from(fromSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type to(toSEXP);
    Rcpp::traits::input_parameter< bool >::type includeFirst(includeFirstSEXP);
    Rcpp::traits::input_parameter< bool >::type includeLast(includeLastSEXP);
    __result = Rcpp::wrap(businessDaysBetween(calendar, from, to, includeFirst, includeLast));
    return __result;
END_RCPP
}
// getHolidayList
std::vector<QuantLib::Date> getHolidayList(std::string calendar, QuantLib::Date from, QuantLib::Date to, bool includeWeekends);
RcppExport SEXP RQuantLib_getHolidayList(SEXP calendarSEXP, SEXP fromSEXP, SEXP toSEXP, SEXP includeWeekendsSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< std::string >::type calendar(calendarSEXP);
    Rcpp::traits::input_parameter< QuantLib::Date >::type from(fromSEXP);
    Rcpp::traits::input_parameter< QuantLib::Date >::type to(toSEXP);
    Rcpp::traits::input_parameter< bool >::type includeWeekends(includeWeekendsSEXP);
    __result = Rcpp::wrap(getHolidayList(calendar, from, to, includeWeekends));
    return __result;
END_RCPP
}
// advanceDate
QuantLib::Date advanceDate(QuantLib::Date issueDate, int days);
static SEXP RQuantLib_advanceDate_try(SEXP issueDateSEXP, SEXP daysSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< QuantLib::Date >::type issueDate(issueDateSEXP);
    Rcpp::traits::input_parameter< int >::type days(daysSEXP);
    __result = Rcpp::wrap(advanceDate(issueDate, days));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_advanceDate(SEXP issueDateSEXP, SEXP daysSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_advanceDate_try(issueDateSEXP, daysSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// dayCount
std::vector<double> dayCount(std::vector<QuantLib::Date> startDates, std::vector<QuantLib::Date> endDates, std::vector<double> dayCounters);
static SEXP RQuantLib_dayCount_try(SEXP startDatesSEXP, SEXP endDatesSEXP, SEXP dayCountersSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type startDates(startDatesSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type endDates(endDatesSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type dayCounters(dayCountersSEXP);
    __result = Rcpp::wrap(dayCount(startDates, endDates, dayCounters));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_dayCount(SEXP startDatesSEXP, SEXP endDatesSEXP, SEXP dayCountersSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_dayCount_try(startDatesSEXP, endDatesSEXP, dayCountersSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// yearFraction
std::vector<double> yearFraction(std::vector<QuantLib::Date> startDates, std::vector<QuantLib::Date> endDates, std::vector<double> dayCounters);
static SEXP RQuantLib_yearFraction_try(SEXP startDatesSEXP, SEXP endDatesSEXP, SEXP dayCountersSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type startDates(startDatesSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type endDates(endDatesSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type dayCounters(dayCountersSEXP);
    __result = Rcpp::wrap(yearFraction(startDates, endDates, dayCounters));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_yearFraction(SEXP startDatesSEXP, SEXP endDatesSEXP, SEXP dayCountersSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_yearFraction_try(startDatesSEXP, endDatesSEXP, dayCountersSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// setEvaluationDate
bool setEvaluationDate(QuantLib::Date evalDate);
static SEXP RQuantLib_setEvaluationDate_try(SEXP evalDateSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< QuantLib::Date >::type evalDate(evalDateSEXP);
    __result = Rcpp::wrap(setEvaluationDate(evalDate));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_setEvaluationDate(SEXP evalDateSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_setEvaluationDate_try(evalDateSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// discountCurveEngine
Rcpp::List discountCurveEngine(Rcpp::List rparams, Rcpp::List tslist, Rcpp::NumericVector times);
RcppExport SEXP RQuantLib_discountCurveEngine(SEXP rparamsSEXP, SEXP tslistSEXP, SEXP timesSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< Rcpp::List >::type rparams(rparamsSEXP);
    Rcpp::traits::input_parameter< Rcpp::List >::type tslist(tslistSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericVector >::type times(timesSEXP);
    __result = Rcpp::wrap(discountCurveEngine(rparams, tslist, times));
    return __result;
END_RCPP
}
// calibrateHullWhiteUsingCapsEngine
Rcpp::List calibrateHullWhiteUsingCapsEngine(std::vector<QuantLib::Date> termStrcDateVec, std::vector<double> termStrcZeroVec, Rcpp::DataFrame capDF, std::vector<QuantLib::Date> iborDateVec, std::vector<double> iborZeroVec, std::string iborType, QuantLib::Date evalDate);
RcppExport SEXP RQuantLib_calibrateHullWhiteUsingCapsEngine(SEXP termStrcDateVecSEXP, SEXP termStrcZeroVecSEXP, SEXP capDFSEXP, SEXP iborDateVecSEXP, SEXP iborZeroVecSEXP, SEXP iborTypeSEXP, SEXP evalDateSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type termStrcDateVec(termStrcDateVecSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type termStrcZeroVec(termStrcZeroVecSEXP);
    Rcpp::traits::input_parameter< Rcpp::DataFrame >::type capDF(capDFSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type iborDateVec(iborDateVecSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type iborZeroVec(iborZeroVecSEXP);
    Rcpp::traits::input_parameter< std::string >::type iborType(iborTypeSEXP);
    Rcpp::traits::input_parameter< QuantLib::Date >::type evalDate(evalDateSEXP);
    __result = Rcpp::wrap(calibrateHullWhiteUsingCapsEngine(termStrcDateVec, termStrcZeroVec, capDF, iborDateVec, iborZeroVec, iborType, evalDate));
    return __result;
END_RCPP
}
// calibrateHullWhiteUsingSwapsEngine
Rcpp::List calibrateHullWhiteUsingSwapsEngine(std::vector<QuantLib::Date> termStrcDateVec, std::vector<double> termStrcZeroVec, Rcpp::DataFrame swapDF, std::vector<QuantLib::Date> iborDateVec, std::vector<double> iborZeroVec, std::string iborType, QuantLib::Date evalDate);
RcppExport SEXP RQuantLib_calibrateHullWhiteUsingSwapsEngine(SEXP termStrcDateVecSEXP, SEXP termStrcZeroVecSEXP, SEXP swapDFSEXP, SEXP iborDateVecSEXP, SEXP iborZeroVecSEXP, SEXP iborTypeSEXP, SEXP evalDateSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type termStrcDateVec(termStrcDateVecSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type termStrcZeroVec(termStrcZeroVecSEXP);
    Rcpp::traits::input_parameter< Rcpp::DataFrame >::type swapDF(swapDFSEXP);
    Rcpp::traits::input_parameter< std::vector<QuantLib::Date> >::type iborDateVec(iborDateVecSEXP);
    Rcpp::traits::input_parameter< std::vector<double> >::type iborZeroVec(iborZeroVecSEXP);
    Rcpp::traits::input_parameter< std::string >::type iborType(iborTypeSEXP);
    Rcpp::traits::input_parameter< QuantLib::Date >::type evalDate(evalDateSEXP);
    __result = Rcpp::wrap(calibrateHullWhiteUsingSwapsEngine(termStrcDateVec, termStrcZeroVec, swapDF, iborDateVec, iborZeroVec, iborType, evalDate));
    return __result;
END_RCPP
}
// europeanOptionImpliedVolatilityEngine
double europeanOptionImpliedVolatilityEngine(std::string type, double value, double underlying, double strike, double dividendYield, double riskFreeRate, double maturity, double volatility);
static SEXP RQuantLib_europeanOptionImpliedVolatilityEngine_try(SEXP typeSEXP, SEXP valueSEXP, SEXP underlyingSEXP, SEXP strikeSEXP, SEXP dividendYieldSEXP, SEXP riskFreeRateSEXP, SEXP maturitySEXP, SEXP volatilitySEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< std::string >::type type(typeSEXP);
    Rcpp::traits::input_parameter< double >::type value(valueSEXP);
    Rcpp::traits::input_parameter< double >::type underlying(underlyingSEXP);
    Rcpp::traits::input_parameter< double >::type strike(strikeSEXP);
    Rcpp::traits::input_parameter< double >::type dividendYield(dividendYieldSEXP);
    Rcpp::traits::input_parameter< double >::type riskFreeRate(riskFreeRateSEXP);
    Rcpp::traits::input_parameter< double >::type maturity(maturitySEXP);
    Rcpp::traits::input_parameter< double >::type volatility(volatilitySEXP);
    __result = Rcpp::wrap(europeanOptionImpliedVolatilityEngine(type, value, underlying, strike, dividendYield, riskFreeRate, maturity, volatility));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_europeanOptionImpliedVolatilityEngine(SEXP typeSEXP, SEXP valueSEXP, SEXP underlyingSEXP, SEXP strikeSEXP, SEXP dividendYieldSEXP, SEXP riskFreeRateSEXP, SEXP maturitySEXP, SEXP volatilitySEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_europeanOptionImpliedVolatilityEngine_try(typeSEXP, valueSEXP, underlyingSEXP, strikeSEXP, dividendYieldSEXP, riskFreeRateSEXP, maturitySEXP, volatilitySEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// americanOptionImpliedVolatilityEngine
double americanOptionImpliedVolatilityEngine(std::string type, double value, double underlying, double strike, double dividendYield, double riskFreeRate, double maturity, double volguess, int timesteps, int gridpoints);
static SEXP RQuantLib_americanOptionImpliedVolatilityEngine_try(SEXP typeSEXP, SEXP valueSEXP, SEXP underlyingSEXP, SEXP strikeSEXP, SEXP dividendYieldSEXP, SEXP riskFreeRateSEXP, SEXP maturitySEXP, SEXP volguessSEXP, SEXP timestepsSEXP, SEXP gridpointsSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< std::string >::type type(typeSEXP);
    Rcpp::traits::input_parameter< double >::type value(valueSEXP);
    Rcpp::traits::input_parameter< double >::type underlying(underlyingSEXP);
    Rcpp::traits::input_parameter< double >::type strike(strikeSEXP);
    Rcpp::traits::input_parameter< double >::type dividendYield(dividendYieldSEXP);
    Rcpp::traits::input_parameter< double >::type riskFreeRate(riskFreeRateSEXP);
    Rcpp::traits::input_parameter< double >::type maturity(maturitySEXP);
    Rcpp::traits::input_parameter< double >::type volguess(volguessSEXP);
    Rcpp::traits::input_parameter< int >::type timesteps(timestepsSEXP);
    Rcpp::traits::input_parameter< int >::type gridpoints(gridpointsSEXP);
    __result = Rcpp::wrap(americanOptionImpliedVolatilityEngine(type, value, underlying, strike, dividendYield, riskFreeRate, maturity, volguess, timesteps, gridpoints));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_americanOptionImpliedVolatilityEngine(SEXP typeSEXP, SEXP valueSEXP, SEXP underlyingSEXP, SEXP strikeSEXP, SEXP dividendYieldSEXP, SEXP riskFreeRateSEXP, SEXP maturitySEXP, SEXP volguessSEXP, SEXP timestepsSEXP, SEXP gridpointsSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_americanOptionImpliedVolatilityEngine_try(typeSEXP, valueSEXP, underlyingSEXP, strikeSEXP, dividendYieldSEXP, riskFreeRateSEXP, maturitySEXP, volguessSEXP, timestepsSEXP, gridpointsSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// CreateSchedule
Rcpp::DateVector CreateSchedule(Rcpp::List params);
static SEXP RQuantLib_CreateSchedule_try(SEXP paramsSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< Rcpp::List >::type params(paramsSEXP);
    __result = Rcpp::wrap(CreateSchedule(params));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_CreateSchedule(SEXP paramsSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_CreateSchedule_try(paramsSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// europeanOptionEngine
Rcpp::List europeanOptionEngine(std::string type, double underlying, double strike, double dividendYield, double riskFreeRate, double maturity, double volatility);
static SEXP RQuantLib_europeanOptionEngine_try(SEXP typeSEXP, SEXP underlyingSEXP, SEXP strikeSEXP, SEXP dividendYieldSEXP, SEXP riskFreeRateSEXP, SEXP maturitySEXP, SEXP volatilitySEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< std::string >::type type(typeSEXP);
    Rcpp::traits::input_parameter< double >::type underlying(underlyingSEXP);
    Rcpp::traits::input_parameter< double >::type strike(strikeSEXP);
    Rcpp::traits::input_parameter< double >::type dividendYield(dividendYieldSEXP);
    Rcpp::traits::input_parameter< double >::type riskFreeRate(riskFreeRateSEXP);
    Rcpp::traits::input_parameter< double >::type maturity(maturitySEXP);
    Rcpp::traits::input_parameter< double >::type volatility(volatilitySEXP);
    __result = Rcpp::wrap(europeanOptionEngine(type, underlying, strike, dividendYield, riskFreeRate, maturity, volatility));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_europeanOptionEngine(SEXP typeSEXP, SEXP underlyingSEXP, SEXP strikeSEXP, SEXP dividendYieldSEXP, SEXP riskFreeRateSEXP, SEXP maturitySEXP, SEXP volatilitySEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_europeanOptionEngine_try(typeSEXP, underlyingSEXP, strikeSEXP, dividendYieldSEXP, riskFreeRateSEXP, maturitySEXP, volatilitySEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// americanOptionEngine
Rcpp::List americanOptionEngine(std::string type, double underlying, double strike, double dividendYield, double riskFreeRate, double maturity, double volatility, int timeSteps, int gridPoints, std::string engine);
static SEXP RQuantLib_americanOptionEngine_try(SEXP typeSEXP, SEXP underlyingSEXP, SEXP strikeSEXP, SEXP dividendYieldSEXP, SEXP riskFreeRateSEXP, SEXP maturitySEXP, SEXP volatilitySEXP, SEXP timeStepsSEXP, SEXP gridPointsSEXP, SEXP engineSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< std::string >::type type(typeSEXP);
    Rcpp::traits::input_parameter< double >::type underlying(underlyingSEXP);
    Rcpp::traits::input_parameter< double >::type strike(strikeSEXP);
    Rcpp::traits::input_parameter< double >::type dividendYield(dividendYieldSEXP);
    Rcpp::traits::input_parameter< double >::type riskFreeRate(riskFreeRateSEXP);
    Rcpp::traits::input_parameter< double >::type maturity(maturitySEXP);
    Rcpp::traits::input_parameter< double >::type volatility(volatilitySEXP);
    Rcpp::traits::input_parameter< int >::type timeSteps(timeStepsSEXP);
    Rcpp::traits::input_parameter< int >::type gridPoints(gridPointsSEXP);
    Rcpp::traits::input_parameter< std::string >::type engine(engineSEXP);
    __result = Rcpp::wrap(americanOptionEngine(type, underlying, strike, dividendYield, riskFreeRate, maturity, volatility, timeSteps, gridPoints, engine));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_americanOptionEngine(SEXP typeSEXP, SEXP underlyingSEXP, SEXP strikeSEXP, SEXP dividendYieldSEXP, SEXP riskFreeRateSEXP, SEXP maturitySEXP, SEXP volatilitySEXP, SEXP timeStepsSEXP, SEXP gridPointsSEXP, SEXP engineSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_americanOptionEngine_try(typeSEXP, underlyingSEXP, strikeSEXP, dividendYieldSEXP, riskFreeRateSEXP, maturitySEXP, volatilitySEXP, timeStepsSEXP, gridPointsSEXP, engineSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// europeanOptionArraysEngine
Rcpp::List europeanOptionArraysEngine(std::string type, Rcpp::NumericMatrix par);
static SEXP RQuantLib_europeanOptionArraysEngine_try(SEXP typeSEXP, SEXP parSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::traits::input_parameter< std::string >::type type(typeSEXP);
    Rcpp::traits::input_parameter< Rcpp::NumericMatrix >::type par(parSEXP);
    __result = Rcpp::wrap(europeanOptionArraysEngine(type, par));
    return __result;
END_RCPP_RETURN_ERROR
}
RcppExport SEXP RQuantLib_europeanOptionArraysEngine(SEXP typeSEXP, SEXP parSEXP) {
    SEXP __result;
    {
        Rcpp::RNGScope __rngScope;
        __result = PROTECT(RQuantLib_europeanOptionArraysEngine_try(typeSEXP, parSEXP));
    }
    Rboolean __isInterrupt = Rf_inherits(__result, "interrupted-error");
    if (__isInterrupt) {
        UNPROTECT(1);
        Rf_onintr();
    }
    Rboolean __isError = Rf_inherits(__result, "try-error");
    if (__isError) {
        SEXP __msgSEXP = Rf_asChar(__result);
        UNPROTECT(1);
        Rf_error(CHAR(__msgSEXP));
    }
    UNPROTECT(1);
    return __result;
}
// zeroprice
double zeroprice(double yield, QuantLib::Date maturity, QuantLib::Date settle, int period, int basis);
RcppExport SEXP RQuantLib_zeroprice(SEXP yieldSEXP, SEXP maturitySEXP, SEXP settleSEXP, SEXP periodSEXP, SEXP basisSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< double >::type yield(yieldSEXP);
    Rcpp::traits::input_parameter< QuantLib::Date >::type maturity(maturitySEXP);
    Rcpp::traits::input_parameter< QuantLib::Date >::type settle(settleSEXP);
    Rcpp::traits::input_parameter< int >::type period(periodSEXP);
    Rcpp::traits::input_parameter< int >::type basis(basisSEXP);
    __result = Rcpp::wrap(zeroprice(yield, maturity, settle, period, basis));
    return __result;
END_RCPP
}
// zeroyield
double zeroyield(double price, QuantLib::Date maturity, QuantLib::Date settle, int period, int basis);
RcppExport SEXP RQuantLib_zeroyield(SEXP priceSEXP, SEXP maturitySEXP, SEXP settleSEXP, SEXP periodSEXP, SEXP basisSEXP) {
BEGIN_RCPP
    Rcpp::RObject __result;
    Rcpp::RNGScope __rngScope;
    Rcpp::traits::input_parameter< double >::type price(priceSEXP);
    Rcpp::traits::input_parameter< QuantLib::Date >::type maturity(maturitySEXP);
    Rcpp::traits::input_parameter< QuantLib::Date >::type settle(settleSEXP);
    Rcpp::traits::input_parameter< int >::type period(periodSEXP);
    Rcpp::traits::input_parameter< int >::type basis(basisSEXP);
    __result = Rcpp::wrap(zeroyield(price, maturity, settle, period, basis));
    return __result;
END_RCPP
}

// validate (ensure exported C++ functions exist before calling them)
static int RQuantLib_RcppExport_validate(const char* sig) { 
    static std::set<std::string> signatures;
    if (signatures.empty()) {
        signatures.insert("double(*zeroPriceByYieldEngine)(double,double,double,double,double,double,QuantLib::Date,QuantLib::Date)");
        signatures.insert("double(*zeroYieldByPriceEngine)(double,double,double,double,double,double,QuantLib::Date,QuantLib::Date)");
        signatures.insert("double(*fixedRateBondYieldByPriceEngine)(double,double,std::string,double,double,double,double,double,double,QuantLib::Date,QuantLib::Date,QuantLib::Date,std::vector<double>)");
        signatures.insert("double(*fixedRateBondPriceByYieldEngine)(double,double,std::string,double,double,double,double,double,double,QuantLib::Date,QuantLib::Date,QuantLib::Date,std::vector<double>)");
        signatures.insert("Rcpp::List(*FloatBond1)(Rcpp::List,std::vector<double>,std::vector<double>,std::vector<double>,std::vector<double>,Rcpp::List,Rcpp::List,Rcpp::List,Rcpp::List)");
        signatures.insert("Rcpp::List(*FloatBond2)(Rcpp::List,std::vector<double>,std::vector<double>,std::vector<double>,std::vector<double>,Rcpp::List,Rcpp::List,Rcpp::List,Rcpp::List,Rcpp::List,Rcpp::List)");
        signatures.insert("Rcpp::List(*FloatBond3)(Rcpp::List,std::vector<double>,std::vector<double>,std::vector<double>,std::vector<double>,Rcpp::List,Rcpp::List,Rcpp::List,Rcpp::List,Rcpp::List,Rcpp::List)");
        signatures.insert("Rcpp::List(*FloatBond4)(Rcpp::List,std::vector<double>,std::vector<double>,std::vector<double>,std::vector<double>,Rcpp::List,Rcpp::List,Rcpp::List,Rcpp::List,Rcpp::List,Rcpp::List,Rcpp::List,Rcpp::List)");
        signatures.insert("Rcpp::List(*floatingWithRebuiltCurveEngine)(Rcpp::List,std::vector<double>,std::vector<double>,std::vector<double>,std::vector<double>,Rcpp::List,std::vector<QuantLib::Date>,std::vector<double>,std::vector<QuantLib::Date>,std::vector<double>,Rcpp::List)");
        signatures.insert("Rcpp::List(*FixedRateWithYield)(Rcpp::List,std::vector<double>,Rcpp::List,Rcpp::List,double)");
        signatures.insert("Rcpp::List(*FixedRateWithPrice)(Rcpp::List,std::vector<double>,Rcpp::List,Rcpp::List,double)");
        signatures.insert("Rcpp::List(*FixedRateWithRebuiltCurve)(Rcpp::List,std::vector<double>,Rcpp::List,Rcpp::List,std::vector<QuantLib::Date>,std::vector<double>)");
        signatures.insert("Rcpp::List(*ZeroBondWithRebuiltCurve)(Rcpp::List,std::vector<QuantLib::Date>,std::vector<double>,Rcpp::List)");
        signatures.insert("Rcpp::List(*convertibleZeroBondEngine)(Rcpp::List,Rcpp::List,std::vector<QuantLib::Date>,std::vector<double>,std::vector<QuantLib::Date>,std::vector<double>,Rcpp::DataFrame,Rcpp::DataFrame,Rcpp::List)");
        signatures.insert("Rcpp::List(*convertibleFixedBondEngine)(Rcpp::List,Rcpp::NumericVector,Rcpp::List,std::vector<QuantLib::Date>,std::vector<double>,std::vector<QuantLib::Date>,std::vector<double>,Rcpp::DataFrame,Rcpp::DataFrame,Rcpp::List)");
        signatures.insert("Rcpp::List(*convertibleFloatingBondEngine)(Rcpp::List,Rcpp::List,std::vector<QuantLib::Date>,std::vector<double>,std::vector<QuantLib::Date>,std::vector<double>,std::vector<QuantLib::Date>,std::vector<double>,Rcpp::List,std::vector<double>,Rcpp::DataFrame,Rcpp::DataFrame,Rcpp::List)");
        signatures.insert("Rcpp::List(*callableBondEngine)(Rcpp::List,Rcpp::List,Rcpp::NumericVector,Rcpp::DataFrame,Rcpp::List)");
        signatures.insert("Rcpp::List(*fittedBondCurveEngine)(Rcpp::List,Rcpp::NumericVector,Rcpp::NumericVector,Rcpp::NumericVector,Rcpp::List)");
        signatures.insert("QuantLib::Date(*advanceDate)(QuantLib::Date,int)");
        signatures.insert("std::vector<double>(*dayCount)(std::vector<QuantLib::Date>,std::vector<QuantLib::Date>,std::vector<double>)");
        signatures.insert("std::vector<double>(*yearFraction)(std::vector<QuantLib::Date>,std::vector<QuantLib::Date>,std::vector<double>)");
        signatures.insert("bool(*setEvaluationDate)(QuantLib::Date)");
        signatures.insert("double(*europeanOptionImpliedVolatilityEngine)(std::string,double,double,double,double,double,double,double)");
        signatures.insert("double(*americanOptionImpliedVolatilityEngine)(std::string,double,double,double,double,double,double,double,int,int)");
        signatures.insert("Rcpp::DateVector(*CreateSchedule)(Rcpp::List)");
        signatures.insert("Rcpp::List(*europeanOptionEngine)(std::string,double,double,double,double,double,double)");
        signatures.insert("Rcpp::List(*americanOptionEngine)(std::string,double,double,double,double,double,double,int,int,std::string)");
        signatures.insert("Rcpp::List(*europeanOptionArraysEngine)(std::string,Rcpp::NumericMatrix)");
    }
    return signatures.find(sig) != signatures.end();
}

// registerCCallable (register entry points for exported C++ functions)
RcppExport SEXP RQuantLib_RcppExport_registerCCallable() { 
    R_RegisterCCallable("RQuantLib", "RQuantLib_zeroPriceByYieldEngine", (DL_FUNC)RQuantLib_zeroPriceByYieldEngine_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_zeroYieldByPriceEngine", (DL_FUNC)RQuantLib_zeroYieldByPriceEngine_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_fixedRateBondYieldByPriceEngine", (DL_FUNC)RQuantLib_fixedRateBondYieldByPriceEngine_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_fixedRateBondPriceByYieldEngine", (DL_FUNC)RQuantLib_fixedRateBondPriceByYieldEngine_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_FloatBond1", (DL_FUNC)RQuantLib_FloatBond1_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_FloatBond2", (DL_FUNC)RQuantLib_FloatBond2_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_FloatBond3", (DL_FUNC)RQuantLib_FloatBond3_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_FloatBond4", (DL_FUNC)RQuantLib_FloatBond4_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_floatingWithRebuiltCurveEngine", (DL_FUNC)RQuantLib_floatingWithRebuiltCurveEngine_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_FixedRateWithYield", (DL_FUNC)RQuantLib_FixedRateWithYield_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_FixedRateWithPrice", (DL_FUNC)RQuantLib_FixedRateWithPrice_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_FixedRateWithRebuiltCurve", (DL_FUNC)RQuantLib_FixedRateWithRebuiltCurve_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_ZeroBondWithRebuiltCurve", (DL_FUNC)RQuantLib_ZeroBondWithRebuiltCurve_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_convertibleZeroBondEngine", (DL_FUNC)RQuantLib_convertibleZeroBondEngine_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_convertibleFixedBondEngine", (DL_FUNC)RQuantLib_convertibleFixedBondEngine_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_convertibleFloatingBondEngine", (DL_FUNC)RQuantLib_convertibleFloatingBondEngine_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_callableBondEngine", (DL_FUNC)RQuantLib_callableBondEngine_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_fittedBondCurveEngine", (DL_FUNC)RQuantLib_fittedBondCurveEngine_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_advanceDate", (DL_FUNC)RQuantLib_advanceDate_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_dayCount", (DL_FUNC)RQuantLib_dayCount_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_yearFraction", (DL_FUNC)RQuantLib_yearFraction_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_setEvaluationDate", (DL_FUNC)RQuantLib_setEvaluationDate_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_europeanOptionImpliedVolatilityEngine", (DL_FUNC)RQuantLib_europeanOptionImpliedVolatilityEngine_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_americanOptionImpliedVolatilityEngine", (DL_FUNC)RQuantLib_americanOptionImpliedVolatilityEngine_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_CreateSchedule", (DL_FUNC)RQuantLib_CreateSchedule_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_europeanOptionEngine", (DL_FUNC)RQuantLib_europeanOptionEngine_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_americanOptionEngine", (DL_FUNC)RQuantLib_americanOptionEngine_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_europeanOptionArraysEngine", (DL_FUNC)RQuantLib_europeanOptionArraysEngine_try);
    R_RegisterCCallable("RQuantLib", "RQuantLib_RcppExport_validate", (DL_FUNC)RQuantLib_RcppExport_validate);
    return R_NilValue;
}
