% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{RRR_sim}
\alias{RRR_sim}
\title{Simulating data for Reduced-Rank Regression}
\usage{
RRR_sim(
  N = 1000,
  P = 3,
  Q = 3,
  R = 1,
  r = 1,
  mu = rep(0.1, P),
  A = matrix(rnorm(P * r), ncol = r),
  B = matrix(rnorm(Q * r), ncol = r),
  D = matrix(rnorm(P * R), ncol = R),
  varcov = diag(P),
  innov = mvtnorm::rmvt(N, sigma = varcov, df = 3),
  mean_x = 0,
  mean_z = 0,
  x = NULL,
  z = NULL
)
}
\arguments{
\item{N}{Integer. The total number of simulated realizations.}

\item{P}{Integer. The dimension of the response variable matrix. See \code{Detail}.}

\item{Q}{Integer. The dimension of the explanatory variable matrix to be projected. See \code{Detail}.}

\item{R}{Integer. The dimension of the explanatory variable matrix not to be projected. See \code{Detail}.}

\item{r}{Integer. The rank of the reduced rank coefficient matrix. See \code{Detail}.}

\item{mu}{Vector with length P. The constants. Can be \code{NULL} to drop the term. See \code{Detail}.}

\item{A}{Matrix with dimension P*r. The exposure matrix. See \code{Detail}.}

\item{B}{Matrix with dimension Q*r. The factor matrix. See \code{Detail}.}

\item{D}{Matrix with dimension P*R. The coefficient matrix for \code{z}. Can be \code{NULL} to drop the term. See \code{Detail}.}

\item{varcov}{Matrix with dimension P*P. The covariance matrix of the innovation. See \code{Detail}.}

\item{innov}{Matrix with dimension N*P. The innovations. Default to be simulated from a Student t distribution, See \code{Detail}.}

\item{mean_x}{Integer. The mean of the normal distribution \eqn{x} is simulated from.}

\item{mean_z}{Integer. The mean of the normal distribution \eqn{z} is simulated from.}

\item{x}{Matrix with dimension N*Q. Can be used to specify \eqn{x} instead of simulating form a normal distribution.}

\item{z}{Matrix with dimension N*R. Can be used to specify \eqn{z} instead of simulating form a normal distribution.}
}
\value{
A list of the input specifications and the data \eqn{y}, \eqn{x}, and \eqn{z}, of class \code{RRR_data}.
\describe{
\item{y}{Matrix of dimension N*P}
\item{x}{Matrix of dimension N*Q}
\item{z}{Matrix of dimension N*R}
}
}
\description{
Simulate data for Reduced-rank regression. See \code{Detail} for the formulation
of the simulated data.
}
\details{
The data simulated can be used for the standard reduced-rank regression testing
with the following formulation
\deqn{y = \mu +AB'  x + D z+innov,}
where for each realization \eqn{y} is a vector of dimension \eqn{P} for the \eqn{P} response variables,
\eqn{x} is a vector of dimension \eqn{Q} for the \eqn{Q} explanatory variables that will be projected to
reduce the rank,
\eqn{z} is a vector of dimension \eqn{R} for the \eqn{R} explanatory variables
that will not be projected,
\eqn{\mu} is the constant vector of dimension \eqn{P},
\eqn{innov} is the innovation vector of dimension \eqn{P},
\eqn{D} is a coefficient matrix for \eqn{z} with dimension \eqn{P*R},
\eqn{A} is the so called exposure matrix with dimension \eqn{P*r}, and
\eqn{B} is the so called factor matrix with dimension \eqn{Q*r}.
The matrix resulted from \eqn{AB'} will be a reduced rank coefficient matrix with rank of \eqn{r}.
The function simulates \eqn{x}, \eqn{z} from multivariate normal distribution and \eqn{y} by specifying
parameters \eqn{\mu}, \eqn{A}, \eqn{B}, \eqn{D}, and \eqn{varcov}, the covariance matrix of
the innovation's distribution.  The constant \eqn{\mu} and the term \eqn{Dz} can be
dropped by setting \code{NULL} for arguments \code{mu} and \code{D}. The \code{innov} in the argument is
the collection of innovations of all the realizations.
}
\examples{
set.seed(2222)
data <- RRR_sim()

}
\author{
Yangzhuoran Yang
}
