% Generated by roxygen2 (4.0.2): do not edit by hand
\name{RRlog}
\alias{RRlog}
\title{Logistic randomized response regression}
\usage{
RRlog(formula, data, model, p, group, LR.test = TRUE, fit.n = c(10, 100),
  fit.bound = 10, maxit = 1000, start = NULL, ...)
}
\arguments{
\item{formula}{specifying the regression model, see \code{\link{formula}}}

\item{data}{\code{data.frame}, in which variables can be found (optional)}

\item{model}{Available RR models: \code{"Warner","UQTknown","UQTunknown","Mangat","Kuk","FR","Crosswise","CDM","CDMsym","SLD"}. See \code{vignette("RRreg")} for details.}

\item{p}{randomization probability/probabilities (depending on model)}

\item{group}{vector specifying group membership. Can be omitted for single-group RR designs (e.g., Warner). For two-group RR designs (e.g., \code{CDM} or \code{SLD}), use 1 and 2 to indicate the group membership, matching the respective randomization probabilities \code{p[1], p[2]}. If an RR design and a direct question (DQ) were both used in the study, the group indices are set to 0 (DQ) and 1 (RR; 1 or 2 for two-group RR designs). This can be used to test, whether the RR design leads to a different prevalence estimate by including a dummy variable for the question format (RR vs. DQ) as predictor. If the corresponding regression coefficient is significant, the prevalence estimates differ between RR and DQ. Similarly, interaction hypotheses can be tested (e.g., the correlation between a sensitive attribute and a predictor is only found using the RR but not the DQ design). Hypotheses like this can be tested by including the interaction of the DQ-RR-dummy variable and the predictor in \code{formula} (e.g., \code{RR ~ dummy*predictor}).}

\item{LR.test}{test regression coefficients by a likelihood ratio test, i.e., fitting the model repeatedly while excluding one parameter at a time}

\item{fit.n}{Minimum and maximum number of fitting replications using random starting values to avoid local maxima (only if \code{start=NULL})}

\item{fit.bound}{The model is fitted repeatedly either until the absolute parameter estimates are below \code{fit.bound} or the maximum number of fitting replication is reached. Thereby, stability of the estimates is increased. \code{fit.bound} should be increased if extreme parameter estimates are to be expected.}

\item{maxit}{Maximum number of iterations within each run of \code{optim}}

\item{start}{starting values for optimization. Might be useful if model does not converge with default starting values.}

\item{...}{ignored}
}
\value{
Returns an object \code{RRlog} which can be analysed by the generic method \code{\link{summary}}
}
\description{
A dichotomous variable, measured by a randomized response method, serves as dependent variable using one or more continuous and/or categorical predictors
}
\examples{
# generate data set without biases
dat <- RRgen(1000,pi=.3,"Warner",p=.8)
dat$covariate <- rnorm(1000)
dat$covariate[dat$true==1] <- rnorm(sum(dat$true==1),.4,1)
# analyse
ana <- RRlog(response~covariate,dat,"Warner",.8, fit.n = c(1,5))
summary(ana)
}
\author{
Daniel W. Heck
}
\references{
van den Hout, A., van der Heijden, P. G., & Gilchrist, R. (2007). The logistic regression model with response variables subject to randomized response. \emph{Computational Statistics & Data Analysis, 51}, 6060-6069.
}
\seealso{
\code{vignette('RRreg')} or \url{https://dl.dropboxusercontent.com/u/21456540/RRreg/index.html} for a detailed description of the RR models and the appropriate definition of \code{p}
}

