\docType{data}
\name{motcon}
\alias{motcon}
\title{Data set on motive congruence.}
\format{A data frame with 84 rows and 3 variables}
\description{
  A dataset containing the explicit power motive, implicit
  power motive and self ratings of affective valence during
  a spontaneous speech. The variables are as follows:
}
\details{
  \itemize{ \item ePow Explicit power motive, measured with
  a questionnaire (Unified Motive Scales, Schönbrodt &
  Gerstenberg, 2012). Raw values have been z standardized.
  \item iPow Implicit power motive, measure with picture
  story exercise (6 pictures). Raw motive scores have been
  controlled for word count and z standardized \item postVA
  z standardized valence rating after the speech (`How did
  you feel during the speech'). Consists of two bipolar
  items from the PANAVA questionnaire (Schallberger, 2005):
  `zufrieden ... unzufrieden' (satisfied ... unsatisfied)
  and `unglücklich ... glücklich' (unhappy ... happy). }
}
\references{
  Schallberger, U. (2005). \emph{Kurzskala zur Erfassung
  der Positiven Aktivierung, Negativen Aktivierung und
  Valenz in Experience Sampling Studien (PANAVA-KS) [Short
  scales for the assessment of positive affect, negative
  affect, and valence in experience sampling studies]}.
  University of Zurich.

  Schönbrodt, F. D., & Gerstenberg, F. X. R. (2012). An IRT
  analysis of motive questionnaires: The Unified Motive
  Scales. \emph{Journal of Research in Personality, 46},
  725–742. doi:10.1016/j.jrp.2012.08.010
}
\keyword{datasets}

