% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RSAGA-modules.R
\name{rsaga.topdown.processing}
\alias{rsaga.topdown.processing}
\title{Top-Down Processing}
\usage{
rsaga.topdown.processing(in.dem, in.sinkroute, in.weight, in.mean, in.material,
  in.target, in.lin.val, in.lin.dir, out.carea, out.mean, out.tot.mat,
  out.acc.left, out.acc.right, out.flowpath, step, method = "mfd",
  linear.threshold = Inf, convergence = 1.1, env = rsaga.env(), ...)
}
\arguments{
\item{in.dem}{input: digital elevation model (DEM) as SAGA grid file (default file extension: \code{.sgrd})}

\item{in.sinkroute}{optional input: SAGA grid with sink routes}

\item{in.weight}{optional input: SAGA grid with weights}

\item{in.mean}{optional input: SAGA grid for mean over catchment calculation}

\item{in.material}{optional input: SAGA grid with material}

\item{in.target}{optional input: SAGA grid of accumulation target}

\item{in.lin.val}{optional input: SAGA grid providing values to be compared with linear flow threshold instead of catchment area}

\item{in.lin.dir}{optional input: SAGA grid to be used for linear flow routing, if the value is a valid direction (0-7 = N, NE, E, SE, S, SW, W, NW)}

\item{out.carea}{output: catchment area grid}

\item{out.mean}{optional output: mean over catchment grid}

\item{out.tot.mat}{optional output: total accumulated material grid}

\item{out.acc.left}{optional output: accumulated material from left side grid}

\item{out.acc.right}{optional output: accumulated material from right side grid}

\item{out.flowpath}{optional output: flow path length grid}

\item{step}{integer >=1: step parameter}

\item{method}{character or numeric: choice of processing algorithm (default \code{"mfd"}, or 4):
\itemize{
\item [0] Deterministic 8 (\code{"d8"} or 0)
\item [1] Rho 8 (\code{"rho8"}, or 1)
\item [2] Braunschweiger Reliefmodell (\code{"braunschweig"} or 2)
\item [3] Deterministic Infinity (\code{"dinf"} or 3)
\item [4] Multiple Flow Direction (\code{"mfd"} or 4)
\item [5] Multiple Triangular Flow Direction (\code{"mtfd"}, or 5)
\item [6] Multiple Maximum Gradient Based Flow Direction (\code{"mdg"}, or 6)}}

\item{linear.threshold}{numeric (number of grid cells): threshold above which linear flow (i.e. the Deterministic 8 algorithm) will be used; linear flow is disabled for \code{linear.threshold=Inf} (the default)}

\item{convergence}{numeric >=0: a parameter for tuning convergent/ divergent flow; default value of \code{1.1} gives realistic results and should not be changed}

\item{env}{list, setting up a SAGA geoprocessing environment as created by \code{\link{rsaga.env}}}

\item{...}{further arguments to \code{\link{rsaga.geoprocessor}}}
}
\value{
The type of object returned depends on the \code{intern} argument passed to the \code{\link{rsaga.geoprocessor}}. For \code{intern=FALSE} it is a numerical error code (0: success), or otherwise (the default) a character vector with the module's console output.
}
\description{
Calculate the size of the local catchment area (contributing area), accumulated material, and flow path length, using top-down processing algorithms from the highest to the lowest cell. \cr Top-Down Processing is new with SAGA GIS 2.1.3. See \code{\link{rsaga.parallel.processing}} with older versions.
}
\details{
Refer to the references for details on the available algorithms.
}
\examples{
\dontrun{
# Calculation of contributing area with default settings:
rsaga.topdown.processing(in.dem = "dem", out.carea = "carea")
# Calculation of contributing area by maximunm downslope gradient:
rsaga.topdown.processing(in.dem = "dem", out.carea = "carea",
                         method = "mdg")
}
}
\author{
Alexander Brenning and Donovan Bangs (R interface), Olaf Conrad (SAGA module), Thomas Grabs (MTFD algorithm)
}
\references{
Deterministic 8:

O'Callaghan, J.F., Mark, D.M. (1984): The extraction of drainage networks from digital elevation data. Computer Vision, Graphics and Image Processing, 28: 323-344.

Rho 8:

Fairfield, J., Leymarie, P. (1991): Drainage networks from grid digital elevation models. Water Resources Research, 27: 709-717.

Braunschweiger Reliefmodell:

Bauer, J., Rohdenburg, H., Bork, H.-R. (1985): Ein Digitales Reliefmodell als Vorraussetzung fuer ein deterministisches Modell der Wasser- und Stoff-Fluesse. Landschaftsgenese und Landschaftsoekologie, H. 10, Parameteraufbereitung fuer deterministische Gebiets-Wassermodelle, Grundlagenarbeiten zu Analyse von Agrar-Oekosystemen, eds.: Bork, H.-R., Rohdenburg, H., p. 1-15.

Deterministic Infinity:

Tarboton, D.G. (1997): A new method for the determination of flow directions and upslope areas in grid digital elevation models. Water Ressources Research, 33(2): 309-319.

Multiple Flow Direction:

Freeman, G.T. (1991): Calculating catchment area with divergent flow based on a regular grid. Computers and Geosciences, 17: 413-22.

Quinn, P.F., Beven, K.J., Chevallier, P., Planchon, O. (1991): The prediction of hillslope flow paths for distributed hydrological modelling using digital terrain models. Hydrological Processes, 5: 59-79.

Multiple Triangular Flow Direction:

Seibert, J., McGlynn, B. (2007): A new triangular multiple flow direction algorithm for computing upslope areas from gridded digital elevation models. Water Ressources Research, 43, W04501.

Multiple Flow Direction Based on Maximum Downslope Gradient:

Qin, C.Z., Zhu, A-X., Pei, T., Li, B.L., Scholten, T., Zhou, C.H. (2011): An approach to computing topographic wetness index based on maximum downslope gradient. Precision Agriculture, 12(1): 32-43.
}
\seealso{
\code{\link{rsaga.parallel.processing}}, \code{\link{rsaga.wetness.index}}, \code{\link{rsaga.geoprocessor}}, \code{\link{rsaga.env}}
}
\keyword{interface}
\keyword{spatial}

