% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSAGA-modules.R
\name{rsaga.local.morphometry}
\alias{rsaga.local.morphometry}
\alias{rsaga.slope}
\alias{rsaga.aspect}
\alias{rsaga.curvature}
\alias{rsaga.plan.curvature}
\alias{rsaga.profile.curvature}
\title{Local Morphometry}
\usage{
rsaga.local.morphometry(in.dem, out.slope, out.aspect, out.curv, out.hcurv,
  out.vcurv, method = "poly2zevenbergen", env = rsaga.env(), ...)

rsaga.slope(in.dem, out.slope, method = "poly2zevenbergen",
  env = rsaga.env(), ...)

rsaga.aspect(in.dem, out.aspect, method = "poly2zevenbergen",
  env = rsaga.env(), ...)

rsaga.curvature(in.dem, out.curv, method = "poly2zevenbergen",
  env = rsaga.env(), ...)

rsaga.plan.curvature(in.dem, out.hcurv, method = "poly2zevenbergen",
  env = rsaga.env(), ...)

rsaga.profile.curvature(in.dem, out.vcurv, method = "poly2zevenbergen",
  env = rsaga.env(), ...)
}
\arguments{
\item{in.dem}{input: digital elevation model (DEM) as SAGA grid file (default file extension: \code{.sgrd})}

\item{out.slope}{optional output: slope (in radians)}

\item{out.aspect}{optional output: aspect (in radians; north=0, clockwise angles)}

\item{out.curv}{optional output: curvature}

\item{out.hcurv}{optional output: horizontal curvature (plan curvature)}

\item{out.vcurv}{optional output: vertical curvature (profile curvature)}

\item{method}{character (or numeric): algorithm (see References):
\itemize{
\item 0 Maximum Slope - Travis et al. (1975) (\code{"maxslope"}, or 0)
\item 1 Max. Triangle Slope - Tarboton (1997) (\code{"maxtriangleslope"}, or 1)
\item 2 Least Squares Fit Plane - Costa-Cabral and Burgess (1996) (\code{"lsqfitplane"}, or 2)
\item 3 Fit 2nd Degree Polynomial - Bauer et al. (1985) (\code{"poly2bauer"}, or 3)
\item 4 Fit 2nd Degree Polynomial - Heerdegen and Beran (1982) (\code{"poly2heerdegen"}, or 4)
\item 5 default: Fit 2nd Degree Polynomial - Zevenbergen and Thorne (1987) (\code{"poly2zevenbergen"}, or 5)
\item 6 Fit 3rd Degree Polynomial - Haralick (1983) (\code{"poly3haralick"}, or 6).
}}

\item{env}{list, setting up a SAGA geoprocessing environment as created by \code{\link[=rsaga.env]{rsaga.env()}}}

\item{...}{further arguments to \code{\link[=rsaga.geoprocessor]{rsaga.geoprocessor()}}}
}
\value{
The type of object returned depends on the \code{intern} argument passed to the \code{\link[=rsaga.geoprocessor]{rsaga.geoprocessor()}}. For \code{intern=FALSE} it is a numerical error code (0: success), or otherwise (default) a character vector with the module's console output.
}
\description{
Calculates local morphometric terrain attributes (i.e. slope, aspect and curvatures). Intended for use with SAGA versions 2.1.0 and older. Use \code{\link[=rsaga.slope.asp.curv]{rsaga.slope.asp.curv()}} for SAGA 2.1.1+
}
\examples{
\dontrun{
# a simple slope algorithm:
rsaga.slope("lican.sgrd","slope","maxslope")
# same for ASCII grids (default extension .asc):
rsaga.esri.wrapper(rsaga.slope,in.dem="lican",out.slope="slope",method="maxslope")
}
}
\references{
For references and algorithm changes in SAGA GIS 2.1.1+ see \code{\link[=rsaga.slope.asp.curv]{rsaga.slope.asp.curv()}}.
}
\seealso{
\code{\link[=rsaga.slope.asp.curv]{rsaga.slope.asp.curv()}}, \code{\link[=rsaga.parallel.processing]{rsaga.parallel.processing()}}, \code{\link[=rsaga.geoprocessor]{rsaga.geoprocessor()}},  \code{\link[=rsaga.env]{rsaga.env()}}
}
\author{
Alexander Brenning and Donovan Bangs (R interface), Olaf Conrad (SAGA module)
}
\keyword{interface}
\keyword{spatial}
