/*
 * Decompiled with CFR 0.152.
 */
package org.act.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.act.util.ContentTable;

public class CsvUtils {
    private static final char DEFAULT_SEPARATOR = ',';

    private CsvUtils() {
    }

    public static ContentTable.RowOriented read(InputStream stream) throws IOException {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        try (InputStreamReader streamReader = new InputStreamReader(stream);
             BufferedReader reader = new BufferedReader(streamReader);){
            reader.lines().forEach(line -> contents.add(CsvUtils.parse(line)));
        }
        List columnNames = (List)contents.remove(0);
        return ContentTable.rowOriented(columnNames, contents);
    }

    public static List<String> parse(String line) {
        ArrayList<String> values = new ArrayList<String>();
        String delimiter = String.valueOf(',');
        int start = 0;
        int end = 0;
        while (start < line.length() || end != -1) {
            end = line.indexOf(delimiter, start);
            int endIndex = end != -1 ? end : line.length();
            values.add(start < line.length() ? line.substring(start, endIndex) : "");
            start = endIndex + delimiter.length();
        }
        return values;
    }

    public static void write(ContentTable.RowOriented data, OutputStream stream) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(stream);){
            writer.write(CsvUtils.format(data.columnNames()) + System.lineSeparator());
            for (List<String> row : data.rows()) {
                writer.write(CsvUtils.format(row) + System.lineSeparator());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String format(Iterable<String> values) {
        StringBuilder sb = new StringBuilder();
        values.forEach(value -> sb.append(sb.length() > 0 ? ',' + value : value));
        return sb.toString();
    }
}

