% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASSD_LL.R
\name{assd.ll.test}
\alias{assd.ll.test}
\title{Compares random prospects by ASSD-LL}
\usage{
assd.ll.test(sd.obj)
}
\arguments{
\item{sd.obj}{StochasticDominance object.}
}
\value{
A list, including all the calculation details.
}
\description{
It uses the positive and negative areas that are computed by ASSD-LL and the
expected values of the prospects to compare them based on the ASSD-LL rule.
If the violation area ratio is less than 0.5 for a prospect, and its expected
value is larger, it dominates the other by ASSD-LL.
}
\details{
epsilon shows the ratio of the violation. Smaller epsilon means more
decision-makers agree with the result.

The returned list has six elements: `winner` indicates the dominant prospect
index. It will be zero if neither dominates the other. `epsilon` is the ratio
of violated area to the total area between the CDFs. `area` is a vector, where
the values show the area between the CDFs correspond to each segment.
`total.area` is the total area between the CDFs. `positive.area` is the
amount of area where the `area` vector is positive, meaning the `cdf1` is
larger than `cdf2` and `ssd1` is larger than `ssd2`. `negative.area` is like
`positive.area` for negative values.
}
\seealso{
[expected.values(), pos.neg.area.assd.ll(), afsd.test()] for more
details.
}
