% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting.R
\name{stat_classifier}
\alias{stat_classifier}
\title{Plot RSSL classifier boundaries}
\usage{
stat_classifier(mapping = NULL, data = NULL, show.legend = NA,
  inherit.aes = TRUE, breaks = 0, precision = 50, brute_force = FALSE,
  classifiers = classifiers, ...)
}
\arguments{
\item{mapping}{aes; aesthetic mapping}

\item{data}{data.frame; data to be diplayed}

\item{show.legend}{logical; Whether this layer should be included in the legend}

\item{inherit.aes}{logical; If FALSE, overrides the default aesthetics}

\item{breaks}{double; decision value for which to plot the boundary}

\item{precision}{integer; grid size to sketch classification boundary}

\item{brute_force}{logical; If TRUE, uses numerical estimation even for linear classifiers}

\item{classifiers}{List of Classifier objects to plot}

\item{...}{Additional parameters passed to geom}
}
\description{
Plot RSSL classifier boundaries
}
\examples{
library(RSSL)
library(ggplot2)
library(dplyr)

df <- generateCrescentMoon(200)

# This takes a couple of seconds to run
\dontrun{
g_svm <- SVM(Class~.,df,kernel = kernlab::rbfdot(sigma = 1))
g_ls <- LeastSquaresClassifier(Class~.,df)
g_nm <- NearestMeanClassifier(Class~.,df)


df \%>\% 
  ggplot(aes(x=X1,y=X2,color=Class,shape=Class)) +
  geom_point(size=3) +
  coord_equal() +
  scale_x_continuous(limits=c(-20,20), expand=c(0,0)) +
  scale_y_continuous(limits=c(-20,20), expand=c(0,0)) +
  stat_classifier(aes(linetype=..classifier..),
                  color="black", precision=50,
                  classifiers=list("SVM"=g_svm,"NM"=g_nm,"LS"=g_ls)
  )
}   
}
