/******************************************************************************
 * SIENA: Simulation Investigation for Empirical Network Analysis
 *
 * Web: http://www.stats.ox.ac.uk/~snijders/siena/
 *
 * File: AllEffects.h
 *
 * Description: This is a helper file that includes the declarations of all
 * effects. It can be conveniently included in files requiring all effects.
 *****************************************************************************/

#ifndef ALLEFFECTS_H_
#define ALLEFFECTS_H_

#include "AverageAlterEffect.h"
#include "AverageReciprocatedAlterEffect.h"
#include "BalanceEffect.h"
#include "BetweennessEffect.h"
#include "CovariateAlterEffect.h"
#include "CovariateEgoAlterEffect.h"
#include "CovariateEgoEffect.h"
#include "CovariateIndirectTiesEffect.h"
#include "CovariateSimilarityEffect.h"
#include "DenseTriadsBehaviorEffect.h"
#include "DenseTriadsEffect.h"
#include "DenseTriadsSimilarityEffect.h"
#include "DensityEffect.h"
#include "DistanceTwoEffect.h"
#include "DyadicCovariateMainEffect.h"
#include "DyadicCovariateReciprocityEffect.h"
#include "FourCyclesEffect.h"
#include "HigherCovariateEffect.h"
#include "IndegreeEffect.h"
#include "IndegreeActivityEffect.h"
#include "IndegreePopularityEffect.h"
#include "InInDegreeAssortativityEffect.h"
#include "InOutDegreeAssortativityEffect.h"
#include "InteractionCovariateEffect.h"
#include "InverseOutdegreeEffect.h"
#include "InverseSquaredOutdegreeEffect.h"
#include "IsolateEffect.h"
#include "LinearShapeEffect.h"
#include "MainCovariateEffect.h"
#include "NetworkInteractionEffect.h"
#include "OutdegreeEffect.h"
#include "OutdegreeActivityEffect.h"
#include "OutdegreeActivitySqrtEffect.h"
#include "OutdegreePopularityEffect.h"
#include "OutInDegreeAssortativityEffect.h"
#include "OutOutDegreeAssortativityEffect.h"
#include "PopularityAlterEffect.h"
#include "QuadraticShapeEffect.h"
#include "ReciprocalDegreeBehaviorEffect.h"
#include "ReciprocatedSimilarityEffect.h"
#include "ReciprocityEffect.h"
#include "SameCovariateEffect.h"
#include "SimilarityEffect.h"
#include "ThreeCyclesEffect.h"
#include "TransitiveMediatedTripletsEffect.h"
#include "TransitiveTiesEffect.h"
#include "TransitiveTriadsEffect.h"
#include "TransitiveTripletsEffect.h"
#include "WWXClosureEffect.h"
#include "WXXClosureEffect.h"
#include "XWXClosureEffect.h"

#endif /*ALLEFFECTS_H_*/
