% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_api_prj.R
\name{prj_zip}
\alias{prj_zip}
\title{Prepares deployment zip tagged with version.}
\usage{
prj_zip(prj = NULL, path = getwd(), zip_ver = NULL)
}
\arguments{
\item{prj}{project object to zip. if not passed will zip the loaded project or
the default whichever exists. Will init default project from the working
directory if no default project exists. (type: rsuite_project, default: NULL)}

\item{path}{folder path to put output zip into. If the folder does not exist, will
create it. (type: character: default: \code{getwd()})}

\item{zip_ver}{if passed enforce the version of the zip package to the passed value.
Expected form of version is DD.DD. (type: character, default: NULL)}
}
\value{
invisible file path to pack file created. The file name will be
   in form <ProjectName>_<version>.zip
}
\description{
It collects all dependencies and project packages installed in local project
environment together with master scripts and artifacts and zips them into
a single zip file.
}
\details{
Zip package generated is stamped with version. It can be enforced with zip_ver
parameter (zip will have suffix <zip_ver>x in the case). If the version is not
enforced it is detected out of ZipVersion setting in project PARAMETERS file or
from the maximal project packages version number. In that case, revision number is
appended to version: version number will be <zip_ver>_<rc_ver>. Check for
changes in project sources is performed for zip package consistency.

Before building zip package project is built. If revision number detected
project packages will have version altered: revision will be added as least
number to package version.

Logs all messages from the building process onto rsuite logger. Use \code{logging::setLevel}
to control logs verbosity. DEBUG level turns on building and downloading messages.
}
\examples{
# create exemplary project base folder
prj_base <- tempfile("example_")
dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

# start project
prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

# build deployment zip
zip_fpath <- prj_zip(prj = prj, path = tempdir(), zip_ver = "1.0")

}
\seealso{
Other in project management: \code{\link{prj_build}},
  \code{\link{prj_clean_deps}}, \code{\link{prj_init}},
  \code{\link{prj_install_deps}}, \code{\link{prj_load}},
  \code{\link{prj_lock_env}}, \code{\link{prj_pack}},
  \code{\link{prj_start_package}}, \code{\link{prj_start}},
  \code{\link{prj_unload}}
}
