% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freedom_functions_1.R
\name{n.pooled}
\alias{n.pooled}
\title{Sample size for pooled testing for freedom}
\usage{
n.pooled(sep, k, pstar, pse, psp = 1)
}
\arguments{
\item{sep}{desired population sensitivity (scalar or vector)}

\item{k}{pool size (constant across pools) (scalar or vector of same length as sep)}

\item{pstar}{design prevalence (scalar or vector of same length as sep)}

\item{pse}{pool-level sensitivity (scalar or vector of same length as sep)}

\item{psp}{pool-level specificity (scalar or vector of same length as sep)}
}
\value{
vector of sample sizes
}
\description{
Calculates sample size to achieve desired
  population-level sensitivity, assuming pooled sampling
  and allowing for imperfect sensitivity and specificity of the pooled test
}
\examples{
# examples for n.pooled
n.pooled(0.95, 5, 0.01, 1, 1)
n.pooled(0.95, 10, 0.1, 0.9, 1)
n.pooled(0.95, c(2, 5, 10, 20), 0.1, c(0.99, 0.98, 0.97, 0.95), 1)
}
\keyword{methods}

