% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetBitmapImage.R
\name{GetBitmapImage}
\alias{GetBitmapImage}
\title{Create Icon Bitmap Image}
\usage{
GetBitmapImage(type)
}
\arguments{
\item{type}{character.
Icon image type, see \sQuote{Details}}
}
\value{
An image of class tclObj.
}
\description{
Create a small \acronym{Tk} bitmap image.
}
\details{
Icon image types include:
  \var{left}, \var{right}, \var{up}, \var{down}, \var{top}, \var{bottom},
  \var{upleft}, \var{upright}, \var{downleft}, \var{downright}, \var{next},
  \var{previous}, \var{copy}, \var{paste}, \var{find}, \var{delete},
  \var{view}, \var{info}, \var{plus}, \var{minus}, \var{print}, and \var{histogram}.
  A recommended editor for bitmap design is Paul Obermeier's
  \href{http://www.posoft.de/html/poBitmapMain.html}{poBitmap} tool;
  specify a square icon 11 pixels on each side.
}
\examples{
\dontrun{
  types <- c("left", "right", "up", "down", "top", "bottom", "upleft", "upright",
             "downleft", "downright", "next", "previous", "copy", "paste", "find",
             "delete", "view", "info", "plus", "minus", "print", "histogram")
  Fun <- function(k) print(types[k])
  tt <- tcltk::tktoplevel(padx = 50, pady = 50)
  i <- 0
  j <- 0
  d <- 5
  for (k in seq_along(types)) {
    img <- paste("img", k, sep = ".")
    but <- paste("but", k, sep = ".")
    assign(img, GetBitmapImage(types[k]))
    assign(but, tcltk::ttkbutton(tt, width = 2, image = get(img),
                                 command = local({k <- k; function() Fun(k)})))
    tcltk::tkgrid(get(but), row = i, column = j, padx = 5, pady = 5)
    i <- k \%/\% d
    j <- ifelse(j < d - 1, j + 1, 0)
  }
}

}
\seealso{
\code{\link[tcltk]{tkimage.create}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{misc}
