% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadfun.R
\name{generateObject}
\alias{generateObject}
\title{Load data}
\usage{
generateObject(experimentDesign = NULL,nstates = 3, rigidity=NULL,
seqlengths = NULL, verbose = TRUE)
}
\arguments{
\item{experimentDesign}{a data Frame that contains minimum a column with the files direction (name of the column files) and another with a shorter name to be used inside the function.}

\item{nstates}{the number of states to be fitted in the model. A standard setting would use 3 states (Homozygous1, Heterozygous, and Homozygous2).}

\item{rigidity}{an integer number specifying the rigidity parameter to be used.}

\item{seqlengths}{a named vector with the chromosome lenghts of the organism that the user is working with.}

\item{verbose}{logical value. Whether to print info messages.}
}
\value{
RTIGER object
}
\description{
Load data
}
\examples{

data("ATseqlengths")
path = system.file("extdata",  package = "RTIGER")
files = list.files(path, full.names = TRUE)
nam = sapply(list.files(path ), function(x) unlist(strsplit(x, split = "[.]"))[1])
expDesign = data.frame(files = files, name = nam)
names(ATseqlengths) = paste0("Chr", 1:5)
myres = generateObject(experimentDesign = expDesign,
              seqlengths = ATseqlengths,
              rigidity = 10
)


}
