% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaanalysis.R
\name{plot.metaanalysis}
\alias{plot.metaanalysis}
\title{Forestplot for metaanalysis object.}
\usage{
\method{plot}{metaanalysis}(x, type = "both", xlims = NULL, ...)
}
\arguments{
\item{x}{metaanalysis object from the RTSA package.}

\item{type}{Define whether or not both fixed-effect and random-effects meta-analysis results should be printed on the plot. Options are: "fixed", "random" or "both". Default is "both".}

\item{xlims}{Set default limits on the outcome scale. Default is NULL.}

\item{...}{Additional arguments}
}
\description{
Forestplot for metaanalysis object.
}
\examples{
# Example with OR 
ma <- metaanalysis(data = coronary, outcome = "OR")
plot(ma)

# Example with RR 
ma <- metaanalysis(data = perioOxy, outcome = "RR")
plot(ma)

# Example with MD
ma <- metaanalysis(data = eds, outcome = "MD")
plot(ma, type = "random")
}
