% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RUVIII_C_Varying.R
\name{RUVIII_C_Varying}
\alias{RUVIII_C_Varying}
\title{RUV-III-C, varying controls}
\usage{
RUVIII_C_Varying(
  k,
  Y,
  M,
  toCorrect,
  potentialControls,
  withExtra = FALSE,
  withW = FALSE,
  withAlpha = FALSE,
  version = "CPP",
  progress = TRUE,
  ...
)
}
\arguments{
\item{k}{The number of factors of unwanted variation to remove}

\item{Y}{The input data matrix. Must be a matrix, not a data.frame. It should contain missing (NA) values, rather than zeros.}

\item{M}{The design matrix containing information about technical replicates. It should not contain an intercept term!}

\item{toCorrect}{The names of the variables to correct using RUV-III-C}

\item{potentialControls}{The names of the control variables which are known to be constant across the observations}

\item{withExtra}{Should we generate extra information?}

\item{withW}{Should we generate the matrices W giving information about the unwanted factors, for every peptide?}

\item{withAlpha}{Should we generate, per-peptide, the matrix alpha giving the effects of the unwanted factors?}

\item{version}{The version of the underlying code to use. Must be either "CPP" or "R"}

\item{progress}{Should a progress bar be displayed?}

\item{...}{Other arguments for the prototype R code. Supported values are \code{filename} for a checkpoint file, and \code{batchSize} for the frequency with which the checkpoint file is written.}
}
\value{
If withExtra = FALSE, returns a matrix. If withExtra = TRUE, returns a list with entries named \code{newY}, \code{residualDimensions} and \code{W}.
}
\description{
Apply RUV-III-C, a variation of RUV-III that only uses non-missing values
}
\details{
See the documentation of \link{RUVIII_C} for more information about the RUV-III-C method. This function is identical, except in this case the set of negative control variables actually used varies depending on the target variable to be normalized. Instead of putting in a list of negative control variables, the user specifies a list of potential negatve control variables. 

When normalizing variable X, the algorithm begins by selecting the rows of the data matrix for which X is non-missing. Out of the potential negative control peptides, it selects those that are always non-missing across the selected subset. The standard version of RUV-III is then applied to the subset, similar to \link{RUVIII_C}. 

There are two implementations of this function, one in C++ and one in R. Select which version using the \code{version} argument, which must be either "CPP" or "R"
}
\examples{
data(crossLab)
#Design matrix containing information about which runs are technical replicates of each other. 
#In this case, random pairings of mass-spec runs analysing the same sample, at different sites.
#Note that we specify no intercept term!
M <- model.matrix(~ grouping - 1, data = peptideData)
#Get out the list of peptides, both HEK (control) and peptides of interest.
peptides <- setdiff(colnames(peptideData), c("filename", "site", "mixture", "Date", "grouping"))
#Reduce the data matrix to only the peptide data
onlyPeptideData <- data.matrix(peptideData[, peptides])
#All the human peptides are potential controls. That is, everything that's not an SIS peptides.
potentialControls <- setdiff(peptides, sisPeptides)
#But we want to use controls that are *often* found
potentialControlsOftenFound <- names(which(apply(onlyPeptideData[, potentialControls], 2, 
    function(x) sum(is.na(x))) <= 10))
#Actually run correction
\donttest{results <- RUVIII_C(k = 11, Y = log10(onlyPeptideData), M = M, toCorrect = 
    colnames(onlyPeptideData), controls = potentialControlsOftenFound)}
}
