/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators;

import java.io.Serializable;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class Test
implements Serializable {
    int m_AttIndex;
    double m_Split;
    boolean m_Not;
    Instances m_Dataset;

    public Test(int n, double d, Instances instances) {
        this.m_AttIndex = n;
        this.m_Split = d;
        this.m_Dataset = instances;
        this.m_Not = false;
    }

    public Test(int n, double d, Instances instances, boolean bl) {
        this.m_AttIndex = n;
        this.m_Split = d;
        this.m_Dataset = instances;
        this.m_Not = bl;
    }

    public Test getNot() {
        return new Test(this.m_AttIndex, this.m_Split, this.m_Dataset, !this.m_Not);
    }

    public boolean passesTest(Instance instance) throws Exception {
        if (instance.isMissing(this.m_AttIndex)) {
            return false;
        }
        boolean bl = instance.attribute(this.m_AttIndex).isNominal();
        double d = instance.value(this.m_AttIndex);
        return !(!this.m_Not ? (bl ? (int)d != (int)this.m_Split : d >= this.m_Split) : (bl ? (int)d == (int)this.m_Split : d < this.m_Split));
    }

    public String toString() {
        return this.m_Dataset.attribute(this.m_AttIndex).name() + " " + this.testComparisonString();
    }

    public String toPrologString() {
        Attribute attribute = this.m_Dataset.attribute(this.m_AttIndex);
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.m_Dataset.attribute(this.m_AttIndex).name();
        if (attribute.isNumeric()) {
            stringBuffer = stringBuffer.append(string + " ");
            stringBuffer = this.m_Not ? stringBuffer.append(">= " + Utils.doubleToString(this.m_Split, 3)) : stringBuffer.append("< " + Utils.doubleToString(this.m_Split, 3));
        } else {
            String string2 = attribute.value((int)this.m_Split);
            stringBuffer = string2 == "false" ? stringBuffer.append("not(" + string + ")") : stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String testComparisonString() {
        Attribute attribute = this.m_Dataset.attribute(this.m_AttIndex);
        if (attribute.isNumeric()) {
            return (this.m_Not ? ">= " : "< ") + Utils.doubleToString(this.m_Split, 3);
        }
        if (attribute.numValues() != 2) {
            return (this.m_Not ? "!= " : "= ") + attribute.value((int)this.m_Split);
        }
        return "= " + (this.m_Not ? attribute.value((int)this.m_Split == 0 ? 1 : 0) : attribute.value((int)this.m_Split));
    }

    private String testPrologComparisonString() {
        Attribute attribute = this.m_Dataset.attribute(this.m_AttIndex);
        if (attribute.isNumeric()) {
            return (this.m_Not ? ">= " : "< ") + Utils.doubleToString(this.m_Split, 3);
        }
        if (attribute.numValues() != 2) {
            return (this.m_Not ? "!= " : "= ") + attribute.value((int)this.m_Split);
        }
        return "= " + (this.m_Not ? attribute.value((int)this.m_Split == 0 ? 1 : 0) : attribute.value((int)this.m_Split));
    }

    public boolean equalTo(Test test) {
        return this.m_AttIndex == test.m_AttIndex && this.m_Split == test.m_Split && this.m_Not == test.m_Not;
    }
}

