/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.datagenerators.DataGenerator;
import weka.datagenerators.classifiers.classification.RDG1;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyPanel;

public class DataGeneratorPanel
extends JPanel {
    protected GenericObjectEditor m_GeneratorEditor = new GenericObjectEditor();
    protected Instances m_Instances = null;
    protected StringWriter m_Output = new StringWriter();

    public DataGeneratorPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)new PropertyPanel(this.m_GeneratorEditor), "Center");
        this.m_GeneratorEditor.setClassType(DataGenerator.class);
        this.m_GeneratorEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DataGeneratorPanel.this.repaint();
            }
        });
        this.setGenerator(null);
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public String getOutput() {
        return this.m_Output.toString();
    }

    public void setGenerator(DataGenerator dataGenerator) {
        if (dataGenerator != null) {
            this.m_GeneratorEditor.setValue(dataGenerator);
        } else {
            this.m_GeneratorEditor.setValue(new RDG1());
        }
    }

    public DataGenerator getGenerator() {
        return (DataGenerator)this.m_GeneratorEditor.getValue();
    }

    public boolean execute() {
        boolean bl = true;
        DataGenerator dataGenerator = (DataGenerator)this.m_GeneratorEditor.getValue();
        String string = dataGenerator.getRelationName();
        try {
            this.m_Output = new StringWriter();
            dataGenerator.setOutput(new PrintWriter(this.m_Output));
            DataGenerator.makeData(dataGenerator, dataGenerator.getOptions());
            this.m_Instances = new Instances(new StringReader(this.getOutput()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error generating data:\n" + exception.getMessage(), "Error", 0);
            this.m_Instances = null;
            this.m_Output = new StringWriter();
            bl = false;
        }
        dataGenerator.setRelationName(string);
        return bl;
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

