/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.io.Serializable;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SerializedObject;
import weka.core.Utils;

public abstract class Clusterer
implements Cloneable,
Serializable,
CapabilitiesHandler {
    public abstract void buildClusterer(Instances var1) throws Exception;

    public int clusterInstance(Instance instance) throws Exception {
        double[] dArray = this.distributionForInstance(instance);
        if (dArray == null) {
            throw new Exception("Null distribution predicted");
        }
        if (Utils.sum(dArray) <= 0.0) {
            throw new Exception("Unable to cluster instance");
        }
        return Utils.maxIndex(dArray);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = new double[this.numberOfClusters()];
        dArray[this.clusterInstance((Instance)instance)] = 1.0;
        return dArray;
    }

    public abstract int numberOfClusters() throws Exception;

    public static Clusterer forName(String string, String[] stringArray) throws Exception {
        return (Clusterer)Utils.forName(Clusterer.class, string, stringArray);
    }

    public static Clusterer[] makeCopies(Clusterer clusterer, int n) throws Exception {
        if (clusterer == null) {
            throw new Exception("No model clusterer set");
        }
        Clusterer[] clustererArray = new Clusterer[n];
        SerializedObject serializedObject = new SerializedObject(clusterer);
        for (int i = 0; i < clustererArray.length; ++i) {
            clustererArray[i] = (Clusterer)serializedObject.getObject();
        }
        return clustererArray;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = new Capabilities(this);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }
}

