/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.EventSetDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Random;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.ChartEvent;
import weka.gui.beans.ChartListener;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.visualize.PrintableComponent;
import weka.gui.visualize.VisualizeUtils;

public class StripChart
extends JPanel
implements ChartListener,
InstanceListener,
Visible,
BeanCommon,
UserRequestAcceptor {
    private static final long serialVersionUID = 1483649041577695019L;
    protected Color[] m_colorList = new Color[]{Color.green, Color.red, Color.blue, Color.cyan, Color.pink, new Color(255, 0, 255), Color.orange, new Color(255, 0, 0), new Color(0, 255, 0), Color.white};
    protected Color m_BackgroundColor;
    protected Color m_LegendPanelBorderColor;
    private transient JFrame m_outputFrame = null;
    private transient StripPlotter m_plotPanel = null;
    private transient Image m_osi = null;
    private int m_iheight;
    private int m_iwidth;
    private double m_max = 1.0;
    private double m_min = 0.0;
    private boolean m_yScaleUpdate = false;
    private double m_oldMax;
    private double m_oldMin;
    private Font m_labelFont = new Font("Monospaced", 0, 10);
    private FontMetrics m_labelMetrics;
    private Vector m_legendText = new Vector();
    private ScalePanel m_scalePanel = new ScalePanel();
    private LegendPanel m_legendPanel = new LegendPanel();
    private LinkedList m_dataList = new LinkedList();
    private double[] m_previousY = new double[1];
    private transient Thread m_updateHandler;
    protected BeanVisual m_visual = new BeanVisual("StripChart", "weka/gui/beans/icons/StripChart.gif", "weka/gui/beans/icons/StripChart_animated.gif");
    private Object m_listenee = null;
    private transient Logger m_log = null;
    private int m_xValFreq = 500;
    private int m_xCount = 0;
    private int m_refreshWidth = 1;
    private int m_refreshFrequency = 5;
    protected PrintableComponent m_Printer = null;
    ChartEvent m_ce = new ChartEvent(this);
    double[] m_dataPoint = null;

    public StripChart() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.initPlot();
    }

    public void setCustomName(String string) {
        this.m_visual.setText(string);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String globalInfo() {
        return "Visualize incremental classifier performance as a scrolling plot.";
    }

    public String xLabelFreqTipText() {
        return "Show x axis labels this often";
    }

    public void setXLabelFreq(int n) {
        this.m_xValFreq = n;
        if (this.getGraphics() != null) {
            this.setRefreshWidth();
        }
    }

    public int getXLabelFreq() {
        return this.m_xValFreq;
    }

    public String refreshFreqTipText() {
        return "Plot every x'th data point";
    }

    public void setRefreshFreq(int n) {
        this.m_refreshFrequency = n;
        if (this.getGraphics() != null) {
            this.setRefreshWidth();
        }
    }

    public int getRefreshFreq() {
        return this.m_refreshFrequency;
    }

    private void setRefreshWidth() {
        this.m_refreshWidth = 1;
        if (this.m_labelMetrics == null) {
            this.getGraphics().setFont(this.m_labelFont);
            this.m_labelMetrics = this.getGraphics().getFontMetrics(this.m_labelFont);
        }
        int n = this.m_labelMetrics.stringWidth("99000");
        int n2 = this.getXLabelFreq() / this.getRefreshFreq();
        if (n2 < 1) {
            n2 = 1;
        }
        if (n2 * this.m_refreshWidth < n + 5) {
            this.m_refreshWidth *= (n + 5) / n2 + 1;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            objectInputStream.defaultReadObject();
            this.initPlot();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setProperties() {
        String string = this.getClass().getName() + ".backgroundColour";
        String string2 = KnowledgeFlowApp.BEAN_PROPERTIES.getProperty(string);
        this.m_BackgroundColor = Color.BLACK;
        if (string2 != null) {
            this.m_BackgroundColor = VisualizeUtils.processColour(string2, this.m_BackgroundColor);
        }
        string = this.m_legendPanel.getClass().getName() + ".borderColour";
        string2 = KnowledgeFlowApp.BEAN_PROPERTIES.getProperty(string);
        this.m_LegendPanelBorderColor = Color.BLUE;
        if (string2 != null) {
            this.m_LegendPanelBorderColor = VisualizeUtils.processColour(string2, this.m_LegendPanelBorderColor);
        }
    }

    private void initPlot() {
        this.setProperties();
        this.m_plotPanel = new StripPlotter();
        this.m_plotPanel.setBackground(this.m_BackgroundColor);
        this.m_scalePanel.setBackground(this.m_BackgroundColor);
        this.m_legendPanel.setBackground(this.m_BackgroundColor);
        this.m_xCount = 0;
    }

    private void startHandler() {
        if (this.m_updateHandler == null) {
            this.m_updateHandler = new Thread(){
                private double[] dataPoint;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (true) {
                        if (StripChart.this.m_outputFrame == null) {
                            continue;
                        }
                        LinkedList linkedList = StripChart.this.m_dataList;
                        synchronized (linkedList) {
                            while (StripChart.this.m_dataList.isEmpty()) {
                                try {
                                    StripChart.this.m_dataList.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    return;
                                }
                            }
                            this.dataPoint = (double[])StripChart.this.m_dataList.remove(0);
                        }
                        if (StripChart.this.m_outputFrame == null) continue;
                        StripChart.this.updateChart(this.dataPoint);
                    }
                }
            };
            this.m_updateHandler.start();
        }
    }

    public void showChart() {
        if (this.m_outputFrame == null) {
            this.m_outputFrame = new JFrame("Strip Chart");
            this.m_outputFrame.getContentPane().setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new BorderLayout());
            new PrintableComponent(jPanel);
            this.m_outputFrame.getContentPane().add((Component)jPanel, "Center");
            jPanel.add((Component)this.m_legendPanel, "West");
            jPanel.add((Component)this.m_plotPanel, "Center");
            jPanel.add((Component)this.m_scalePanel, "East");
            this.m_legendPanel.setMinimumSize(new Dimension(100, this.getHeight()));
            this.m_legendPanel.setPreferredSize(new Dimension(100, this.getHeight()));
            this.m_scalePanel.setMinimumSize(new Dimension(30, this.getHeight()));
            this.m_scalePanel.setPreferredSize(new Dimension(30, this.getHeight()));
            Font font = new Font("Monospaced", 0, 12);
            this.m_legendPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(Color.gray, Color.darkGray), "Legend", 2, 0, font, this.m_LegendPanelBorderColor));
            this.m_outputFrame.addWindowListener(new WindowAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void windowClosing(WindowEvent windowEvent) {
                    if (StripChart.this.m_updateHandler != null) {
                        System.err.println("Interrupting");
                        StripChart.this.m_updateHandler.interrupt();
                        StripChart.this.m_updateHandler = null;
                    }
                    LinkedList linkedList = StripChart.this.m_dataList;
                    synchronized (linkedList) {
                        StripChart.this.m_dataList = new LinkedList();
                    }
                    StripChart.this.m_outputFrame.dispose();
                    StripChart.this.m_outputFrame = null;
                }
            });
            this.m_outputFrame.pack();
            this.m_outputFrame.setSize(600, 150);
            this.m_outputFrame.setResizable(false);
            this.m_outputFrame.setVisible(true);
            int n = this.m_plotPanel.getWidth();
            int n2 = this.m_plotPanel.getHeight();
            this.m_osi = this.m_plotPanel.createImage(n, n2);
            Graphics graphics = this.m_osi.getGraphics();
            graphics.setColor(this.m_BackgroundColor);
            graphics.fillRect(0, 0, n, n2);
            this.m_previousY[0] = -1.0;
            this.setRefreshWidth();
            if (this.m_updateHandler == null) {
                System.err.println("Starting handler");
                this.startHandler();
            }
        } else {
            this.m_outputFrame.toFront();
        }
    }

    private int convertToPanelY(double d) {
        int n = this.m_plotPanel.getHeight();
        double d2 = (d - this.m_min) / (this.m_max - this.m_min);
        d2 *= (double)n;
        d2 = (double)n - d2;
        return (int)d2;
    }

    protected void updateChart(double[] dArray) {
        int n;
        int n2;
        int n3;
        Object object;
        int n4;
        if (this.m_previousY[0] == -1.0) {
            n4 = this.m_plotPanel.getWidth();
            int n5 = this.m_plotPanel.getHeight();
            this.m_osi = this.m_plotPanel.createImage(n4, n5);
            object = this.m_osi.getGraphics();
            ((Graphics)object).setColor(this.m_BackgroundColor);
            ((Graphics)object).fillRect(0, 0, n4, n5);
            this.m_previousY[0] = this.convertToPanelY(0.0);
            this.m_iheight = n5;
            this.m_iwidth = n4;
        }
        if (dArray.length - 1 != this.m_previousY.length) {
            this.m_previousY = new double[dArray.length - 1];
            for (n4 = 0; n4 < dArray.length - 1; ++n4) {
                this.m_previousY[n4] = this.convertToPanelY(0.0);
            }
        }
        Graphics graphics = this.m_osi.getGraphics();
        Graphics graphics2 = this.m_plotPanel.getGraphics();
        graphics.copyArea(this.m_refreshWidth, 0, this.m_iwidth - this.m_refreshWidth, this.m_iheight, -this.m_refreshWidth, 0);
        graphics.setColor(this.m_BackgroundColor);
        graphics.fillRect(this.m_iwidth - this.m_refreshWidth, 0, this.m_iwidth, this.m_iheight);
        if (this.m_yScaleUpdate) {
            object = StripChart.numToString(this.m_oldMax);
            String string = StripChart.numToString(this.m_oldMin);
            String string2 = StripChart.numToString((this.m_oldMax - this.m_oldMin) / 2.0);
            if (this.m_labelMetrics == null) {
                this.m_labelMetrics = graphics2.getFontMetrics(this.m_labelFont);
            }
            graphics.setFont(this.m_labelFont);
            n3 = this.m_labelMetrics.stringWidth((String)object);
            n2 = this.m_labelMetrics.stringWidth(string);
            n = this.m_labelMetrics.stringWidth(string2);
            int n6 = this.m_labelMetrics.getAscent();
            graphics.setColor(this.m_colorList[this.m_colorList.length - 1]);
            graphics.drawString((String)object, this.m_iwidth - n3, n6 - 2);
            graphics.drawString(string2, this.m_iwidth - n, this.m_iheight / 2 + n6 / 2);
            graphics.drawString(string, this.m_iwidth - n2, this.m_iheight - 1);
            this.m_yScaleUpdate = false;
        }
        for (int i = 0; i < dArray.length - 1; ++i) {
            graphics.setColor(this.m_colorList[i % this.m_colorList.length]);
            double d = this.convertToPanelY(dArray[i]);
            graphics.drawLine(this.m_iwidth - this.m_refreshWidth, (int)this.m_previousY[i], this.m_iwidth - 1, (int)d);
            this.m_previousY[i] = d;
            if (dArray[dArray.length - 1] % (double)this.m_xValFreq != 0.0) continue;
            String string = StripChart.numToString(dArray[i]);
            if (this.m_labelMetrics == null) {
                this.m_labelMetrics = graphics2.getFontMetrics(this.m_labelFont);
            }
            if (d - (double)(n2 = this.m_labelMetrics.getAscent()) < 0.0) {
                d += (double)n2;
            }
            n = this.m_labelMetrics.stringWidth(string);
            graphics.setFont(this.m_labelFont);
            graphics.drawString(string, this.m_iwidth - n, (int)d);
        }
        if (dArray[dArray.length - 1] % (double)this.m_xValFreq == 0.0) {
            String string = "" + (int)dArray[dArray.length - 1];
            graphics.setColor(this.m_colorList[this.m_colorList.length - 1]);
            n3 = this.m_labelMetrics.stringWidth(string);
            graphics.setFont(this.m_labelFont);
            graphics.drawString(string, this.m_iwidth - n3, this.m_iheight - 1);
        }
        graphics2.drawImage(this.m_osi, 0, 0, this.m_plotPanel);
    }

    private static String numToString(double d) {
        int n = 1;
        int n2 = (int)Math.abs(d);
        double d2 = Math.abs(d) - (double)n2;
        int n3 = n2 > 0 ? (int)(Math.log(n2) / Math.log(10.0)) : 1;
        int n4 = n = d2 > 0.0 ? (int)Math.abs(Math.log(Math.abs(d)) / Math.log(10.0)) + 2 : 1;
        if (n > 5) {
            n = 1;
        }
        String string = Utils.doubleToString(d, n3 + 1 + n, n);
        return string;
    }

    public void acceptInstance(InstanceEvent instanceEvent) {
        if (instanceEvent.getStatus() == 0) {
            Instances instances = instanceEvent.getStructure();
            this.m_legendText = new Vector();
            this.m_max = 1.0;
            this.m_min = 0.0;
            int n = 0;
            for (n = 0; n < instances.numAttributes(); ++n) {
                if (n > 10) {
                    --n;
                    break;
                }
                this.m_legendText.addElement(instances.attribute(n).name());
                this.m_legendPanel.repaint();
                this.m_scalePanel.repaint();
            }
            this.m_dataPoint = new double[n];
            this.m_xCount = 0;
            return;
        }
        Instance instance = instanceEvent.getInstance();
        for (int i = 0; i < this.m_dataPoint.length; ++i) {
            if (instance.isMissing(i)) continue;
            this.m_dataPoint[i] = instance.value(i);
        }
        this.acceptDataPoint(this.m_dataPoint);
        ++this.m_xCount;
    }

    public void acceptDataPoint(ChartEvent chartEvent) {
        if (chartEvent.getReset()) {
            this.m_xCount = 0;
            this.m_max = 1.0;
            this.m_min = 0.0;
        }
        if (this.m_outputFrame != null) {
            boolean bl = false;
            if (chartEvent.getLegendText() != null & chartEvent.getLegendText() != this.m_legendText) {
                this.m_legendText = chartEvent.getLegendText();
                bl = true;
            }
            if (chartEvent.getMin() != this.m_min || chartEvent.getMax() != this.m_max) {
                this.m_oldMax = this.m_max;
                this.m_oldMin = this.m_min;
                this.m_max = chartEvent.getMax();
                this.m_min = chartEvent.getMin();
                bl = true;
                this.m_yScaleUpdate = true;
            }
            if (bl) {
                this.m_legendPanel.repaint();
                this.m_scalePanel.repaint();
            }
            this.acceptDataPoint(chartEvent.getDataPoint());
        }
        ++this.m_xCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptDataPoint(double[] dArray) {
        if (this.m_outputFrame != null && this.m_xCount % this.m_refreshFrequency == 0) {
            double[] dArray2 = new double[dArray.length + 1];
            dArray2[dArray2.length - 1] = this.m_xCount;
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            for (int i = 0; i < dArray.length; ++i) {
                if (dArray[i] < this.m_min) {
                    this.m_oldMin = this.m_min;
                    this.m_min = dArray[i];
                    this.m_yScaleUpdate = true;
                }
                if (!(dArray[i] > this.m_max)) continue;
                this.m_oldMax = this.m_max;
                this.m_max = dArray[i];
                this.m_yScaleUpdate = true;
            }
            if (this.m_yScaleUpdate) {
                this.m_scalePanel.repaint();
                this.m_yScaleUpdate = false;
            }
            LinkedList linkedList = this.m_dataList;
            synchronized (linkedList) {
                this.m_dataList.add(this.m_dataList.size(), dArray2);
                this.m_dataList.notifyAll();
            }
        }
    }

    public void setVisual(BeanVisual beanVisual) {
        this.m_visual = beanVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/StripChart.gif", "weka/gui/beans/icons/StripChart_animated.gif");
    }

    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
    }

    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    public boolean connectionAllowed(String string) {
        return this.m_listenee == null;
    }

    public boolean connectionAllowed(EventSetDescriptor eventSetDescriptor) {
        return this.connectionAllowed(eventSetDescriptor.getName());
    }

    public void connectionNotification(String string, Object object) {
        if (this.connectionAllowed(string)) {
            this.m_listenee = object;
        }
    }

    public void disconnectionNotification(String string, Object object) {
        this.m_listenee = null;
    }

    public Enumeration enumerateRequests() {
        Vector<String> vector = new Vector<String>(0);
        vector.addElement("Show chart");
        return vector.elements();
    }

    public void performRequest(String string) {
        if (string.compareTo("Show chart") != 0) {
            throw new IllegalArgumentException(string + " not supported (StripChart)");
        }
        this.showChart();
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame("Weka Knowledge Flow : StipChart");
            jFrame.getContentPane().setLayout(new BorderLayout());
            StripChart stripChart = new StripChart();
            jFrame.getContentPane().add((Component)stripChart, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
            stripChart.showChart();
            Random random = new Random(1L);
            for (int i = 0; i < 1020; ++i) {
                double[] dArray = new double[]{random.nextDouble()};
                stripChart.acceptDataPoint(dArray);
            }
            System.err.println("Done sending data");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    private class LegendPanel
    extends JPanel {
        private static final long serialVersionUID = 7713986576833797583L;

        private LegendPanel() {
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (StripChart.this.m_labelMetrics == null) {
                StripChart.this.m_labelMetrics = graphics.getFontMetrics(StripChart.this.m_labelFont);
            }
            int n = StripChart.this.m_labelMetrics.getAscent();
            int n2 = 10;
            int n3 = n + 15;
            graphics.setFont(StripChart.this.m_labelFont);
            for (int i = 0; i < StripChart.this.m_legendText.size(); ++i) {
                String string = (String)StripChart.this.m_legendText.elementAt(i);
                graphics.setColor(StripChart.this.m_colorList[i % StripChart.this.m_colorList.length]);
                graphics.drawString(string, n2, n3);
                n3 += n;
            }
            StripChart.this.revalidate();
        }
    }

    private class ScalePanel
    extends JPanel {
        private static final long serialVersionUID = 6416998474984829434L;

        private ScalePanel() {
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (StripChart.this.m_labelMetrics == null) {
                StripChart.this.m_labelMetrics = graphics.getFontMetrics(StripChart.this.m_labelFont);
            }
            graphics.setFont(StripChart.this.m_labelFont);
            int n = StripChart.this.m_labelMetrics.getAscent();
            String string = "" + StripChart.this.m_max;
            graphics.setColor(StripChart.this.m_colorList[StripChart.this.m_colorList.length - 1]);
            graphics.drawString(string, 1, n - 2);
            string = "" + (StripChart.this.m_min + (StripChart.this.m_max - StripChart.this.m_min) / 2.0);
            graphics.drawString(string, 1, this.getHeight() / 2 + n / 2);
            string = "" + StripChart.this.m_min;
            graphics.drawString(string, 1, this.getHeight() - 1);
        }
    }

    private class StripPlotter
    extends JPanel {
        private static final long serialVersionUID = -7056271598761675879L;

        private StripPlotter() {
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (StripChart.this.m_osi != null) {
                graphics.drawImage(StripChart.this.m_osi, 0, 0, this);
            }
        }
    }
}

