/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import weka.clusterers.AbstractClusterer;
import weka.clusterers.DensityBasedClusterer;
import weka.core.Instance;
import weka.core.SerializedObject;
import weka.core.Utils;

public abstract class AbstractDensityBasedClusterer
extends AbstractClusterer
implements DensityBasedClusterer {
    private static final long serialVersionUID = -5950728041704213845L;

    public abstract double[] clusterPriors() throws Exception;

    public abstract double[] logDensityPerClusterForInstance(Instance var1) throws Exception;

    public double logDensityForInstance(Instance instance) throws Exception {
        double[] dArray = this.logJointDensitiesForInstance(instance);
        double d = dArray[Utils.maxIndex(dArray)];
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += Math.exp(dArray[i] - d);
        }
        return d + Math.log(d2);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        return Utils.logs2probs(this.logJointDensitiesForInstance(instance));
    }

    public double[] logJointDensitiesForInstance(Instance instance) throws Exception {
        double[] dArray = this.logDensityPerClusterForInstance(instance);
        double[] dArray2 = this.clusterPriors();
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray2[i] > 0.0)) {
                throw new IllegalArgumentException("Cluster empty!");
            }
            int n = i;
            dArray[n] = dArray[n] + Math.log(dArray2[i]);
        }
        return dArray;
    }

    public static DensityBasedClusterer[] makeCopies(DensityBasedClusterer densityBasedClusterer, int n) throws Exception {
        if (densityBasedClusterer == null) {
            throw new Exception("No model clusterer set");
        }
        DensityBasedClusterer[] densityBasedClustererArray = new DensityBasedClusterer[n];
        SerializedObject serializedObject = new SerializedObject(densityBasedClusterer);
        for (int i = 0; i < densityBasedClustererArray.length; ++i) {
            densityBasedClustererArray[i] = (DensityBasedClusterer)serializedObject.getObject();
        }
        return densityBasedClustererArray;
    }
}

