/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.balltrees;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.neighboursearch.balltrees.BallNode;
import weka.core.neighboursearch.balltrees.BallSplitter;

public class MedianOfWidestDimension
extends BallSplitter
implements OptionHandler,
TechnicalInformationHandler {
    private static final long serialVersionUID = 3054842574468790421L;
    protected boolean m_NormalizeDimWidths = true;

    public MedianOfWidestDimension() {
    }

    public MedianOfWidestDimension(int[] nArray, Instances instances, EuclideanDistance euclideanDistance) {
        super(nArray, instances, euclideanDistance);
    }

    public String globalInfo() {
        return "Class that splits a BallNode of a ball tree based on the median value of the widest dimension of the points in the ball. It essentially implements Omohundro's  KD construction algorithm.";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.TECHREPORT);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Stephen M. Omohundro");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1989");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Five Balltree Construction Algorithms");
        technicalInformation.setValue(TechnicalInformation.Field.MONTH, "December");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "TR-89-063");
        technicalInformation.setValue(TechnicalInformation.Field.INSTITUTION, "International Computer Science Institute");
        return technicalInformation;
    }

    public void splitNode(BallNode ballNode, int n) throws Exception {
        this.correctlyInitialized();
        double[][] dArray = this.m_DistanceFunction.initializeRanges(this.m_Instlist, ballNode.m_Start, ballNode.m_End);
        int n2 = this.widestDim(dArray, this.m_DistanceFunction.getRanges());
        int n3 = ballNode.m_Start + (ballNode.m_End - ballNode.m_Start) / 2;
        int n4 = this.select(n2, this.m_Instlist, ballNode.m_Start, ballNode.m_End, (ballNode.m_End - ballNode.m_Start) / 2 + 1);
        ballNode.m_SplitAttrib = n2;
        ballNode.m_SplitVal = this.m_Instances.instance(this.m_Instlist[n4]).value(n2);
        Instance instance = BallNode.calcCentroidPivot(ballNode.m_Start, n3, this.m_Instlist, this.m_Instances);
        ballNode.m_Left = new BallNode(ballNode.m_Start, n3, n + 1, instance, BallNode.calcRadius(ballNode.m_Start, n3, this.m_Instlist, this.m_Instances, instance, this.m_DistanceFunction));
        instance = BallNode.calcCentroidPivot(n3 + 1, ballNode.m_End, this.m_Instlist, this.m_Instances);
        ballNode.m_Right = new BallNode(n3 + 1, ballNode.m_End, n + 2, instance, BallNode.calcRadius(n3 + 1, ballNode.m_End, this.m_Instlist, this.m_Instances, instance, this.m_DistanceFunction));
    }

    protected int partition(int n, int[] nArray, int n2, int n3) {
        double d = this.m_Instances.instance(nArray[(n2 + n3) / 2]).value(n);
        while (n2 < n3) {
            while (this.m_Instances.instance(nArray[n2]).value(n) < d && n2 < n3) {
                ++n2;
            }
            while (this.m_Instances.instance(nArray[n3]).value(n) > d && n2 < n3) {
                --n3;
            }
            if (n2 >= n3) continue;
            int n4 = nArray[n2];
            nArray[n2] = nArray[n3];
            nArray[n3] = n4;
            ++n2;
            --n3;
        }
        if (n2 == n3 && this.m_Instances.instance(nArray[n3]).value(n) > d) {
            --n3;
        }
        return n3;
    }

    public int select(int n, int[] nArray, int n2, int n3, int n4) {
        if (n2 == n3) {
            return n2;
        }
        int n5 = this.partition(n, nArray, n2, n3);
        if (n5 - n2 + 1 >= n4) {
            return this.select(n, nArray, n2, n5, n4);
        }
        return this.select(n, nArray, n5 + 1, n3, n4 - (n5 - n2 + 1));
    }

    protected int widestDim(double[][] dArray, double[][] dArray2) {
        int n = this.m_Instances.classIndex();
        double d = 0.0;
        int n2 = -1;
        if (this.m_NormalizeDimWidths) {
            for (int i = 0; i < dArray.length; ++i) {
                double d2 = dArray[i][2] / dArray2[i][2];
                if (!(d2 > d) || i == n) continue;
                d = d2;
                n2 = i;
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                if (!(dArray[i][2] > d) || i == n) continue;
                d = dArray[i][2];
                n2 = i;
            }
        }
        return n2;
    }

    public String normalizeDimWidthsTipText() {
        return "Whether to normalize the widths(ranges) of the dimensions (attributes) before selecting the widest one.";
    }

    public void setNormalizeDimWidths(boolean bl) {
        this.m_NormalizeDimWidths = bl;
    }

    public boolean getNormalizeDimWidths() {
        return this.m_NormalizeDimWidths;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tNormalize dimensions' widths.", "N", 0, "-N"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setNormalizeDimWidths(Utils.getFlag('N', stringArray));
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.getNormalizeDimWidths()) {
            vector.add("-N");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

