/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Queue;
import weka.core.RelationalLocator;
import weka.core.RevisionHandler;
import weka.core.SerializedObject;
import weka.core.StringLocator;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.core.Version;
import weka.core.converters.ConverterUtils;
import weka.filters.Sourcable;

public abstract class Filter
implements Serializable,
CapabilitiesHandler,
RevisionHandler {
    private static final long serialVersionUID = -8835063755891851218L;
    private Instances m_OutputFormat = null;
    private Queue m_OutputQueue = null;
    protected StringLocator m_OutputStringAtts = null;
    protected StringLocator m_InputStringAtts = null;
    protected RelationalLocator m_OutputRelAtts = null;
    protected RelationalLocator m_InputRelAtts = null;
    private Instances m_InputFormat = null;
    protected boolean m_NewBatch = true;
    protected boolean m_FirstBatchDone = false;

    public boolean isNewBatch() {
        return this.m_NewBatch;
    }

    public boolean isFirstBatchDone() {
        return this.m_FirstBatchDone;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = new Capabilities(this);
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public Capabilities getCapabilities(Instances instances) {
        Capabilities capabilities = this.getCapabilities();
        if (instances.classIndex() == -1) {
            Capabilities capabilities2 = capabilities.getClassCapabilities();
            Iterator iterator = capabilities2.capabilities();
            while (iterator.hasNext()) {
                Capabilities.Capability capability = (Capabilities.Capability)((Object)iterator.next());
                if (capability == Capabilities.Capability.NO_CLASS) continue;
                capabilities.disable(capability);
                capabilities.disableDependency(capability);
            }
        } else {
            capabilities.disable(Capabilities.Capability.NO_CLASS);
            capabilities.disableDependency(Capabilities.Capability.NO_CLASS);
        }
        return capabilities;
    }

    protected void setOutputFormat(Instances instances) {
        if (instances != null) {
            this.m_OutputFormat = instances.stringFreeStructure();
            this.initOutputLocators(this.m_OutputFormat, null);
            String string = instances.relationName() + "-" + this.getClass().getName();
            if (this instanceof OptionHandler) {
                String[] stringArray = ((OptionHandler)((Object)this)).getOptions();
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + stringArray[i].trim();
                }
            }
            this.m_OutputFormat.setRelationName(string);
        } else {
            this.m_OutputFormat = null;
        }
        this.m_OutputQueue = new Queue();
    }

    protected Instances getInputFormat() {
        return this.m_InputFormat;
    }

    protected Instances inputFormatPeek() {
        return this.m_InputFormat;
    }

    protected Instances outputFormatPeek() {
        return this.m_OutputFormat;
    }

    protected void push(Instance instance) {
        if (instance != null) {
            if (instance.dataset() != null) {
                this.copyValues(instance, false);
            }
            instance.setDataset(this.m_OutputFormat);
            this.m_OutputQueue.push(instance);
        }
    }

    protected void resetQueue() {
        this.m_OutputQueue = new Queue();
    }

    protected void bufferInput(Instance instance) {
        if (instance != null) {
            this.copyValues(instance, true);
            this.m_InputFormat.add(instance);
        }
    }

    protected void initInputLocators(Instances instances, int[] nArray) {
        if (nArray == null) {
            this.m_InputStringAtts = new StringLocator(instances);
            this.m_InputRelAtts = new RelationalLocator(instances);
        } else {
            this.m_InputStringAtts = new StringLocator(instances, nArray);
            this.m_InputRelAtts = new RelationalLocator(instances, nArray);
        }
    }

    protected void initOutputLocators(Instances instances, int[] nArray) {
        if (nArray == null) {
            this.m_OutputStringAtts = new StringLocator(instances);
            this.m_OutputRelAtts = new RelationalLocator(instances);
        } else {
            this.m_OutputStringAtts = new StringLocator(instances, nArray);
            this.m_OutputRelAtts = new RelationalLocator(instances, nArray);
        }
    }

    protected void copyValues(Instance instance, boolean bl) {
        RelationalLocator.copyRelationalValues(instance, bl ? this.m_InputFormat : this.m_OutputFormat, bl ? this.m_InputRelAtts : this.m_OutputRelAtts);
        StringLocator.copyStringValues(instance, bl ? this.m_InputFormat : this.m_OutputFormat, bl ? this.m_InputStringAtts : this.m_OutputStringAtts);
    }

    protected void copyValues(Instance instance, boolean bl, Instances instances, Instances instances2) {
        RelationalLocator.copyRelationalValues(instance, bl, instances, this.m_InputRelAtts, instances2, this.m_OutputRelAtts);
        StringLocator.copyStringValues(instance, bl, instances, this.m_InputStringAtts, this.getOutputFormat(), this.m_OutputStringAtts);
    }

    protected void flushInput() {
        if (this.m_InputStringAtts.getAttributeIndices().length > 0 || this.m_InputRelAtts.getAttributeIndices().length > 0) {
            this.m_InputFormat = this.m_InputFormat.stringFreeStructure();
        } else {
            this.m_InputFormat.delete();
        }
    }

    protected void testInputFormat(Instances instances) throws Exception {
        this.getCapabilities(instances).testWithFail(instances);
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        this.testInputFormat(instances);
        this.m_InputFormat = instances.stringFreeStructure();
        this.m_OutputFormat = null;
        this.m_OutputQueue = new Queue();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = false;
        this.initInputLocators(this.m_InputFormat, null);
        return false;
    }

    public Instances getOutputFormat() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException("No output format defined.");
        }
        return new Instances(this.m_OutputFormat, 0);
    }

    public boolean input(Instance instance) throws Exception {
        if (this.m_InputFormat == null) {
            throw new NullPointerException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.m_OutputQueue = new Queue();
            this.m_NewBatch = false;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() throws Exception {
        if (this.m_InputFormat == null) {
            throw new NullPointerException("No input instance format defined");
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    public Instance output() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException("No output instance format defined");
        }
        if (this.m_OutputQueue.empty()) {
            return null;
        }
        Instance instance = (Instance)this.m_OutputQueue.pop();
        if (this.m_OutputQueue.empty() && this.m_NewBatch && (this.m_OutputStringAtts.getAttributeIndices().length > 0 || this.m_OutputRelAtts.getAttributeIndices().length > 0)) {
            this.m_OutputFormat = this.m_OutputFormat.stringFreeStructure();
        }
        return instance;
    }

    public Instance outputPeek() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException("No output instance format defined");
        }
        if (this.m_OutputQueue.empty()) {
            return null;
        }
        Instance instance = (Instance)this.m_OutputQueue.peek();
        return instance;
    }

    public int numPendingOutput() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException("No output instance format defined");
        }
        return this.m_OutputQueue.size();
    }

    public boolean isOutputFormatDefined() {
        return this.m_OutputFormat != null;
    }

    public static Filter makeCopy(Filter filter) throws Exception {
        return (Filter)new SerializedObject(filter).getObject();
    }

    public static Filter[] makeCopies(Filter filter, int n) throws Exception {
        if (filter == null) {
            throw new Exception("No model filter set");
        }
        Filter[] filterArray = new Filter[n];
        SerializedObject serializedObject = new SerializedObject(filter);
        for (int i = 0; i < filterArray.length; ++i) {
            filterArray[i] = (Filter)serializedObject.getObject();
        }
        return filterArray;
    }

    public static Instances useFilter(Instances instances, Filter filter) throws Exception {
        Instance instance;
        for (int i = 0; i < instances.numInstances(); ++i) {
            filter.input(instances.instance(i));
        }
        filter.batchFinished();
        Instances instances2 = filter.getOutputFormat();
        while ((instance = filter.output()) != null) {
            instances2.add(instance);
        }
        return instances2;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public static String wekaStaticWrapper(Sourcable sourcable, String string, Instances instances, Instances instances2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("// Generated with Weka " + Version.VERSION + "\n");
        stringBuffer.append("//\n");
        stringBuffer.append("// This code is public domain and comes with no warranty.\n");
        stringBuffer.append("//\n");
        stringBuffer.append("// Timestamp: " + new Date() + "\n");
        stringBuffer.append("// Relation: " + instances.relationName() + "\n");
        stringBuffer.append("\n");
        stringBuffer.append("package weka.filters;\n");
        stringBuffer.append("\n");
        stringBuffer.append("import weka.core.Attribute;\n");
        stringBuffer.append("import weka.core.Capabilities;\n");
        stringBuffer.append("import weka.core.Capabilities.Capability;\n");
        stringBuffer.append("import weka.core.FastVector;\n");
        stringBuffer.append("import weka.core.Instance;\n");
        stringBuffer.append("import weka.core.Instances;\n");
        stringBuffer.append("import weka.filters.Filter;\n");
        stringBuffer.append("\n");
        stringBuffer.append("public class WekaWrapper\n");
        stringBuffer.append("  extends Filter {\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /**\n");
        stringBuffer.append("   * Returns only the toString() method.\n");
        stringBuffer.append("   *\n");
        stringBuffer.append("   * @return a string describing the filter\n");
        stringBuffer.append("   */\n");
        stringBuffer.append("  public String globalInfo() {\n");
        stringBuffer.append("    return toString();\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /**\n");
        stringBuffer.append("   * Returns the capabilities of this filter.\n");
        stringBuffer.append("   *\n");
        stringBuffer.append("   * @return the capabilities\n");
        stringBuffer.append("   */\n");
        stringBuffer.append("  public Capabilities getCapabilities() {\n");
        stringBuffer.append(((Filter)((Object)sourcable)).getCapabilities().toSource("result", 4));
        stringBuffer.append("    return result;\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /**\n");
        stringBuffer.append("   * turns array of Objects into an Instance object\n");
        stringBuffer.append("   *\n");
        stringBuffer.append("   * @param obj\tthe Object array to turn into an Instance\n");
        stringBuffer.append("   * @param format\tthe data format to use\n");
        stringBuffer.append("   * @return\t\tthe generated Instance object\n");
        stringBuffer.append("   */\n");
        stringBuffer.append("  protected Instance objectsToInstance(Object[] obj, Instances format) {\n");
        stringBuffer.append("    Instance\t\tresult;\n");
        stringBuffer.append("    double[]\t\tvalues;\n");
        stringBuffer.append("    int\t\ti;\n");
        stringBuffer.append("\n");
        stringBuffer.append("    values = new double[obj.length];\n");
        stringBuffer.append("\n");
        stringBuffer.append("    for (i = 0 ; i < obj.length; i++) {\n");
        stringBuffer.append("      if (obj[i] == null)\n");
        stringBuffer.append("        values[i] = Instance.missingValue();\n");
        stringBuffer.append("      else if (format.attribute(i).isNumeric())\n");
        stringBuffer.append("        values[i] = (Double) obj[i];\n");
        stringBuffer.append("      else if (format.attribute(i).isNominal())\n");
        stringBuffer.append("        values[i] = format.attribute(i).indexOfValue((String) obj[i]);\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("    // create new instance\n");
        stringBuffer.append("    result = new Instance(1.0, values);\n");
        stringBuffer.append("    result.setDataset(format);\n");
        stringBuffer.append("\n");
        stringBuffer.append("    return result;\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /**\n");
        stringBuffer.append("   * turns the Instance object into an array of Objects\n");
        stringBuffer.append("   *\n");
        stringBuffer.append("   * @param inst\tthe instance to turn into an array\n");
        stringBuffer.append("   * @return\t\tthe Object array representing the instance\n");
        stringBuffer.append("   */\n");
        stringBuffer.append("  protected Object[] instanceToObjects(Instance inst) {\n");
        stringBuffer.append("    Object[]\tresult;\n");
        stringBuffer.append("    int\t\ti;\n");
        stringBuffer.append("\n");
        stringBuffer.append("    result = new Object[inst.numAttributes()];\n");
        stringBuffer.append("\n");
        stringBuffer.append("    for (i = 0 ; i < inst.numAttributes(); i++) {\n");
        stringBuffer.append("      if (inst.isMissing(i))\n");
        stringBuffer.append("  \tresult[i] = null;\n");
        stringBuffer.append("      else if (inst.attribute(i).isNumeric())\n");
        stringBuffer.append("  \tresult[i] = inst.value(i);\n");
        stringBuffer.append("      else\n");
        stringBuffer.append("  \tresult[i] = inst.stringValue(i);\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("    return result;\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /**\n");
        stringBuffer.append("   * turns the Instances object into an array of Objects\n");
        stringBuffer.append("   *\n");
        stringBuffer.append("   * @param data\tthe instances to turn into an array\n");
        stringBuffer.append("   * @return\t\tthe Object array representing the instances\n");
        stringBuffer.append("   */\n");
        stringBuffer.append("  protected Object[][] instancesToObjects(Instances data) {\n");
        stringBuffer.append("    Object[][]\tresult;\n");
        stringBuffer.append("    int\t\ti;\n");
        stringBuffer.append("\n");
        stringBuffer.append("    result = new Object[data.numInstances()][];\n");
        stringBuffer.append("\n");
        stringBuffer.append("    for (i = 0; i < data.numInstances(); i++)\n");
        stringBuffer.append("      result[i] = instanceToObjects(data.instance(i));\n");
        stringBuffer.append("\n");
        stringBuffer.append("    return result;\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /**\n");
        stringBuffer.append("   * Only tests the input data.\n");
        stringBuffer.append("   *\n");
        stringBuffer.append("   * @param instanceInfo the format of the data to convert\n");
        stringBuffer.append("   * @return always true, to indicate that the output format can \n");
        stringBuffer.append("   *         be collected immediately.\n");
        stringBuffer.append("   */\n");
        stringBuffer.append("  public boolean setInputFormat(Instances instanceInfo) throws Exception {\n");
        stringBuffer.append("    super.setInputFormat(instanceInfo);\n");
        stringBuffer.append("    \n");
        stringBuffer.append("    // generate output format\n");
        stringBuffer.append("    FastVector atts = new FastVector();\n");
        stringBuffer.append("    FastVector attValues;\n");
        for (int i = 0; i < instances2.numAttributes(); ++i) {
            stringBuffer.append("    // " + instances2.attribute(i).name() + "\n");
            if (instances2.attribute(i).isNumeric()) {
                stringBuffer.append("    atts.addElement(new Attribute(\"" + instances2.attribute(i).name() + "\"));\n");
                continue;
            }
            if (instances2.attribute(i).isNominal()) {
                stringBuffer.append("    attValues = new FastVector();\n");
                for (int j = 0; j < instances2.attribute(i).numValues(); ++j) {
                    stringBuffer.append("    attValues.addElement(\"" + instances2.attribute(i).value(j) + "\");\n");
                }
                stringBuffer.append("    atts.addElement(new Attribute(\"" + instances2.attribute(i).name() + "\", attValues));\n");
                continue;
            }
            throw new UnsupportedAttributeTypeException("Attribute type '" + instances2.attribute(i).type() + "' (position " + (i + 1) + ") is not supported!");
        }
        stringBuffer.append("    \n");
        stringBuffer.append("    Instances format = new Instances(\"" + instances2.relationName() + "\", atts, 0);\n");
        stringBuffer.append("    format.setClassIndex(" + instances2.classIndex() + ");\n");
        stringBuffer.append("    setOutputFormat(format);\n");
        stringBuffer.append("    \n");
        stringBuffer.append("    return true;\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /**\n");
        stringBuffer.append("   * Directly filters the instance.\n");
        stringBuffer.append("   *\n");
        stringBuffer.append("   * @param instance the instance to convert\n");
        stringBuffer.append("   * @return always true, to indicate that the output can \n");
        stringBuffer.append("   *         be collected immediately.\n");
        stringBuffer.append("   */\n");
        stringBuffer.append("  public boolean input(Instance instance) throws Exception {\n");
        stringBuffer.append("    Object[] filtered = " + string + ".filter(instanceToObjects(instance));\n");
        stringBuffer.append("    push(objectsToInstance(filtered, getOutputFormat()));\n");
        stringBuffer.append("    return true;\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /**\n");
        stringBuffer.append("   * Performs a batch filtering of the buffered data, if any available.\n");
        stringBuffer.append("   *\n");
        stringBuffer.append("   * @return true if instances were filtered otherwise false\n");
        stringBuffer.append("   */\n");
        stringBuffer.append("  public boolean batchFinished() throws Exception {\n");
        stringBuffer.append("    if (getInputFormat() == null)\n");
        stringBuffer.append("      throw new NullPointerException(\"No input instance format defined\");;\n");
        stringBuffer.append("\n");
        stringBuffer.append("    Instances inst = getInputFormat();\n");
        stringBuffer.append("    if (inst.numInstances() > 0) {\n");
        stringBuffer.append("      Object[][] filtered = " + string + ".filter(instancesToObjects(inst));\n");
        stringBuffer.append("      for (int i = 0; i < filtered.length; i++) {\n");
        stringBuffer.append("        push(objectsToInstance(filtered[i], getOutputFormat()));\n");
        stringBuffer.append("      }\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("    flushInput();\n");
        stringBuffer.append("    m_NewBatch = true;\n");
        stringBuffer.append("    m_FirstBatchDone = true;\n");
        stringBuffer.append("\n");
        stringBuffer.append("    return (inst.numInstances() > 0);\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /**\n");
        stringBuffer.append("   * Returns only the classnames and what filter it is based on.\n");
        stringBuffer.append("   *\n");
        stringBuffer.append("   * @return a short description\n");
        stringBuffer.append("   */\n");
        stringBuffer.append("  public String toString() {\n");
        stringBuffer.append("    return \"Auto-generated filter wrapper, based on " + sourcable.getClass().getName() + " (generated with Weka " + Version.VERSION + ").\\n" + "\" + this.getClass().getName() + \"/" + string + "\";\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /**\n");
        stringBuffer.append("   * Runs the filter from commandline.\n");
        stringBuffer.append("   *\n");
        stringBuffer.append("   * @param args the commandline arguments\n");
        stringBuffer.append("   */\n");
        stringBuffer.append("  public static void main(String args[]) {\n");
        stringBuffer.append("    runFilter(new WekaWrapper(), args);\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("}\n");
        stringBuffer.append("\n");
        stringBuffer.append(sourcable.toSource(string, instances));
        return stringBuffer.toString();
    }

    public static void filterFile(Filter filter, String[] stringArray) throws Exception {
        Object object;
        boolean bl = false;
        Instances instances = null;
        ConverterUtils.DataSource dataSource = null;
        PrintWriter printWriter = null;
        String string = "";
        try {
            boolean bl2 = Utils.getFlag('h', stringArray);
            if (Utils.getFlag('d', stringArray)) {
                bl = true;
            }
            String string2 = Utils.getOption('i', stringArray);
            object = Utils.getOption('o', stringArray);
            String string3 = Utils.getOption('c', stringArray);
            if (filter instanceof Sourcable) {
                string = Utils.getOption('z', stringArray);
            }
            if (filter instanceof OptionHandler) {
                ((OptionHandler)((Object)filter)).setOptions(stringArray);
            }
            Utils.checkForRemainingOptions(stringArray);
            if (bl2) {
                throw new Exception("Help requested.\n");
            }
            dataSource = string2.length() != 0 ? new ConverterUtils.DataSource(string2) : new ConverterUtils.DataSource(System.in);
            printWriter = ((String)object).length() != 0 ? new PrintWriter(new FileOutputStream((String)object)) : new PrintWriter(System.out);
            instances = dataSource.getStructure();
            if (string3.length() != 0) {
                if (string3.equals("first")) {
                    instances.setClassIndex(0);
                } else if (string3.equals("last")) {
                    instances.setClassIndex(instances.numAttributes() - 1);
                } else {
                    instances.setClassIndex(Integer.parseInt(string3) - 1);
                }
            }
        }
        catch (Exception exception) {
            Object object2;
            String string4 = "";
            if (filter instanceof OptionHandler) {
                string4 = string4 + "\nFilter options:\n\n";
                object2 = ((OptionHandler)((Object)filter)).listOptions();
                while (object2.hasMoreElements()) {
                    Option option = (Option)object2.nextElement();
                    string4 = string4 + option.synopsis() + '\n' + option.description() + "\n";
                }
            }
            object2 = "\nGeneral options:\n\n-h\n\tGet help on available options.\n\t(use -b -h for help on batch mode.)\n-i <file>\n\tThe name of the file containing input instances.\n\tIf not supplied then instances will be read from stdin.\n-o <file>\n\tThe name of the file output instances will be written to.\n\tIf not supplied then instances will be written to stdout.\n-c <class index>\n\tThe number of the attribute to use as the class.\n\t\"first\" and \"last\" are also valid entries.\n\tIf not supplied then no class is assigned.\n";
            if (filter instanceof Sourcable) {
                object2 = (String)object2 + "-z <class name>\n\tOutputs the source code representing the trained filter.\n";
            }
            throw new Exception('\n' + exception.getMessage() + string4 + (String)object2);
        }
        if (bl) {
            System.err.println("Setting input format");
        }
        boolean bl3 = false;
        if (filter.setInputFormat(instances)) {
            if (bl) {
                System.err.println("Getting output format");
            }
            printWriter.println(filter.getOutputFormat().toString());
            bl3 = true;
        }
        while (dataSource.hasMoreElements(instances)) {
            object = dataSource.nextElement(instances);
            if (bl) {
                System.err.println("Input instance to filter");
            }
            if (!filter.input((Instance)object)) continue;
            if (bl) {
                System.err.println("Filter said collect immediately");
            }
            if (!bl3) {
                throw new Error("Filter didn't return true from setInputFormat() earlier!");
            }
            if (bl) {
                System.err.println("Getting output instance");
            }
            printWriter.println(filter.output().toString());
        }
        if (bl) {
            System.err.println("Setting end of batch");
        }
        if (filter.batchFinished()) {
            if (bl) {
                System.err.println("Filter said collect output");
            }
            if (!bl3) {
                if (bl) {
                    System.err.println("Getting output format");
                }
                printWriter.println(filter.getOutputFormat().toString());
            }
            if (bl) {
                System.err.println("Getting output instance");
            }
            while (filter.numPendingOutput() > 0) {
                printWriter.println(filter.output().toString());
                if (!bl) continue;
                System.err.println("Getting output instance");
            }
        }
        if (bl) {
            System.err.println("Done");
        }
        if (printWriter != null) {
            printWriter.close();
        }
        if (string.length() != 0) {
            System.out.println(Filter.wekaStaticWrapper((Sourcable)((Object)filter), string, instances, filter.getOutputFormat()));
        }
    }

    public static void batchFilterFile(Filter filter, String[] stringArray) throws Exception {
        Object object;
        Instances instances = null;
        Instances instances2 = null;
        ConverterUtils.DataSource dataSource = null;
        ConverterUtils.DataSource dataSource2 = null;
        PrintWriter printWriter = null;
        PrintWriter printWriter2 = null;
        String string = "";
        try {
            boolean bl = Utils.getFlag('h', stringArray);
            String string2 = Utils.getOption('i', stringArray);
            if (string2.length() == 0) {
                throw new Exception("No first input file given.\n");
            }
            dataSource = new ConverterUtils.DataSource(string2);
            string2 = Utils.getOption('r', stringArray);
            if (string2.length() == 0) {
                throw new Exception("No second input file given.\n");
            }
            dataSource2 = new ConverterUtils.DataSource(string2);
            string2 = Utils.getOption('o', stringArray);
            printWriter = string2.length() != 0 ? new PrintWriter(new FileOutputStream(string2)) : new PrintWriter(System.out);
            string2 = Utils.getOption('s', stringArray);
            printWriter2 = string2.length() != 0 ? new PrintWriter(new FileOutputStream(string2)) : new PrintWriter(System.out);
            object = Utils.getOption('c', stringArray);
            if (filter instanceof Sourcable) {
                string = Utils.getOption('z', stringArray);
            }
            if (filter instanceof OptionHandler) {
                ((OptionHandler)((Object)filter)).setOptions(stringArray);
            }
            Utils.checkForRemainingOptions(stringArray);
            if (bl) {
                throw new Exception("Help requested.\n");
            }
            instances = dataSource.getStructure();
            instances2 = dataSource2.getStructure();
            if (!instances2.equalHeaders(instances)) {
                throw new Exception("Input file formats differ.\n");
            }
            if (((String)object).length() != 0) {
                if (((String)object).equals("first")) {
                    instances.setClassIndex(0);
                    instances2.setClassIndex(0);
                } else if (((String)object).equals("last")) {
                    instances.setClassIndex(instances.numAttributes() - 1);
                    instances2.setClassIndex(instances2.numAttributes() - 1);
                } else {
                    instances.setClassIndex(Integer.parseInt((String)object) - 1);
                    instances2.setClassIndex(Integer.parseInt((String)object) - 1);
                }
            }
        }
        catch (Exception exception) {
            Object object2;
            String string3 = "";
            if (filter instanceof OptionHandler) {
                string3 = string3 + "\nFilter options:\n\n";
                object2 = ((OptionHandler)((Object)filter)).listOptions();
                while (object2.hasMoreElements()) {
                    Option option = (Option)object2.nextElement();
                    string3 = string3 + option.synopsis() + '\n' + option.description() + "\n";
                }
            }
            object2 = "\nGeneral options:\n\n-h\n\tGet help on available options.\n-i <filename>\n\tThe file containing first input instances.\n-o <filename>\n\tThe file first output instances will be written to.\n-r <filename>\n\tThe file containing second input instances.\n-s <filename>\n\tThe file second output instances will be written to.\n-c <class index>\n\tThe number of the attribute to use as the class.\n\t\"first\" and \"last\" are also valid entries.\n\tIf not supplied then no class is assigned.\n";
            if (filter instanceof Sourcable) {
                object2 = (String)object2 + "-z <class name>\n\tOutputs the source code representing the trained filter.\n";
            }
            throw new Exception('\n' + exception.getMessage() + string3 + (String)object2);
        }
        boolean bl = false;
        if (filter.setInputFormat(instances)) {
            printWriter.println(filter.getOutputFormat().toString());
            bl = true;
        }
        while (dataSource.hasMoreElements(instances)) {
            object = dataSource.nextElement(instances);
            if (!filter.input((Instance)object)) continue;
            if (!bl) {
                throw new Error("Filter didn't return true from setInputFormat() earlier!");
            }
            printWriter.println(filter.output().toString());
        }
        if (filter.batchFinished()) {
            if (!bl) {
                printWriter.println(filter.getOutputFormat().toString());
            }
            while (filter.numPendingOutput() > 0) {
                printWriter.println(filter.output().toString());
            }
        }
        if (printWriter != null) {
            printWriter.close();
        }
        bl = false;
        if (filter.isOutputFormatDefined()) {
            printWriter2.println(filter.getOutputFormat().toString());
            bl = true;
        }
        while (dataSource2.hasMoreElements(instances2)) {
            object = dataSource2.nextElement(instances2);
            if (!filter.input((Instance)object)) continue;
            if (!bl) {
                throw new Error("Filter didn't return true from isOutputFormatDefined() earlier!");
            }
            printWriter2.println(filter.output().toString());
        }
        if (filter.batchFinished()) {
            if (!bl) {
                printWriter2.println(filter.getOutputFormat().toString());
            }
            while (filter.numPendingOutput() > 0) {
                printWriter2.println(filter.output().toString());
            }
        }
        if (printWriter2 != null) {
            printWriter2.close();
        }
        if (string.length() != 0) {
            System.out.println(Filter.wekaStaticWrapper((Sourcable)((Object)filter), string, instances, filter.getOutputFormat()));
        }
    }

    protected static void runFilter(Filter filter, String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(filter, stringArray);
            } else {
                Filter.filterFile(filter, stringArray);
            }
        }
        catch (Exception exception) {
            if (exception.toString().indexOf("Help requested") == -1 && exception.toString().indexOf("Filter options") == -1) {
                exception.printStackTrace();
            }
            System.err.println(exception.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                throw new Exception("First argument must be the class name of a Filter");
            }
            String string = stringArray[0];
            Filter filter = (Filter)Class.forName(string).newInstance();
            stringArray[0] = "";
            Filter.runFilter(filter, stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

