/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.instance;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Copyable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;

public class SMOTE
extends Filter
implements SupervisedFilter,
OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -1653880819059250364L;
    protected int m_NearestNeighbors = 5;
    protected int m_RandomSeed = 1;
    protected double m_Percentage = 100.0;
    protected String m_ClassValueIndex = "0";
    protected boolean m_DetectMinorityClass = true;

    public String globalInfo() {
        return "Resamples a dataset by applying the Synthetic Minority Oversampling TEchnique (SMOTE). The original dataset must fit entirely in memory. The amount of SMOTE and number of nearest neighbors may be specified. For more information, see \n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Nitesh V. Chawla et. al.");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Synthetic Minority Over-sampling Technique");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "Journal of Artificial Intelligence Research");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2002");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "16");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "321-357");
        return technicalInformation;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4565 $");
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tSpecifies the random number seed\n\t(default 1)", "S", 1, "-S <num>"));
        vector.addElement(new Option("\tSpecifies percentage of SMOTE instances to create.\n\t(default 100.0)\n", "P", 1, "-P <percentage>"));
        vector.addElement(new Option("\tSpecifies the number of nearest neighbors to use.\n\t(default 5)\n", "K", 1, "-K <nearest-neighbors>"));
        vector.addElement(new Option("\tSpecifies the index of the nominal class value to SMOTE\n\t(default 0: auto-detect non-empty minority class))\n", "C", 1, "-C <value-index>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setRandomSeed(Integer.parseInt(string));
        } else {
            this.setRandomSeed(1);
        }
        String string2 = Utils.getOption('P', stringArray);
        if (string2.length() != 0) {
            this.setPercentage(new Double(string2));
        } else {
            this.setPercentage(100.0);
        }
        String string3 = Utils.getOption('K', stringArray);
        if (string3.length() != 0) {
            this.setNearestNeighbors(Integer.parseInt(string3));
        } else {
            this.setNearestNeighbors(5);
        }
        String string4 = Utils.getOption('C', stringArray);
        if (string4.length() != 0) {
            this.setClassValue(string4);
        } else {
            this.m_DetectMinorityClass = true;
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-C");
        vector.add(this.getClassValue());
        vector.add("-K");
        vector.add("" + this.getNearestNeighbors());
        vector.add("-P");
        vector.add("" + this.getPercentage());
        vector.add("-S");
        vector.add("" + this.getRandomSeed());
        return vector.toArray(new String[vector.size()]);
    }

    public String randomSeedTipText() {
        return "The seed used for random sampling.";
    }

    public int getRandomSeed() {
        return this.m_RandomSeed;
    }

    public void setRandomSeed(int n) {
        this.m_RandomSeed = n;
    }

    public String percentageTipText() {
        return "The percentage of SMOTE instances to create.";
    }

    public void setPercentage(double d) {
        if (d >= 0.0) {
            this.m_Percentage = d;
        } else {
            System.err.println("Percentage must be >= 0!");
        }
    }

    public double getPercentage() {
        return this.m_Percentage;
    }

    public String nearestNeighborsTipText() {
        return "The number of nearest neighbors to use.";
    }

    public void setNearestNeighbors(int n) {
        if (n >= 1) {
            this.m_NearestNeighbors = n;
        } else {
            System.err.println("At least 1 neighbor necessary!");
        }
    }

    public int getNearestNeighbors() {
        return this.m_NearestNeighbors;
    }

    public String classValueTipText() {
        return "The index of the class value to which SMOTE should be applied. Use a value of 0 to auto-detect the non-empty minority class.";
    }

    public void setClassValue(String string) {
        this.m_ClassValueIndex = string;
        this.m_DetectMinorityClass = this.m_ClassValueIndex.equals("0");
    }

    public String getClassValue() {
        return this.m_ClassValueIndex;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        super.setOutputFormat(instances);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_FirstBatchDone) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.m_FirstBatchDone) {
            this.doSMOTE();
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    protected void doSMOTE() throws Exception {
        int n;
        int n2;
        List<Integer> list;
        Serializable serializable;
        Serializable serializable2;
        int n3;
        Object object;
        int n4 = 0;
        Object object2 = Integer.MAX_VALUE;
        if (this.m_DetectMinorityClass) {
            object = this.getInputFormat().attributeStats((int)this.getInputFormat().classIndex()).nominalCounts;
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (object[i] == false || object[i] >= object2) continue;
                object2 = object[i];
                n4 = i;
            }
        } else {
            object = this.getClassValue();
            n4 = ((String)object).equalsIgnoreCase("first") ? 1 : (((String)object).equalsIgnoreCase("last") ? this.getInputFormat().numClasses() : Integer.parseInt((String)object));
            if (n4 > this.getInputFormat().numClasses()) {
                throw new Exception("value index must be <= the number of classes");
            }
            --n4;
        }
        if ((n3 = object2 <= this.getNearestNeighbors() ? object2 - 1 : this.getNearestNeighbors()) < 1) {
            throw new Exception("Cannot use 0 neighbors!");
        }
        Instances instances = this.getInputFormat().stringFreeStructure();
        Enumeration enumeration = this.getInputFormat().enumerateInstances();
        while (enumeration.hasMoreElements()) {
            serializable2 = (Instance)enumeration.nextElement();
            this.push((Instance)((Instance)serializable2).copy());
            if ((int)((Instance)serializable2).classValue() != n4) continue;
            instances.add((Instance)serializable2);
        }
        serializable2 = new HashMap();
        Enumeration enumeration2 = this.getInputFormat().enumerateAttributes();
        while (enumeration2.hasMoreElements()) {
            serializable = (Attribute)enumeration2.nextElement();
            if (((Attribute)serializable).equals(this.getInputFormat().classAttribute()) || !((Attribute)serializable).isNominal() && !((Attribute)serializable).isString()) continue;
            list = (List<Integer>)new double[((Attribute)serializable).numValues()][((Attribute)serializable).numValues()];
            serializable2.put(serializable, list);
            int[] nArray = new int[((Attribute)serializable).numValues()];
            int[][] nArray2 = new int[this.getInputFormat().classAttribute().numValues()][((Attribute)serializable).numValues()];
            enumeration = this.getInputFormat().enumerateInstances();
            while (enumeration.hasMoreElements()) {
                Instance instance = (Instance)enumeration.nextElement();
                n2 = (int)instance.value((Attribute)serializable);
                int n5 = (int)instance.classValue();
                int n6 = n2;
                nArray[n6] = nArray[n6] + 1;
                int[] nArray3 = nArray2[n5];
                int n7 = n2;
                nArray3[n7] = nArray3[n7] + 1;
            }
            for (n = 0; n < ((Attribute)serializable).numValues(); ++n) {
                for (n2 = 0; n2 < ((Attribute)serializable).numValues(); ++n2) {
                    double d = 0.0;
                    for (int i = 0; i < this.getInputFormat().numClasses(); ++i) {
                        double d2 = nArray2[i][n];
                        double d3 = nArray2[i][n2];
                        double d4 = nArray[n];
                        double d5 = nArray[n2];
                        double d6 = d2 / d4;
                        double d7 = d3 / d5;
                        d += Math.abs(d6 - d7);
                    }
                    list[n][n2] = (List)d;
                }
            }
        }
        serializable = new Random(this.getRandomSeed());
        list = new LinkedList();
        double d = this.getPercentage() / 100.0 - Math.floor(this.getPercentage() / 100.0);
        n = (int)(d * (double)instances.numInstances());
        if (n >= 1) {
            for (n2 = 0; n2 < instances.numInstances(); ++n2) {
                list.add(n2);
            }
        }
        Collections.shuffle(list, (Random)serializable);
        list = list.subList(0, n);
        HashSet hashSet = new HashSet(list);
        Instance[] instanceArray = new Instance[n3];
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
            for (int j = 0; j < instances.numInstances(); ++j) {
                Instance instance2 = instances.instance(j);
                if (i == j) continue;
                double d8 = 0.0;
                enumeration2 = this.getInputFormat().enumerateAttributes();
                while (enumeration2.hasMoreElements()) {
                    Attribute attribute = (Attribute)enumeration2.nextElement();
                    if (attribute.equals(this.getInputFormat().classAttribute())) continue;
                    double d9 = instance.value(attribute);
                    double d10 = instance2.value(attribute);
                    if (attribute.isNumeric()) {
                        d8 += Math.pow(d9 - d10, 2.0);
                        continue;
                    }
                    d8 += ((double[][])serializable2.get(attribute))[(int)d9][(int)d10];
                }
                d8 = Math.pow(d8, 0.5);
                linkedList.add(new Object[]{d8, instance2});
            }
            Collections.sort(linkedList, new Comparator(){

                public int compare(Object object, Object object2) {
                    double d = (Double)((Object[])object)[0];
                    double d2 = (Double)((Object[])object2)[0];
                    return (int)Math.ceil(d - d2);
                }
            });
            Iterator iterator = linkedList.iterator();
            for (int j = 0; iterator.hasNext() && j < n3; ++j) {
                instanceArray[j] = (Instance)((Object[])iterator.next())[1];
            }
            for (int j = (int)Math.floor(this.getPercentage() / 100.0); j > 0 || hashSet.remove(i); --j) {
                Copyable copyable;
                double[] dArray = new double[instances.numAttributes()];
                int n8 = ((Random)serializable).nextInt(n3);
                enumeration2 = this.getInputFormat().enumerateAttributes();
                while (enumeration2.hasMoreElements()) {
                    int n9;
                    int n10;
                    int n11;
                    copyable = (Attribute)enumeration2.nextElement();
                    if (((Attribute)copyable).equals(this.getInputFormat().classAttribute())) continue;
                    if (((Attribute)copyable).isNumeric()) {
                        double d11 = instanceArray[n8].value((Attribute)copyable) - instance.value((Attribute)copyable);
                        double d12 = ((Random)serializable).nextDouble();
                        dArray[((Attribute)copyable).index()] = instance.value((Attribute)copyable) + d12 * d11;
                        continue;
                    }
                    if (((Attribute)copyable).isDate()) {
                        double d13 = instanceArray[n8].value((Attribute)copyable) - instance.value((Attribute)copyable);
                        double d14 = ((Random)serializable).nextDouble();
                        dArray[((Attribute)copyable).index()] = (long)(instance.value((Attribute)copyable) + d14 * d13);
                        continue;
                    }
                    int[] nArray = new int[((Attribute)copyable).numValues()];
                    int n12 = n11 = (int)instance.value((Attribute)copyable);
                    nArray[n12] = nArray[n12] + 1;
                    for (n10 = 0; n10 < n3; ++n10) {
                        int n13 = n9 = (int)instanceArray[n10].value((Attribute)copyable);
                        nArray[n13] = nArray[n13] + 1;
                    }
                    n10 = 0;
                    n9 = Integer.MIN_VALUE;
                    for (int k = 0; k < ((Attribute)copyable).numValues(); ++k) {
                        if (nArray[k] <= n9) continue;
                        n9 = nArray[k];
                        n10 = k;
                    }
                    dArray[((Attribute)copyable).index()] = n10;
                }
                dArray[instances.classIndex()] = n4;
                copyable = new Instance(1.0, dArray);
                this.push((Instance)copyable);
            }
        }
    }

    public static void main(String[] stringArray) {
        SMOTE.runFilter(new SMOTE(), stringArray);
    }
}

