/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import weka.classifiers.bayes.net.GUI;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.core.Copyright;
import weka.core.Instances;
import weka.core.Memory;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.SystemInfo;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.Version;
import weka.core.logging.Logger;
import weka.gui.BrowserHelper;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.LogWindow;
import weka.gui.LookAndFeel;
import weka.gui.MainMenuExtension;
import weka.gui.MemoryUsagePanel;
import weka.gui.SimpleCLIPanel;
import weka.gui.SplashWindow;
import weka.gui.arffviewer.ArffViewerMainPanel;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.StartUpListener;
import weka.gui.boundaryvisualizer.BoundaryVisualizer;
import weka.gui.experiment.Experimenter;
import weka.gui.explorer.Explorer;
import weka.gui.graphvisualizer.GraphVisualizer;
import weka.gui.sql.SqlViewer;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.ThresholdVisualizePanel;
import weka.gui.visualize.VisualizePanel;

public class Main
extends JFrame
implements OptionHandler {
    private static final long serialVersionUID = 1453813254824253849L;
    public static final int GUI_MDI = 0;
    public static final int GUI_SDI = 1;
    public static final Tag[] TAGS_GUI = new Tag[]{new Tag(0, "MDI", "MDI Layout"), new Tag(1, "SDI", "SDI Layout")};
    protected Main m_Self;
    protected int m_GUIType = 0;
    protected static Main m_MainCommandline;
    protected static Main m_MainSingleton;
    protected static Vector m_StartupListeners;
    protected static Memory m_Memory;
    protected HashSet<Container> m_ChildFrames = new HashSet();
    protected static LogWindow m_LogWindow;
    protected JFileChooser m_FileChooserTreeVisualizer = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserGraphVisualizer = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserPlot = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserROC = new JFileChooser(new File(System.getProperty("user.dir")));
    private JMenu jMenuHelp;
    private JMenu jMenuVisualization;
    private JMenu jMenuTools;
    private JDesktopPane jDesktopPane;
    private JMenu jMenuApplications;
    private JMenuItem jMenuItemHelpSystemInfo;
    private JMenuItem jMenuItemHelpAbout;
    private JMenuItem jMenuItemHelpHomepage;
    private JMenuItem jMenuItemHelpWekaWiki;
    private JMenuItem jMenuItemHelpWekaDoc;
    private JMenuItem jMenuItemHelpSourceforge;
    private JMenuItem jMenuItemVisualizationBoundaryVisualizer;
    private JMenuItem jMenuItemVisualizationGraphVisualizer;
    private JMenuItem jMenuItemVisualizationTreeVisualizer;
    private JMenuItem jMenuItemVisualizationROC;
    private JMenuItem jMenuItemVisualizationPlot;
    private JMenuItem jMenuItemToolsEnsembleLibrary;
    private JMenuItem jMenuItemToolsSqlViewer;
    private JMenuItem jMenuItemToolsArffViewer;
    private JMenuItem jMenuItemApplicationsSimpleCLI;
    private JMenuItem jMenuItemApplicationsKnowledgeFlow;
    private JMenuItem jMenuItemApplicationsExperimenter;
    private JMenuItem jMenuItemApplicationsExplorer;
    private JMenuItem jMenuItemProgramExit;
    private JMenuItem jMenuItemProgramLogWindow;
    private JMenuItem jMenuItemProgramMemoryUsage;
    private JMenuItem jMenuItemProgramPreferences;
    private JMenu jMenuProgram;
    private JMenu jMenuExtensions;
    private JMenu jMenuWindows;
    private JMenuBar jMenuBar;

    protected Container createFrame(Main main, String string, Component component, LayoutManager layoutManager, Object object, int n, int n2, JMenuBar jMenuBar, boolean bl, boolean bl2) {
        Container container = null;
        if (this.m_GUIType == 0) {
            final ChildFrameMDI childFrameMDI = new ChildFrameMDI(main, string);
            childFrameMDI.setLayout(layoutManager);
            if (component != null) {
                childFrameMDI.getContentPane().add(component, object);
            }
            childFrameMDI.setJMenuBar(jMenuBar);
            childFrameMDI.pack();
            if (n > -1 && n2 > -1) {
                childFrameMDI.setSize(n, n2);
            }
            childFrameMDI.validate();
            if (bl) {
                childFrameMDI.addInternalFrameListener(new InternalFrameAdapter(){

                    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                        childFrameMDI.dispose();
                    }
                });
            }
            if (bl2) {
                childFrameMDI.setVisible(true);
                try {
                    childFrameMDI.setSelected(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            container = childFrameMDI;
        } else if (this.m_GUIType == 1) {
            final ChildFrameSDI childFrameSDI = new ChildFrameSDI(main, string);
            childFrameSDI.setLayout(layoutManager);
            if (component != null) {
                childFrameSDI.getContentPane().add(component, object);
            }
            childFrameSDI.setJMenuBar(jMenuBar);
            childFrameSDI.pack();
            if (n > -1 && n2 > -1) {
                childFrameSDI.setSize(n, n2);
            }
            childFrameSDI.validate();
            int n3 = this.getGraphicsConfiguration().getBounds().height;
            int n4 = this.getGraphicsConfiguration().getBounds().width;
            childFrameSDI.setLocation((n4 - childFrameSDI.getBounds().width) / 2, (n3 - childFrameSDI.getBounds().height) / 2);
            if (bl) {
                childFrameSDI.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        childFrameSDI.dispose();
                    }
                });
            }
            if (bl2) {
                childFrameSDI.setVisible(true);
            }
            container = childFrameSDI;
        }
        return container;
    }

    protected void insertMenuItem(JMenu jMenu, JMenuItem jMenuItem) {
        this.insertMenuItem(jMenu, jMenuItem, 0);
    }

    protected void insertMenuItem(JMenu jMenu, JMenuItem jMenuItem, int n) {
        boolean bl = false;
        String string = jMenuItem.getText().toLowerCase();
        for (int i = n; i < jMenu.getMenuComponentCount(); ++i) {
            JMenuItem jMenuItem2;
            String string2;
            if (!(jMenu.getMenuComponent(i) instanceof JMenuItem) || (string2 = (jMenuItem2 = (JMenuItem)jMenu.getMenuComponent(i)).getText().toLowerCase()).compareTo(string) <= 0) continue;
            bl = true;
            jMenu.insert(jMenuItem, i);
            break;
        }
        if (!bl) {
            jMenu.add(jMenuItem);
        }
    }

    protected void initGUI() {
        this.m_Self = this;
        try {
            int n;
            this.createTitle("");
            this.setDefaultCloseOperation(3);
            this.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("weka/gui/weka_icon.gif")).getImage());
            this.m_FileChooserGraphVisualizer.addChoosableFileFilter(new ExtensionFileFilter(".bif", "BIF Files (*.bif)"));
            this.m_FileChooserGraphVisualizer.addChoosableFileFilter(new ExtensionFileFilter(".xml", "XML Files (*.xml)"));
            this.m_FileChooserPlot.addChoosableFileFilter(new ExtensionFileFilter(".arff", "ARFF Files (*.arff)"));
            this.m_FileChooserPlot.setMultiSelectionEnabled(true);
            this.m_FileChooserROC.addChoosableFileFilter(new ExtensionFileFilter(".arff", "ARFF Files (*.arff)"));
            if (this.m_GUIType == 0) {
                this.jDesktopPane = new BackgroundDesktopPane("weka/gui/images/weka_background.gif");
                this.jDesktopPane.setDragMode(1);
                this.setContentPane(this.jDesktopPane);
            } else {
                this.jDesktopPane = null;
            }
            this.jMenuBar = new JMenuBar();
            this.setJMenuBar(this.jMenuBar);
            this.jMenuProgram = new JMenu();
            this.jMenuBar.add(this.jMenuProgram);
            this.jMenuProgram.setText("Program");
            this.jMenuProgram.setMnemonic('P');
            this.jMenuItemProgramLogWindow = new JMenuItem();
            this.jMenuProgram.add(this.jMenuItemProgramLogWindow);
            this.jMenuItemProgramLogWindow.setText("LogWindow");
            this.jMenuItemProgramLogWindow.setMnemonic('L');
            this.jMenuItemProgramLogWindow.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    m_LogWindow.setVisible(true);
                }
            });
            this.jMenuItemProgramMemoryUsage = new JMenuItem();
            this.jMenuProgram.add(this.jMenuItemProgramMemoryUsage);
            this.jMenuItemProgramMemoryUsage.setText("Memory usage");
            this.jMenuItemProgramMemoryUsage.setMnemonic('M');
            this.jMenuItemProgramMemoryUsage.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Main.this.jMenuItemProgramMemoryUsage.getText();
                    if (!Main.this.containsWindow(string)) {
                        final MemoryUsagePanel memoryUsagePanel = new MemoryUsagePanel();
                        Container container = Main.this.createFrame(Main.this.m_Self, string, memoryUsagePanel, new BorderLayout(), "Center", 400, 50, null, true, true);
                        Dimension dimension = container.getPreferredSize();
                        container.setSize(new Dimension((int)dimension.getWidth(), (int)dimension.getHeight()));
                        if (Main.this.m_GUIType == 0) {
                            ChildFrameMDI childFrameMDI = (ChildFrameMDI)container;
                            Point point = memoryUsagePanel.getFrameLocation();
                            if (point.x != -1 && point.y != -1) {
                                childFrameMDI.setLocation(point);
                            }
                            childFrameMDI.addInternalFrameListener(new InternalFrameAdapter(){

                                public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                                    memoryUsagePanel.stopMonitoring();
                                }
                            });
                        } else {
                            ChildFrameSDI childFrameSDI = (ChildFrameSDI)container;
                            Point point = memoryUsagePanel.getFrameLocation();
                            if (point.x != -1 && point.y != -1) {
                                childFrameSDI.setLocation(point);
                            }
                            childFrameSDI.addWindowListener(new WindowAdapter(){

                                public void windowClosing(WindowEvent windowEvent) {
                                    memoryUsagePanel.stopMonitoring();
                                }
                            });
                        }
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
            this.jMenuProgram.add(new JSeparator());
            this.jMenuItemProgramExit = new JMenuItem();
            this.jMenuProgram.add(this.jMenuItemProgramExit);
            this.jMenuItemProgramExit.setText("Exit");
            this.jMenuItemProgramExit.setMnemonic('E');
            this.jMenuItemProgramExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Iterator iterator = Main.this.getWindowList();
                    Vector<Container> vector = new Vector<Container>();
                    while (iterator.hasNext()) {
                        vector.add((Container)iterator.next());
                    }
                    for (int i = 0; i < vector.size(); ++i) {
                        Container container = (Container)vector.get(i);
                        if (container instanceof ChildFrameMDI) {
                            ((ChildFrameMDI)container).dispose();
                            continue;
                        }
                        if (!(container instanceof ChildFrameSDI)) continue;
                        ((ChildFrameSDI)container).dispose();
                    }
                    m_LogWindow.dispose();
                    Main.this.m_Self.dispose();
                    System.exit(0);
                }
            });
            this.jMenuApplications = new JMenu();
            this.jMenuBar.add(this.jMenuApplications);
            this.jMenuApplications.setText("Applications");
            this.jMenuApplications.setMnemonic('A');
            this.jMenuItemApplicationsExplorer = new JMenuItem();
            this.jMenuApplications.add(this.jMenuItemApplicationsExplorer);
            this.jMenuItemApplicationsExplorer.setText("Explorer");
            this.jMenuItemApplicationsExplorer.setMnemonic('E');
            this.jMenuItemApplicationsExplorer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Main.this.jMenuItemApplicationsExplorer.getText();
                    if (!Main.this.containsWindow(string)) {
                        Main.this.createFrame(Main.this.m_Self, string, new Explorer(), new BorderLayout(), "Center", 800, 600, null, true, true);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
            this.jMenuItemApplicationsExperimenter = new JMenuItem();
            this.jMenuApplications.add(this.jMenuItemApplicationsExperimenter);
            this.jMenuItemApplicationsExperimenter.setText("Experimenter");
            this.jMenuItemApplicationsExperimenter.setMnemonic('X');
            this.jMenuItemApplicationsExperimenter.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Main.this.jMenuItemApplicationsExperimenter.getText();
                    if (!Main.this.containsWindow(string)) {
                        Main.this.createFrame(Main.this.m_Self, string, new Experimenter(false), new BorderLayout(), "Center", 800, 600, null, true, true);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
            this.jMenuItemApplicationsKnowledgeFlow = new JMenuItem();
            this.jMenuApplications.add(this.jMenuItemApplicationsKnowledgeFlow);
            this.jMenuItemApplicationsKnowledgeFlow.setText("KnowledgeFlow");
            this.jMenuItemApplicationsKnowledgeFlow.setMnemonic('K');
            this.jMenuItemApplicationsKnowledgeFlow.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Main.this.jMenuItemApplicationsKnowledgeFlow.getText();
                    if (!Main.this.containsWindow(string)) {
                        KnowledgeFlowApp.createSingleton(new String[0]);
                        Main.this.createFrame(Main.this.m_Self, string, KnowledgeFlowApp.getSingleton(), new BorderLayout(), "Center", 900, 600, null, true, true);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
            this.jMenuItemApplicationsSimpleCLI = new JMenuItem();
            this.jMenuApplications.add(this.jMenuItemApplicationsSimpleCLI);
            this.jMenuItemApplicationsSimpleCLI.setText("SimpleCLI");
            this.jMenuItemApplicationsSimpleCLI.setMnemonic('S');
            this.jMenuItemApplicationsSimpleCLI.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Main.this.jMenuItemApplicationsSimpleCLI.getText();
                    if (!Main.this.containsWindow(string)) {
                        try {
                            Main.this.createFrame(Main.this.m_Self, string, new SimpleCLIPanel(), new BorderLayout(), "Center", 600, 500, null, true, true);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            JOptionPane.showMessageDialog(Main.this.m_Self, "Error instantiating SimpleCLI:\n" + exception.getMessage());
                            return;
                        }
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
            this.jMenuTools = new JMenu();
            this.jMenuBar.add(this.jMenuTools);
            this.jMenuTools.setText("Tools");
            this.jMenuTools.setMnemonic('T');
            this.jMenuItemToolsArffViewer = new JMenuItem();
            this.jMenuTools.add(this.jMenuItemToolsArffViewer);
            this.jMenuItemToolsArffViewer.setText("ArffViewer");
            this.jMenuItemToolsArffViewer.setMnemonic('A');
            this.jMenuItemToolsArffViewer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Main.this.jMenuItemToolsArffViewer.getText();
                    if (!Main.this.containsWindow(string)) {
                        ArffViewerMainPanel arffViewerMainPanel = new ArffViewerMainPanel(null);
                        arffViewerMainPanel.setConfirmExit(false);
                        Container container = Main.this.createFrame(Main.this.m_Self, string, arffViewerMainPanel, new BorderLayout(), "Center", 800, 600, arffViewerMainPanel.getMenu(), true, true);
                        arffViewerMainPanel.setParent(container);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
            this.jMenuItemToolsSqlViewer = new JMenuItem();
            this.jMenuTools.add(this.jMenuItemToolsSqlViewer);
            this.jMenuItemToolsSqlViewer.setText("SqlViewer");
            this.jMenuItemToolsSqlViewer.setMnemonic('S');
            this.jMenuItemToolsSqlViewer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Main.this.jMenuItemToolsSqlViewer.getText();
                    if (!Main.this.containsWindow(string)) {
                        final SqlViewer sqlViewer = new SqlViewer(null);
                        final Container container = Main.this.createFrame(Main.this.m_Self, string, sqlViewer, new BorderLayout(), "Center", -1, -1, null, false, true);
                        if (container instanceof ChildFrameMDI) {
                            ((ChildFrameMDI)container).addInternalFrameListener(new InternalFrameAdapter(){

                                public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                                    sqlViewer.saveSize();
                                    ((ChildFrameMDI)container).dispose();
                                }
                            });
                        } else if (container instanceof ChildFrameSDI) {
                            ((ChildFrameSDI)container).addWindowListener(new WindowAdapter(){

                                public void windowClosing(WindowEvent windowEvent) {
                                    sqlViewer.saveSize();
                                    ((ChildFrameSDI)container).dispose();
                                }
                            });
                        }
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
            final JMenuItem jMenuItem = new JMenuItem();
            this.jMenuTools.add(jMenuItem);
            jMenuItem.setText("Bayes net editor");
            jMenuItem.setMnemonic('N');
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = jMenuItem.getText();
                    if (!Main.this.containsWindow(string)) {
                        GUI gUI = new GUI();
                        Container container = Main.this.createFrame(Main.this.m_Self, string, gUI, new BorderLayout(), "Center", 800, 600, gUI.getMenuBar(), false, true);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
            this.jMenuVisualization = new JMenu();
            this.jMenuBar.add(this.jMenuVisualization);
            this.jMenuVisualization.setText("Visualization");
            this.jMenuVisualization.setMnemonic('V');
            this.jMenuItemVisualizationPlot = new JMenuItem();
            this.jMenuVisualization.add(this.jMenuItemVisualizationPlot);
            this.jMenuItemVisualizationPlot.setText("Plot");
            this.jMenuItemVisualizationPlot.setMnemonic('P');
            this.jMenuItemVisualizationPlot.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = Main.this.m_FileChooserPlot.showOpenDialog(Main.this.m_Self);
                    if (n != 0) {
                        return;
                    }
                    VisualizePanel visualizePanel = new VisualizePanel();
                    String string = "";
                    File[] fileArray = Main.this.m_FileChooserPlot.getSelectedFiles();
                    for (int i = 0; i < fileArray.length; ++i) {
                        String string2 = fileArray[i].getAbsolutePath();
                        if (i > 0) {
                            string = string + ", ";
                        }
                        string = string + string2;
                        System.err.println("Loading instances from " + string2);
                        try {
                            BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
                            Instances instances = new Instances(bufferedReader);
                            instances.setClassIndex(instances.numAttributes() - 1);
                            PlotData2D plotData2D = new PlotData2D(instances);
                            if (i == 0) {
                                plotData2D.setPlotName("Master plot");
                                visualizePanel.setMasterPlot(plotData2D);
                                continue;
                            }
                            plotData2D.setPlotName("Plot " + (i + 1));
                            plotData2D.m_useCustomColour = true;
                            plotData2D.m_customColour = i % 2 == 0 ? Color.red : Color.blue;
                            visualizePanel.addPlot(plotData2D);
                            continue;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            JOptionPane.showMessageDialog(Main.this.m_Self, "Error loading file '" + fileArray[i] + "':\n" + exception.getMessage());
                            return;
                        }
                    }
                    Main.this.createFrame(Main.this.m_Self, Main.this.jMenuItemVisualizationPlot.getText() + " - " + string, visualizePanel, new BorderLayout(), "Center", 800, 600, null, true, true);
                }
            });
            this.jMenuItemVisualizationROC = new JMenuItem();
            this.jMenuVisualization.add(this.jMenuItemVisualizationROC);
            this.jMenuItemVisualizationROC.setText("ROC");
            this.jMenuItemVisualizationROC.setMnemonic('R');
            this.jMenuItemVisualizationROC.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = Main.this.m_FileChooserROC.showOpenDialog(Main.this.m_Self);
                    if (n != 0) {
                        return;
                    }
                    String string = Main.this.m_FileChooserROC.getSelectedFile().getAbsolutePath();
                    Instances instances = null;
                    try {
                        instances = new Instances(new BufferedReader(new FileReader(string)));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(Main.this.m_Self, "Error loading file '" + string + "':\n" + exception.getMessage());
                        return;
                    }
                    instances.setClassIndex(instances.numAttributes() - 1);
                    ThresholdVisualizePanel thresholdVisualizePanel = new ThresholdVisualizePanel();
                    thresholdVisualizePanel.setROCString("(Area under ROC = " + Utils.doubleToString(ThresholdCurve.getROCArea(instances), 4) + ")");
                    thresholdVisualizePanel.setName(instances.relationName());
                    PlotData2D plotData2D = new PlotData2D(instances);
                    plotData2D.setPlotName(instances.relationName());
                    plotData2D.addInstanceNumberAttribute();
                    try {
                        thresholdVisualizePanel.addPlot(plotData2D);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(Main.this.m_Self, "Error adding plot:\n" + exception.getMessage());
                        return;
                    }
                    Main.this.createFrame(Main.this.m_Self, Main.this.jMenuItemVisualizationROC.getText() + " - " + string, thresholdVisualizePanel, new BorderLayout(), "Center", 800, 600, null, true, true);
                }
            });
            this.jMenuItemVisualizationTreeVisualizer = new JMenuItem();
            this.jMenuVisualization.add(this.jMenuItemVisualizationTreeVisualizer);
            this.jMenuItemVisualizationTreeVisualizer.setText("TreeVisualizer");
            this.jMenuItemVisualizationTreeVisualizer.setMnemonic('T');
            this.jMenuItemVisualizationTreeVisualizer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = Main.this.m_FileChooserTreeVisualizer.showOpenDialog(Main.this.m_Self);
                    if (n != 0) {
                        return;
                    }
                    String string = Main.this.m_FileChooserTreeVisualizer.getSelectedFile().getAbsolutePath();
                    TreeBuild treeBuild = new TreeBuild();
                    Node node = null;
                    PlaceNode2 placeNode2 = new PlaceNode2();
                    try {
                        node = treeBuild.create(new FileReader(string));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(Main.this.m_Self, "Error loading file '" + string + "':\n" + exception.getMessage());
                        return;
                    }
                    Main.this.createFrame(Main.this.m_Self, Main.this.jMenuItemVisualizationTreeVisualizer.getText() + " - " + string, new TreeVisualizer(null, node, (NodePlace)placeNode2), new BorderLayout(), "Center", 800, 600, null, true, true);
                }
            });
            this.jMenuItemVisualizationGraphVisualizer = new JMenuItem();
            this.jMenuVisualization.add(this.jMenuItemVisualizationGraphVisualizer);
            this.jMenuItemVisualizationGraphVisualizer.setText("GraphVisualizer");
            this.jMenuItemVisualizationGraphVisualizer.setMnemonic('G');
            this.jMenuItemVisualizationGraphVisualizer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = Main.this.m_FileChooserGraphVisualizer.showOpenDialog(Main.this.m_Self);
                    if (n != 0) {
                        return;
                    }
                    String string = Main.this.m_FileChooserGraphVisualizer.getSelectedFile().getAbsolutePath();
                    GraphVisualizer graphVisualizer = new GraphVisualizer();
                    try {
                        if (string.toLowerCase().endsWith(".xml") || string.toLowerCase().endsWith(".bif")) {
                            graphVisualizer.readBIF(new FileInputStream(string));
                        } else {
                            graphVisualizer.readDOT(new FileReader(string));
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(Main.this.m_Self, "Error loading file '" + string + "':\n" + exception.getMessage());
                        return;
                    }
                    Main.this.createFrame(Main.this.m_Self, Main.this.jMenuItemVisualizationGraphVisualizer.getText() + " - " + string, graphVisualizer, new BorderLayout(), "Center", 800, 600, null, true, true);
                }
            });
            this.jMenuItemVisualizationBoundaryVisualizer = new JMenuItem();
            this.jMenuVisualization.add(this.jMenuItemVisualizationBoundaryVisualizer);
            this.jMenuItemVisualizationBoundaryVisualizer.setText("BoundaryVisualizer");
            this.jMenuItemVisualizationBoundaryVisualizer.setMnemonic('B');
            this.jMenuItemVisualizationBoundaryVisualizer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Main.this.jMenuItemVisualizationBoundaryVisualizer.getText();
                    if (!Main.this.containsWindow(string)) {
                        Main.this.createFrame(Main.this.m_Self, string, new BoundaryVisualizer(), new BorderLayout(), "Center", 800, 600, null, true, true);
                        BoundaryVisualizer.setExitIfNoWindowsOpen(false);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
            this.jMenuExtensions = new JMenu("Extensions");
            this.jMenuExtensions.setMnemonic(69);
            this.jMenuBar.add(this.jMenuExtensions);
            this.jMenuExtensions.setVisible(false);
            String string = GenericObjectEditor.EDITOR_PROPERTIES.getProperty(MainMenuExtension.class.getName(), "");
            if (string.length() > 0) {
                this.jMenuExtensions.setVisible(true);
                String[] stringArray = GenericObjectEditor.EDITOR_PROPERTIES.getProperty(MainMenuExtension.class.getName(), "").split(",");
                Hashtable<String, JMenu> hashtable = new Hashtable<String, JMenu>();
                for (n = 0; n < stringArray.length; ++n) {
                    String string2 = stringArray[n];
                    try {
                        MainMenuExtension mainMenuExtension = (MainMenuExtension)Class.forName(string2).newInstance();
                        JMenu jMenu = null;
                        if (mainMenuExtension.getSubmenuTitle() != null && (jMenu = (JMenu)hashtable.get(mainMenuExtension.getSubmenuTitle())) == null) {
                            jMenu = new JMenu(mainMenuExtension.getSubmenuTitle());
                            hashtable.put(mainMenuExtension.getSubmenuTitle(), jMenu);
                            this.insertMenuItem(this.jMenuExtensions, jMenu);
                        }
                        JMenuItem jMenuItem2 = new JMenuItem();
                        jMenuItem2.setText(mainMenuExtension.getMenuTitle());
                        ActionListener actionListener = mainMenuExtension.getActionListener(this.m_Self);
                        if (actionListener != null) {
                            jMenuItem2.addActionListener(actionListener);
                        } else {
                            final JMenuItem jMenuItem3 = jMenuItem2;
                            final MainMenuExtension mainMenuExtension2 = mainMenuExtension;
                            jMenuItem2.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    Container container = Main.this.createFrame(Main.this.m_Self, jMenuItem3.getText(), null, null, null, -1, -1, null, false, false);
                                    mainMenuExtension2.fillFrame(container);
                                    container.setVisible(true);
                                }
                            });
                        }
                        if (jMenu != null) {
                            this.insertMenuItem(jMenu, jMenuItem2);
                            continue;
                        }
                        this.insertMenuItem(this.jMenuExtensions, jMenuItem2);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            this.jMenuWindows = new JMenu("Windows");
            this.jMenuWindows.setMnemonic(87);
            this.jMenuBar.add(this.jMenuWindows);
            this.jMenuWindows.setVisible(false);
            this.jMenuHelp = new JMenu();
            this.jMenuBar.add(this.jMenuHelp);
            this.jMenuHelp.setText("Help");
            this.jMenuHelp.setMnemonic('H');
            this.jMenuItemHelpHomepage = new JMenuItem();
            this.jMenuHelp.add(this.jMenuItemHelpHomepage);
            this.jMenuItemHelpHomepage.setText("Weka homepage");
            this.jMenuItemHelpHomepage.setMnemonic('H');
            this.jMenuItemHelpHomepage.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BrowserHelper.openURL(Main.this.m_Self, "http://www.cs.waikato.ac.nz/~ml/weka/");
                }
            });
            this.jMenuHelp.add(new JSeparator());
            this.jMenuItemHelpWekaWiki = new JMenuItem();
            this.jMenuHelp.add(this.jMenuItemHelpWekaWiki);
            this.jMenuItemHelpWekaWiki.setText("HOWTOs, code snippets, etc.");
            this.jMenuItemHelpWekaWiki.setMnemonic('W');
            this.jMenuItemHelpWekaWiki.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BrowserHelper.openURL(Main.this.m_Self, "http://weka.wiki.sourceforge.net/");
                }
            });
            this.jMenuItemHelpSourceforge = new JMenuItem();
            this.jMenuHelp.add(this.jMenuItemHelpSourceforge);
            this.jMenuItemHelpSourceforge.setText("Weka on SourceForge");
            this.jMenuItemHelpSourceforge.setMnemonic('F');
            this.jMenuItemHelpSourceforge.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BrowserHelper.openURL(Main.this.m_Self, "http://sourceforge.net/projects/weka/");
                }
            });
            this.jMenuHelp.add(new JSeparator());
            this.jMenuItemHelpSystemInfo = new JMenuItem();
            this.jMenuHelp.add(this.jMenuItemHelpSystemInfo);
            this.jMenuItemHelpSystemInfo.setText("SystemInfo");
            this.jMenuItemHelpHomepage.setMnemonic('S');
            this.jMenuItemHelpSystemInfo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Main.this.jMenuItemHelpSystemInfo.getText();
                    if (!Main.this.containsWindow(string)) {
                        Hashtable hashtable = new SystemInfo().getSystemInfo();
                        Vector vector = new Vector();
                        Enumeration enumeration = hashtable.keys();
                        while (enumeration.hasMoreElements()) {
                            vector.add(enumeration.nextElement());
                        }
                        Collections.sort(vector);
                        Object[][] objectArray = new String[hashtable.size()][2];
                        for (int i = 0; i < vector.size(); ++i) {
                            objectArray[i][0] = vector.get(i).toString();
                            objectArray[i][1] = hashtable.get(objectArray[i][0]).toString();
                        }
                        Object[] objectArray2 = new String[]{"Key", "Value"};
                        JTable jTable = new JTable(objectArray, objectArray2);
                        Main.this.createFrame(Main.this.m_Self, string, new JScrollPane(jTable), new BorderLayout(), "Center", 800, 600, null, true, true);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
            this.jMenuHelp.add(new JSeparator());
            this.jMenuItemHelpAbout = new JMenuItem();
            this.jMenuHelp.add(this.jMenuItemHelpAbout);
            this.jMenuItemHelpAbout.setText("About");
            this.jMenuItemHelpAbout.setMnemonic('A');
            this.jMenuItemHelpAbout.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Main.this.jMenuItemHelpAbout.getText();
                    if (!Main.this.containsWindow(string)) {
                        JPanel jPanel = new JPanel();
                        jPanel.setToolTipText("Weka, a native bird of New Zealand");
                        ImageIcon imageIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/gui/weka3.gif")));
                        JLabel jLabel = new JLabel(imageIcon);
                        jPanel.add(jLabel);
                        Container container = Main.this.createFrame(Main.this.m_Self, string, jPanel, new BorderLayout(), "Center", -1, -1, null, true, true);
                        JPanel jPanel2 = new JPanel();
                        jPanel2.setLayout(new GridLayout(8, 1));
                        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
                        jPanel2.add(new JLabel("Waikato Environment for", 0));
                        jPanel2.add(new JLabel("Knowledge Analysis", 0));
                        jPanel2.add(new JLabel(""));
                        jPanel2.add(new JLabel("Version " + Version.VERSION, 0));
                        jPanel2.add(new JLabel(""));
                        jPanel2.add(new JLabel("(c) " + Copyright.getFromYear() + " - " + Copyright.getToYear(), 0));
                        jPanel2.add(new JLabel(Copyright.getOwner(), 0));
                        jPanel2.add(new JLabel(Copyright.getAddress(), 0));
                        if (container instanceof ChildFrameMDI) {
                            ((ChildFrameMDI)container).getContentPane().add((Component)jPanel2, "North");
                            ((ChildFrameMDI)container).pack();
                        } else if (container instanceof ChildFrameSDI) {
                            ((ChildFrameSDI)container).getContentPane().add((Component)jPanel2, "North");
                            ((ChildFrameSDI)container).pack();
                        }
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
            int n2 = this.getGraphicsConfiguration().getBounds().height;
            int n3 = this.getGraphicsConfiguration().getBounds().width;
            if (this.m_GUIType == 0) {
                n = (int)((double)n2 * 0.75);
                int n4 = (int)((double)n3 * 0.75);
                this.setSize(1000 > n4 ? n4 : 1000, 800 > n ? n : 800);
                this.setLocation((n3 - this.getBounds().width) / 2, (n2 - this.getBounds().height) / 2);
            } else if (this.m_GUIType == 1) {
                this.pack();
                this.setSize(n3, this.getHeight());
                this.setLocation(0, 0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void createTitle(String string) {
        String string2 = "Weka " + new Version();
        if (string.length() != 0) {
            string2 = string2 + " - " + string;
        }
        this.setTitle(string2);
    }

    public void addChildFrame(Container container) {
        this.m_ChildFrames.add(container);
        this.windowListChanged();
    }

    public boolean removeChildFrame(Container container) {
        boolean bl = this.m_ChildFrames.remove(container);
        this.windowListChanged();
        return bl;
    }

    public boolean showWindow(Container container) {
        boolean bl;
        if (container != null) {
            try {
                if (container instanceof ChildFrameMDI) {
                    ChildFrameMDI childFrameMDI = (ChildFrameMDI)container;
                    childFrameMDI.setIcon(false);
                    childFrameMDI.toFront();
                    this.createTitle(childFrameMDI.getTitle());
                } else if (container instanceof ChildFrameSDI) {
                    ChildFrameSDI childFrameSDI = (ChildFrameSDI)container;
                    childFrameSDI.setExtendedState(0);
                    childFrameSDI.toFront();
                    this.createTitle(childFrameSDI.getTitle());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean showWindow(Class clazz) {
        return this.showWindow(this.getWindow(clazz));
    }

    public Iterator getWindowList() {
        return this.m_ChildFrames.iterator();
    }

    public Container getWindow(Class clazz) {
        Container container = null;
        Iterator iterator = this.getWindowList();
        while (iterator.hasNext()) {
            Container container2 = (Container)iterator.next();
            if (container2.getClass() != clazz) continue;
            container = container2;
            break;
        }
        return container;
    }

    public Container getWindow(String string) {
        Container container = null;
        Iterator iterator = this.getWindowList();
        while (iterator.hasNext()) {
            Container container2 = (Container)iterator.next();
            boolean bl = false;
            if (container2 instanceof ChildFrameMDI) {
                bl = ((ChildFrameMDI)container2).getTitle().equals(string);
            } else if (container2 instanceof ChildFrameSDI) {
                bl = ((ChildFrameSDI)container2).getTitle().equals(string);
            }
            if (!bl) continue;
            container = container2;
            break;
        }
        return container;
    }

    public boolean containsWindow(Class clazz) {
        return this.getWindow(clazz) != null;
    }

    public boolean containsWindow(String string) {
        return this.getWindow(string) != null;
    }

    public void minimizeWindows() {
        Iterator iterator = this.getWindowList();
        while (iterator.hasNext()) {
            Container container = (Container)iterator.next();
            try {
                if (container instanceof ChildFrameMDI) {
                    ((ChildFrameMDI)container).setIcon(true);
                    continue;
                }
                if (!(container instanceof ChildFrameSDI)) continue;
                ((ChildFrameSDI)container).setExtendedState(1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void restoreWindows() {
        Iterator iterator = this.getWindowList();
        while (iterator.hasNext()) {
            Container container = (Container)iterator.next();
            try {
                if (container instanceof ChildFrameMDI) {
                    ((ChildFrameMDI)container).setIcon(false);
                    continue;
                }
                if (!(container instanceof ChildFrameSDI)) continue;
                ((ChildFrameSDI)container).setExtendedState(0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void windowListChanged() {
        this.createWindowMenu();
    }

    protected synchronized void createWindowMenu() {
        this.jMenuWindows.removeAll();
        JMenuItem jMenuItem = new JMenuItem("Minimize");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.minimizeWindows();
            }
        });
        this.jMenuWindows.add(jMenuItem);
        jMenuItem = new JMenuItem("Restore");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.restoreWindows();
            }
        });
        this.jMenuWindows.add(jMenuItem);
        this.jMenuWindows.addSeparator();
        int n = this.jMenuWindows.getMenuComponentCount() - 1;
        Iterator iterator = this.getWindowList();
        this.jMenuWindows.setVisible(iterator.hasNext());
        while (iterator.hasNext()) {
            Container container = (Container)iterator.next();
            if (container instanceof ChildFrameMDI) {
                jMenuItem = new JMenuItem(((ChildFrameMDI)container).getTitle());
            } else if (container instanceof ChildFrameSDI) {
                jMenuItem = new JMenuItem(((ChildFrameSDI)container).getTitle());
            }
            this.insertMenuItem(this.jMenuWindows, jMenuItem, n);
            jMenuItem.setActionCommand(Integer.toString(container.hashCode()));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Container container = null;
                    Iterator iterator = Main.this.getWindowList();
                    while (iterator.hasNext()) {
                        container = (Container)iterator.next();
                        String string = Integer.toString(container.hashCode());
                        if (!string.equals(actionEvent.getActionCommand())) continue;
                        Main.this.showWindow(container);
                        break;
                    }
                    Main.this.showWindow(container);
                }
            });
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.paint(this.getGraphics());
        }
    }

    public static void createSingleton(String[] stringArray) {
        if (m_MainSingleton == null) {
            m_MainSingleton = new Main();
        }
        try {
            m_MainSingleton.setOptions(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (int i = 0; i < m_StartupListeners.size(); ++i) {
            ((StartUpListener)m_StartupListeners.elementAt(i)).startUpComplete();
        }
    }

    public static Main getSingleton() {
        return m_MainSingleton;
    }

    public static void addStartupListener(StartUpListener startUpListener) {
        m_StartupListeners.add(startUpListener);
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        String string = "";
        for (int i = 0; i < TAGS_GUI.length; ++i) {
            SelectedTag selectedTag = new SelectedTag(TAGS_GUI[i].getID(), TAGS_GUI);
            string = string + "\t" + selectedTag.getSelectedTag().getIDStr() + " = " + selectedTag.getSelectedTag().getReadable() + "\n";
        }
        vector.addElement(new Option("\tDetermines the layout of the GUI:\n" + string + "\t(default: " + new SelectedTag(0, TAGS_GUI) + ")", "gui", 1, "-gui " + Tag.toOptionList(TAGS_GUI)));
        return vector.elements();
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-gui");
        vector.add("" + this.getGUIType());
        return vector.toArray(new String[vector.size()]);
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption("gui", stringArray);
        if (string.length() != 0) {
            this.setGUIType(new SelectedTag(string, TAGS_GUI));
        } else {
            this.setGUIType(new SelectedTag(0, TAGS_GUI));
        }
    }

    public void setGUIType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_GUI) {
            this.m_GUIType = selectedTag.getSelectedTag().getID();
            this.initGUI();
        }
    }

    public SelectedTag getGUIType() {
        return new SelectedTag(this.m_GUIType, TAGS_GUI);
    }

    public static void main(String[] stringArray) {
        Logger.log(Logger.Level.INFO, "Logging started");
        LookAndFeel.setLookAndFeel();
        try {
            Object object;
            Object object2;
            if (Utils.getFlag('h', stringArray)) {
                System.out.println();
                System.out.println("Help requested.");
                System.out.println();
                System.out.println("General options:");
                System.out.println();
                System.out.println("-h");
                System.out.println("\tprints this help screen");
                System.out.println();
                object2 = new Main().listOptions();
                while (object2.hasMoreElements()) {
                    object = (Option)object2.nextElement();
                    System.out.println(((Option)object).synopsis());
                    System.out.println(((Option)object).description());
                }
                System.out.println();
                System.exit(0);
            }
            Main.addStartupListener(new StartUpListener(){

                public void startUpComplete() {
                    m_MainCommandline = Main.getSingleton();
                    m_MainCommandline.setVisible(true);
                }
            });
            Main.addStartupListener(new StartUpListener(){

                public void startUpComplete() {
                    SplashWindow.disposeSplash();
                }
            });
            SplashWindow.splash(ClassLoader.getSystemResource("weka/gui/images/weka_splash.gif"));
            object2 = (String[])stringArray.clone();
            object = new Thread((String[])object2){
                final /* synthetic */ String[] val$options;
                {
                    this.val$options = stringArray;
                }

                public void run() {
                    SplashWindow.invokeMethod(Main.class.getName(), "createSingleton", this.val$options);
                }
            };
            ((Thread)object).start();
            Thread thread = new Thread(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(4000L);
                                System.gc();
                                if (!m_Memory.isOutOfMemory()) continue;
                                m_MainCommandline = null;
                                System.gc();
                                m_Memory.stopThreads();
                                System.err.println("\ndisplayed message:");
                                m_Memory.showOutOfMemory();
                                System.err.println("\nexiting");
                                System.exit(-1);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            thread.setPriority(10);
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static {
        m_StartupListeners = new Vector();
        m_Memory = new Memory(true);
        m_LogWindow = new LogWindow();
    }

    public static class ChildFrameMDI
    extends JInternalFrame {
        private static final long serialVersionUID = 3772573515346899959L;
        protected Main m_Parent;

        public ChildFrameMDI(Main main, String string) {
            super(string, true, true, true, true);
            this.m_Parent = main;
            this.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                    if (ChildFrameMDI.this.getParentFrame() != null) {
                        ChildFrameMDI.this.getParentFrame().createTitle(ChildFrameMDI.this.getTitle());
                    }
                }
            });
            if (this.getParentFrame() != null) {
                this.getParentFrame().addChildFrame(this);
                this.getParentFrame().jDesktopPane.add(this);
            }
        }

        public Main getParentFrame() {
            return this.m_Parent;
        }

        public void dispose() {
            if (this.getParentFrame() != null) {
                this.getParentFrame().removeChildFrame(this);
                this.getParentFrame().createTitle("");
            }
            super.dispose();
        }
    }

    public static class ChildFrameSDI
    extends JFrame {
        private static final long serialVersionUID = 8588293938686425618L;
        protected Main m_Parent;

        public ChildFrameSDI(Main main, String string) {
            super(string);
            this.m_Parent = main;
            this.addWindowListener(new WindowAdapter(){

                public void windowActivated(WindowEvent windowEvent) {
                    if (ChildFrameSDI.this.getParentFrame() != null) {
                        ChildFrameSDI.this.getParentFrame().createTitle(ChildFrameSDI.this.getTitle());
                    }
                }
            });
            if (this.getParentFrame() != null) {
                this.getParentFrame().addChildFrame(this);
                this.setIconImage(this.getParentFrame().getIconImage());
            }
        }

        public Main getParentFrame() {
            return this.m_Parent;
        }

        public void dispose() {
            if (this.getParentFrame() != null) {
                this.getParentFrame().removeChildFrame(this);
                this.getParentFrame().createTitle("");
            }
            super.dispose();
        }
    }

    public static class BackgroundDesktopPane
    extends JDesktopPane {
        private static final long serialVersionUID = 2046713123452402745L;
        protected Image m_Background;

        public BackgroundDesktopPane(String string) {
            try {
                this.m_Background = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.m_Background != null) {
                graphics.setColor(Color.WHITE);
                graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                int n = this.m_Background.getWidth(null);
                int n2 = this.m_Background.getHeight(null);
                int n3 = (this.getWidth() - n) / 2;
                int n4 = (this.getHeight() - n2) / 2;
                graphics.drawImage(this.m_Background, n3, n4, n, n2, this);
            }
        }
    }
}

